/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.impl.AbstractNodeStateProvider;
import com.vaadin.flow.dom.impl.ShadowRootStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractPropertyMap;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.internal.nodefeature.TextBindingFeature;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

public class BasicElementStateProvider
extends AbstractNodeStateProvider {
    private static BasicElementStateProvider instance = new BasicElementStateProvider();
    private static Class<? extends NodeFeature>[] features = new Class[]{ElementData.class, ElementAttributeMap.class, ElementChildrenList.class, ElementPropertyMap.class, ElementListenerMap.class, ElementClassList.class, ElementStylePropertyMap.class, ComponentMapping.class, PolymerServerEventHandlers.class, ClientCallableHandlers.class, PolymerEventListenerMap.class, ShadowRootData.class, AttachExistingElementFeature.class, VirtualChildrenList.class, ReturnChannelMap.class, InertData.class, TextBindingFeature.class, SignalBindingFeature.class};

    private BasicElementStateProvider() {
    }

    public static BasicElementStateProvider get() {
        return instance;
    }

    public static StateNode createStateNode(String tag) {
        assert (ElementUtil.isValidTagName(tag)) : "Invalid tag name " + tag;
        StateNode node = new StateNode(Collections.singletonList(ElementData.class), features);
        node.getFeature(ElementData.class).setTag(tag);
        if (tag.equals("svg")) {
            node.getFeature(ElementData.class).setNamespace("http://www.w3.org/2000/svg");
        } else if (tag.equals("math")) {
            node.getFeature(ElementData.class).setNamespace("http://www.w3.org/1998/Math/MathML");
        }
        return node;
    }

    @Override
    public boolean supports(StateNode node) {
        if (!super.supports(node)) {
            return false;
        }
        return node.getFeature(ElementData.class).getTag() != null;
    }

    @Override
    public String getTag(StateNode node) {
        return BasicElementStateProvider.getDataFeature(node).getTag();
    }

    private static ElementData getDataFeature(StateNode node) {
        return node.getFeature(ElementData.class);
    }

    private static ElementAttributeMap getAttributeFeature(StateNode node) {
        return node.getFeature(ElementAttributeMap.class);
    }

    private static Optional<ElementAttributeMap> getAttributeFeatureIfInitialized(StateNode node) {
        return node.getFeatureIfInitialized(ElementAttributeMap.class);
    }

    private static ElementPropertyMap getPropertyFeature(StateNode node) {
        return node.getFeature(ElementPropertyMap.class);
    }

    private static Optional<ElementPropertyMap> getPropertyFeatureIfInitialized(StateNode node) {
        return node.getFeatureIfInitialized(ElementPropertyMap.class);
    }

    @Override
    public void setAttribute(StateNode node, String attribute, String value) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        BasicElementStateProvider.getAttributeFeature(node).set(attribute, value);
    }

    @Override
    public void bindAttributeSignal(Element owner, String attribute, Signal<String> signal) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        BasicElementStateProvider.getAttributeFeature(owner.getNode()).bindSignal(owner, attribute, signal);
    }

    @Override
    public String getAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        return BasicElementStateProvider.getAttributeFeatureIfInitialized(node).map(feature -> feature.get(attribute)).orElse(null);
    }

    @Override
    public boolean hasAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        Optional<ElementAttributeMap> maybeFeature = BasicElementStateProvider.getAttributeFeatureIfInitialized(node);
        return maybeFeature.isPresent() && maybeFeature.get().has(attribute);
    }

    @Override
    public void removeAttribute(StateNode node, String attribute) {
        assert (attribute != null);
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        BasicElementStateProvider.getAttributeFeatureIfInitialized(node).map(feature -> feature.remove(attribute));
    }

    @Override
    public Stream<String> getAttributeNames(StateNode node) {
        return BasicElementStateProvider.getAttributeFeatureIfInitialized(node).map(ElementAttributeMap::attributes).orElseGet(Stream::empty);
    }

    @Override
    public Node getParent(StateNode node) {
        StateNode parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        return super.getParent(node);
    }

    @Override
    public DomListenerRegistration addEventListener(StateNode node, String eventType, DomEventListener listener) {
        ElementListenerMap listeners = node.getFeature(ElementListenerMap.class);
        return listeners.add(eventType, listener);
    }

    public static Collection<Class<? extends NodeFeature>> getFeatures() {
        return Collections.unmodifiableCollection(Arrays.asList(BasicElementStateProvider.get().getProviderFeatures()));
    }

    @Override
    public Serializable getProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        return BasicElementStateProvider.getPropertyFeatureIfInitialized(node).map(feature -> feature.getProperty(name)).orElse(null);
    }

    @Override
    public void setProperty(StateNode node, String name, Serializable value, boolean emitChange) {
        assert (node != null);
        assert (name != null);
        ElementPropertyMap propertyFeature = BasicElementStateProvider.getPropertyFeature(node);
        if (propertyFeature.hasSignal(name)) {
            throw new BindingActiveException(String.format("setProperty is not allowed while a binding for the property '%s' exists.", name));
        }
        propertyFeature.setProperty(name, value, emitChange);
    }

    @Override
    public void bindPropertySignal(Element owner, String name, Signal<?> signal) {
        assert (owner != null);
        assert (name != null);
        BasicElementStateProvider.getPropertyFeature(owner.getNode()).bindSignal(owner, name, signal);
    }

    @Override
    public void removeProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        BasicElementStateProvider.getPropertyFeatureIfInitialized(node).ifPresent(propertyMap -> {
            if (propertyMap.hasSignal(name)) {
                throw new BindingActiveException(String.format("removeProperty is not allowed while a binding for the property '%s' exists.", name));
            }
            propertyMap.removeProperty(name);
        });
    }

    @Override
    public boolean hasProperty(StateNode node, String name) {
        assert (node != null);
        assert (name != null);
        Optional<ElementPropertyMap> maybeFeature = BasicElementStateProvider.getPropertyFeatureIfInitialized(node);
        if (maybeFeature.isPresent()) {
            return maybeFeature.get().hasProperty(name);
        }
        return false;
    }

    @Override
    public Stream<String> getPropertyNames(StateNode node) {
        assert (node != null);
        return BasicElementStateProvider.getPropertyFeatureIfInitialized(node).map(AbstractPropertyMap::getPropertyNames).orElseGet(Stream::empty);
    }

    @Override
    public boolean isTextNode(StateNode node) {
        return false;
    }

    @Override
    public String getTextContent(StateNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTextContent(StateNode node, String textContent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassList getClassList(StateNode node) {
        return node.getFeature(ElementClassList.class).getClassList();
    }

    @Override
    public Style getStyle(StateNode node) {
        return node.getFeature(ElementStylePropertyMap.class).getStyle();
    }

    @Override
    public void setAttribute(StateNode node, String attribute, AbstractStreamResource receiver) {
        assert (node != null);
        assert (attribute != null);
        assert (receiver != null);
        BasicElementStateProvider.getAttributeFeature(node).setResource(attribute, receiver);
    }

    @Override
    public Registration addPropertyChangeListener(StateNode node, String name, PropertyChangeListener listener) {
        return BasicElementStateProvider.getPropertyFeature(node).addPropertyChangeListener(name, listener);
    }

    @Override
    public StateNode getShadowRoot(StateNode node) {
        return node.getFeatureIfInitialized(ShadowRootData.class).map(ShadowRootData::getShadowRoot).orElse(null);
    }

    @Override
    public StateNode attachShadow(StateNode node) {
        assert (this.getShadowRoot(node) == null);
        return ShadowRootStateProvider.get().createShadowRootNode(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(StateNode node, NodeVisitor visitor) {
        boolean visitDescendants;
        Element element = Element.get(node);
        ElementData data = node.getFeature(ElementData.class);
        BaseJsonNode payload = data.getPayload();
        if (payload instanceof JsonNode) {
            BaseJsonNode object = payload;
            String type = object.get("type").asString();
            if ("inMemory".equals(type)) {
                visitDescendants = visitor.visit(NodeVisitor.ElementType.VIRTUAL, element);
            } else {
                if (!"@id".equals(type) && !"subTemplate".equals(type) && !"@name".equals(type)) throw new IllegalStateException("Unexpected payload type : " + type);
                visitDescendants = visitor.visit(NodeVisitor.ElementType.VIRTUAL_ATTACHED, element);
            }
        } else {
            if (payload != null) throw new IllegalStateException("Unexpected payload in element data : " + payload.toString());
            visitDescendants = visitor.visit(NodeVisitor.ElementType.REGULAR, element);
        }
        if (!visitDescendants) return;
        this.visitDescendants(element, visitor);
        element.getShadowRoot().ifPresent(root -> root.accept(visitor));
    }

    @Override
    public void bindVisibleSignal(Element owner, Signal<Boolean> signal) {
        assert (owner.getNode().hasFeature(ElementData.class));
        owner.getNode().getFeature(ElementData.class).bindVisibleSignal(owner, signal);
    }

    @Override
    public void setVisible(StateNode node, boolean visible) {
        assert (node.hasFeature(ElementData.class));
        ElementData feature = node.getFeature(ElementData.class);
        if (feature.hasSignal("visible")) {
            throw new BindingActiveException("setVisible is not allowed while a binding exists.");
        }
        node.getFeature(ElementData.class).setVisible(visible);
    }

    @Override
    public boolean isVisible(StateNode node) {
        assert (node.hasFeature(ElementData.class));
        return node.getFeature(ElementData.class).isVisible();
    }

    @Override
    protected Node<?> getNode(StateNode node) {
        assert (this.supports(node));
        return Element.get(node);
    }

    @Override
    protected Class<? extends NodeFeature>[] getProviderFeatures() {
        return features;
    }

    protected Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

