/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.ServletContext;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RouteRegistryMenuAccessTest {
    private ApplicationRouteRegistry registry;
    private VaadinRequest vaadinRequest;

    @Before
    public void init() {
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext((ServletContext)Mockito.mock(ServletContext.class)));
        this.vaadinRequest = (VaadinRequest)Mockito.mock(VaadinRequest.class);
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withoutRequest_returnEmpty() {
        Assert.assertEquals((String)"No accessible menu routes should be available without VaadinService.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(null, null).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withoutVaadinService_returnEmpty() {
        Mockito.when((Object)this.vaadinRequest.getService()).thenReturn(null);
        Assert.assertEquals((String)"No accessible menu routes should be available without VaadinService.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, null).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withoutNavAccessControl_noMenuRoutes() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.ALWAYS);
        this.registry.clean();
        this.registry.setRoute("home", MyRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"No accessible menu routes should be available.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, null).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_populateClientSideMenuIsFalse_noMenuRoute() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.NEVER);
        this.registry.clean();
        this.registry.setRoute("home", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"No routes should be registered.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, null).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_populateClientSideMenuIsAutomatic_oneMenuRoute() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.AUTOMATIC);
        this.registry.clean();
        this.registry.setRoute("home", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        try (MockedStatic config = Mockito.mockStatic(ApplicationConfiguration.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            config.when(() -> ApplicationConfiguration.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn(Mockito.mock(ApplicationConfiguration.class));
            Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, null).size());
        }
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withoutNavAccessControl_oneMenuRoute() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.ALWAYS);
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"One accessible menu routes should be available.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, List.of()).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withNavAccessControlWithoutRequest_noAccessibleMenuRoute() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.ALWAYS);
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"No accessible menu routes should be available without an active request.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, List.of(new NavigationAccessControl())).size());
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withNavAccessControl_anonymous() {
        this.testAsAnonymous(new BeforeEnterListener[]{new NavigationAccessControl()});
    }

    @Test
    public void getRegisteredAccessibleMenuRoutes_withNavAccessControl_admin() {
        this.testAsAdmin(new BeforeEnterListener[]{new NavigationAccessControl()});
    }

    private void setupForAnonymous() {
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.ALWAYS);
    }

    private void testAsAnonymous(BeforeEnterListener ... withAccessControls) {
        this.setupForAnonymous();
        List<BeforeEnterListener> accessControls = Stream.of(withAccessControls).toList();
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"No accessible menu routes should be available due to lack of security annotation.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRouteAnonymousAllowed.class, Collections.emptyList());
        Assert.assertEquals((String)"One accessible menu routes should be available.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoutePermitAll.class, Collections.emptyList());
        Assert.assertEquals((String)"no accessible menu routes should be available for anonymous user.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRouteRolesAllowedAdmin.class, Collections.emptyList());
        Assert.assertEquals((String)"No accessible menu routes should be available without admin role.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
    }

    private void setupForAdmin(VaadinRequest vaadinRequest) {
        Mockito.when((Object)vaadinRequest.getUserPrincipal()).thenReturn((Object)new Principal(this){

            @Override
            public String getName() {
                return "vaadin_user";
            }
        });
        Mockito.when((Object)vaadinRequest.isUserInRole("admin")).thenReturn((Object)true);
        this.mockInstantiator(MenuAccessControl.PopulateClientMenu.ALWAYS);
    }

    private void testAsAdmin(BeforeEnterListener ... withAccessControls) {
        this.setupForAdmin(this.vaadinRequest);
        List<BeforeEnterListener> accessControls = Stream.of(withAccessControls).toList();
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"One route should be registered.", (long)1L, (long)this.registry.getRegisteredRoutes().size());
        Assert.assertEquals((String)"No accessible menu routes should be available due to lack of security annotation.", (long)0L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRouteAnonymousAllowed.class, Collections.emptyList());
        Assert.assertEquals((String)"One accessible menu routes should be available.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRoutePermitAll.class, Collections.emptyList());
        Assert.assertEquals((String)"One accessible menu route should be available.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
        this.registry.clean();
        this.registry.setRoute("hasmenu", MyMenuRouteRolesAllowedAdmin.class, Collections.emptyList());
        Assert.assertEquals((String)"One accessible menu route should be available.", (long)1L, (long)this.registry.getRegisteredAccessibleMenuRoutes(this.vaadinRequest, accessControls).size());
    }

    private void mockInstantiator(final MenuAccessControl.PopulateClientMenu populateClientSideMenu) {
        VaadinService vaadinService = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)this.vaadinRequest.getService()).thenReturn((Object)vaadinService);
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        Mockito.when((Object)vaadinService.getInstantiator()).thenReturn((Object)instantiator);
        Router router = (Router)Mockito.mock(Router.class);
        Mockito.when((Object)vaadinService.getRouter()).thenReturn((Object)router);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)instantiator.getMenuAccessControl()).thenReturn((Object)new MenuAccessControl(){

            public void setPopulateClientSideMenu(MenuAccessControl.PopulateClientMenu populateClientSideMenu2) {
            }

            public MenuAccessControl.PopulateClientMenu getPopulateClientSideMenu() {
                return populateClientSideMenu;
            }
        });
    }

    @Tag(value="div")
    @Route(value="home")
    protected static class MyRoute
    extends Component {
        protected MyRoute() {
        }
    }

    @Tag(value="div")
    @Route(value="hasmenu")
    @Menu
    protected static class MyMenuRoute
    extends Component {
        protected MyMenuRoute() {
        }
    }

    @AnonymousAllowed
    protected static class MyMenuRouteAnonymousAllowed
    extends MyMenuRoute {
        protected MyMenuRouteAnonymousAllowed() {
        }
    }

    @PermitAll
    protected static class MyMenuRoutePermitAll
    extends MyMenuRoute {
        protected MyMenuRoutePermitAll() {
        }
    }

    @RolesAllowed(value={"admin"})
    protected static class MyMenuRouteRolesAllowedAdmin
    extends MyMenuRoute {
        protected MyMenuRouteRolesAllowedAdmin() {
        }
    }
}

