/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.server.communication.rpc.NavigationRpcHandler;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class NavigationRpcHandlerTest {
    private UI ui;
    private History.HistoryStateChangeHandler historyStateChangeHandler;
    private NavigationRpcHandler rpcHandler;
    private ObjectNode invocation;

    @Before
    public void setup() {
        this.ui = new UI();
        this.historyStateChangeHandler = (History.HistoryStateChangeHandler)Mockito.mock(History.HistoryStateChangeHandler.class);
        this.ui.getPage().getHistory().setHistoryStateChangeHandler(this.historyStateChangeHandler);
        this.ui.add(new Component[]{new RouterLink()});
        this.rpcHandler = new NavigationRpcHandler();
        this.invocation = JacksonUtils.createObjectNode();
        this.invocation.set("location", JacksonUtils.createNode((Object)"foo"));
    }

    @Test
    public void handleRouterLinkClick_navigationTriggered() {
        this.invocation.put("link", true);
        this.rpcHandler.handle(this.ui, (JsonNode)this.invocation);
        ((History.HistoryStateChangeHandler)Mockito.verify((Object)this.historyStateChangeHandler, (VerificationMode)Mockito.times((int)1))).onHistoryStateChange((History.HistoryStateChangeEvent)Mockito.any(History.HistoryStateChangeEvent.class));
    }

    @Test
    public void handleRouterLinkClick_uiIsInert_navigationTriggered() {
        this.ui.addModal((Component)new RouterLink());
        this.ui.getInternals().getStateTree().collectChanges(nodeChange -> {});
        this.invocation.put("link", true);
        this.rpcHandler.handle(this.ui, (JsonNode)this.invocation);
        ((History.HistoryStateChangeHandler)Mockito.verify((Object)this.historyStateChangeHandler, (VerificationMode)Mockito.times((int)1))).onHistoryStateChange((History.HistoryStateChangeEvent)Mockito.any(History.HistoryStateChangeEvent.class));
    }

    @Test
    public void handleHistoryChange_uiIsInert_navigationTriggered() {
        this.ui.addModal((Component)new RouterLink());
        this.rpcHandler.handle(this.ui, (JsonNode)this.invocation);
        ((History.HistoryStateChangeHandler)Mockito.verify((Object)this.historyStateChangeHandler, (VerificationMode)Mockito.times((int)1))).onHistoryStateChange((History.HistoryStateChangeEvent)Mockito.any(History.HistoryStateChangeEvent.class));
    }
}

