/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.util;

import com.vaadin.flow.server.communication.IndexHtmlRequestHandlerTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class TestUtil {
    public static void assertArrays(Object[] actualObjects, Object[] expectedObjects) {
        Assert.assertEquals((String)"Actual contains a different number of values than was expected", (long)expectedObjects.length, (long)actualObjects.length);
        for (int i = 0; i < actualObjects.length; ++i) {
            Object actual = actualObjects[i];
            Object expected = expectedObjects[i];
            Assert.assertEquals((String)("Item[" + i + "] does not match"), (Object)expected, (Object)actual);
        }
    }

    public static void assertIterableEquals(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> i1 = iterable1.iterator();
        Iterator<?> i2 = iterable2.iterator();
        while (i1.hasNext()) {
            Object o1 = i1.next();
            if (!i2.hasNext()) {
                Assert.fail((String)("The second iterable contains fewer items than the first. The object " + String.valueOf(o1) + " has no match in the second iterable."));
            }
            Object o2 = i2.next();
            Assert.assertEquals(o1, o2);
        }
        if (i2.hasNext()) {
            Assert.fail((String)("The second iterable contains more items than the first. The object " + String.valueOf(i2.next()) + " has no match in the first iterable."));
        }
    }

    public static boolean isGarbageCollected(WeakReference<?> ref) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            System.gc();
            if (ref.get() != null) continue;
            return true;
        }
        return false;
    }

    public static void createIndexHtmlStub(File projectRootFolder) throws IOException {
        TestUtil.createStubFileInFrontend(projectRootFolder, "index.html");
    }

    public static void createWebComponentHtmlStub(File projectRootFolder) throws IOException {
        TestUtil.createStubFileInFrontend(projectRootFolder, "web-component.html");
    }

    public static void createStubFileInFrontend(File projectRootFolder, String stubFileName) throws IOException {
        try (InputStream indexStream = IndexHtmlRequestHandlerTest.class.getClassLoader().getResourceAsStream("frontend/" + stubFileName);){
            String indexHtmlContent = IOUtils.toString((InputStream)Objects.requireNonNull(indexStream), (Charset)StandardCharsets.UTF_8);
            File indexHtml = new File(new File(projectRootFolder, "./src/main/frontend/"), stubFileName);
            FileUtils.forceMkdirParent((File)indexHtml);
            FileUtils.writeStringToFile((File)indexHtml, (String)indexHtmlContent, (Charset)StandardCharsets.UTF_8);
        }
    }

    public static void createStatsJsonStub(File projectRootFolder) throws IOException {
        String content = "{\"npmModules\": {}, \"entryScripts\": [\"foo.js\"], \"packageJsonHash\": \"42\",\"indexHtmlGenerated\": []}";
        TestUtil.createStubFile(projectRootFolder, "target/dev-bundle/config/stats.json", content);
    }

    public static void createStylesCssStubInBundle(File projectRootFolder, String themeName, String content) throws IOException {
        TestUtil.createStubFile(projectRootFolder, "target/dev-bundle/assets/themes/" + themeName + "/styles.css", content);
    }

    public static void createThemeJs(File projectRootFolder) throws IOException {
        String content = "import {applyTheme as _applyTheme} from './theme-my-theme.generated.js';export const applyTheme = _applyTheme;";
        TestUtil.createStubFile(projectRootFolder, "./src/main/frontend/generated/theme.js", content);
    }

    public static void createStyleCssStubInFrontend(File projectRootFolder, String themeName, String content) throws IOException {
        TestUtil.createStubFile(projectRootFolder, "./src/main/frontend/themes/" + themeName + "/styles.css", content);
    }

    public static void createStubFile(File projectRootFolder, String relativePath, String content) throws IOException {
        File stub = new File(projectRootFolder, relativePath);
        FileUtils.forceMkdirParent((File)stub);
        FileUtils.writeStringToFile((File)stub, (String)content, (Charset)StandardCharsets.UTF_8);
    }
}

