/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.util;

import com.vaadin.flow.server.AbstractDeploymentConfiguration;
import com.vaadin.flow.server.SessionLockCheckStrategy;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public class MockDeploymentConfiguration
extends AbstractDeploymentConfiguration {
    private boolean productionMode = false;
    private boolean reuseDevServer = true;
    private boolean xsrfProtectionEnabled = true;
    private int heartbeatInterval = 300;
    private int maxMessageSuspendTimeout = 5000;
    private int webComponentDisconnect = 300;
    private boolean closeIdleSessions = false;
    private PushMode pushMode = PushMode.DISABLED;
    private String pushServletMapping = "";
    private Properties initParameters = new Properties();
    private Map<String, String> applicationOrSystemProperty = new HashMap<String, String>();
    private boolean syncIdCheckEnabled = true;
    private boolean sendUrlsAsParameters = true;
    private boolean brotli = false;
    private boolean eagerServerLoad = false;
    private boolean devModeLiveReloadEnabled = false;
    private boolean devToolsEnabled = true;
    private boolean isReactEnabled = true;
    private SessionLockCheckStrategy sessionLockCheckStrategy = SessionLockCheckStrategy.ASSERT;
    private File projectFolder = null;

    public MockDeploymentConfiguration() {
        super(Collections.emptyMap());
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public boolean isRequestTiming() {
        return !this.productionMode;
    }

    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    public void setReuseDevServer(boolean reuseDevServer) {
        this.reuseDevServer = reuseDevServer;
    }

    public boolean reuseDevServer() {
        return this.reuseDevServer;
    }

    public boolean isXsrfProtectionEnabled() {
        return this.xsrfProtectionEnabled;
    }

    public boolean isSyncIdCheckEnabled() {
        return this.syncIdCheckEnabled;
    }

    public void setSyncIdCheckEnabled(boolean syncIdCheckEnabled) {
        this.syncIdCheckEnabled = syncIdCheckEnabled;
    }

    public void setXsrfProtectionEnabled(boolean xsrfProtectionEnabled) {
        this.xsrfProtectionEnabled = xsrfProtectionEnabled;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int getMaxMessageSuspendTimeout() {
        return this.maxMessageSuspendTimeout;
    }

    public int getWebComponentDisconnect() {
        return this.webComponentDisconnect;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public boolean isCloseIdleSessions() {
        return this.closeIdleSessions;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public void setCloseIdleSessions(boolean closeIdleSessions) {
        this.closeIdleSessions = closeIdleSessions;
    }

    public PushMode getPushMode() {
        return this.pushMode;
    }

    public void setPushMode(PushMode pushMode) {
        this.pushMode = pushMode;
    }

    public String getPushServletMapping() {
        return this.pushServletMapping;
    }

    public void setPushServletMapping(String pushServletMapping) {
        this.pushServletMapping = pushServletMapping;
    }

    public Properties getInitParameters() {
        return this.initParameters;
    }

    public void setInitParameter(String key, String value) {
        this.initParameters.setProperty(key, value);
    }

    public void setApplicationOrSystemProperty(String key, String value) {
        this.applicationOrSystemProperty.put(key, value);
    }

    public <T> T getApplicationOrSystemProperty(String propertyName, T defaultValue, Function<String, T> converter) {
        if (this.applicationOrSystemProperty.containsKey(propertyName)) {
            return converter.apply(this.applicationOrSystemProperty.get(propertyName));
        }
        return defaultValue;
    }

    public boolean isSendUrlsAsParameters() {
        return this.sendUrlsAsParameters;
    }

    public boolean isBrotli() {
        return this.brotli;
    }

    public void setBrotli(boolean brotli) {
        this.brotli = brotli;
    }

    public boolean isEagerServerLoad() {
        return this.eagerServerLoad;
    }

    public boolean isDevModeLiveReloadEnabled() {
        return this.isDevToolsEnabled() && this.devModeLiveReloadEnabled;
    }

    public boolean isDevToolsEnabled() {
        return this.devToolsEnabled;
    }

    public void setEagerServerLoad(boolean includeBootsrapInitialUidl) {
        this.eagerServerLoad = includeBootsrapInitialUidl;
    }

    public void setDevModeLiveReloadEnabled(boolean devModeLiveReloadEnabled) {
        this.devModeLiveReloadEnabled = devModeLiveReloadEnabled;
    }

    public void setDevToolsEnabled(boolean devToolsEnabled) {
        this.devToolsEnabled = devToolsEnabled;
    }

    public void setProjectFolder(File projectFolder) {
        this.projectFolder = projectFolder;
    }

    public SessionLockCheckStrategy getSessionLockCheckStrategy() {
        return this.sessionLockCheckStrategy;
    }

    public void setLockCheckStrategy(SessionLockCheckStrategy sessionLockCheckStrategy) {
        this.sessionLockCheckStrategy = sessionLockCheckStrategy;
    }

    public boolean isReactEnabled() {
        return this.isReactEnabled;
    }

    public void setReactEnabled(boolean isReactEnabled) {
        this.isReactEnabled = isReactEnabled;
    }
}

