/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.PropertyData;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyConfigurationImplTest {
    PropertyConfigurationImpl<MyComponent, Integer> intPropertyConf;

    @Before
    public void init() {
        this.intPropertyConf = new PropertyConfigurationImpl(MyComponent.class, "int", Integer.class, (Serializable)Integer.valueOf(1));
    }

    @Test
    public void onChange() {
        this.intPropertyConf.onChange(MyComponent::setInt);
        MyComponent myComponent = new MyComponent();
        this.intPropertyConf.getOnChangeHandler().accept((Object)myComponent, (Object)5);
        Assert.assertEquals((String)"onChangeHandler should have been set and value updated", (long)5L, (long)myComponent.value);
    }

    @Test(expected=IllegalStateException.class)
    public void onChange_throwsIfCalledTwice() {
        this.intPropertyConf.onChange(MyComponent::setInt);
        this.intPropertyConf.onChange(MyComponent::setInt);
    }

    @Test
    public void readOnly() {
        this.intPropertyConf.readOnly();
        PropertyData data = this.intPropertyConf.getPropertyData();
        Assert.assertEquals((String)"default value is 1", (long)1L, (long)((Integer)data.getDefaultValue()).intValue());
        Assert.assertTrue((String)"read-only flag should have been set to true", (boolean)data.isReadOnly());
    }

    @Tag(value="for-reasons")
    private static final class MyComponent
    extends Component {
        private int value;

        private MyComponent() {
        }

        public void setInt(int newValue) {
            this.value = newValue;
        }
    }
}

