/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.TargetElement;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.AppShellSettings;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.startup.AppShellPredicate;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Transport;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.CoreMatchers;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.simple.SimpleLoggerFactory;

@NotThreadSafe
public class VaadinAppShellInitializerTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private VaadinAppShellInitializer initializer;
    private ServletContext servletContext;
    private VaadinServletContext context;
    private Set<Class<?>> classes;
    private Document document;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private MockServletServiceSessionSetup mocks;
    private MockServletServiceSessionSetup.TestVaadinServletService service;
    private PushConfiguration pushConfiguration;
    private Logger logger;
    private ApplicationConfiguration appConfig;

    @Before
    public void setup() throws Exception {
        this.logger = this.mockLog(VaadinAppShellInitializer.class);
        this.mocks = new MockServletServiceSessionSetup();
        this.servletContext = this.mocks.getServletContext();
        this.appConfig = this.mockApplicationConfiguration();
        Lookup lookup = (Lookup)this.servletContext.getAttribute(Lookup.class.getName());
        Mockito.when((Object)((AppShellPredicate)lookup.lookup(AppShellPredicate.class))).thenReturn(AppShellConfigurator.class::isAssignableFrom);
        this.attributeMap.put(Lookup.class.getName(), this.servletContext.getAttribute(Lookup.class.getName()));
        this.attributeMap.put(ApplicationConfiguration.class.getName(), this.appConfig);
        this.service = this.mocks.getService();
        Mockito.when((Object)this.servletContext.getAttribute(Mockito.anyString())).then(invocationOnMock -> this.attributeMap.get(invocationOnMock.getArguments()[0].toString()));
        ((ServletContext)Mockito.doAnswer(invocationOnMock -> this.attributeMap.put(invocationOnMock.getArguments()[0].toString(), invocationOnMock.getArguments()[1])).when((Object)this.servletContext)).setAttribute(Mockito.anyString(), Mockito.any());
        ServletRegistration registration = (ServletRegistration)Mockito.mock(ServletRegistration.class);
        this.context = new VaadinServletContext(this.servletContext);
        this.classes = new HashSet();
        HashMap<String, ServletRegistration> registry = new HashMap<String, ServletRegistration>();
        registry.put("foo", registration);
        Mockito.when((Object)this.servletContext.getServletRegistrations()).thenReturn(registry);
        Mockito.when((Object)this.servletContext.getInitParameterNames()).thenReturn(Collections.emptyEnumeration());
        this.initializer = new VaadinAppShellInitializer();
        this.document = Document.createShell((String)"");
        this.pushConfiguration = (PushConfiguration)Mockito.mock(PushConfiguration.class);
    }

    @After
    public void teardown() throws Exception {
        AppShellRegistry.getInstance((VaadinContext)this.context).reset();
        this.clearIlogger();
        this.mocks.cleanup();
    }

    @Test
    public void should_not_modifyDocument_when_noAnnotatedAppShell() throws Exception {
        this.classes.add(MyAppShellWithoutAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Assert.assertEquals((long)0L, (long)this.document.head().children().size());
        Assert.assertEquals((long)0L, (long)this.document.body().children().size());
    }

    @Test
    public void should_not_modifyPushConfiguration_when_noAnnotatedAppShell() throws Exception {
        this.classes.add(MyAppShellWithoutAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyPushConfiguration(this.pushConfiguration);
        this.initializer.process(Collections.emptySet(), this.servletContext);
    }

    @Test
    public void should_not_throw_when_noClassesFound_null() throws Exception {
        this.initializer.process(null, this.servletContext);
    }

    @Test
    public void should_haveMetasAndBodySize_when_annotatedAppShell() throws Exception {
        this.classes.add(MyAppShellWithMultipleAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements elements = this.document.head().children();
        Assert.assertEquals((long)7L, (long)elements.size());
        Assert.assertEquals((Object)"text/css", (Object)((Element)elements.get(5)).attr("type"));
        Assert.assertEquals((Object)"body,#outlet{width:my-width;height:my-height;}", (Object)((Element)elements.get(5)).childNode(0).toString());
    }

    @Test
    public void should_haveInline_when_annotatedAppShell() throws Exception {
        this.classes.add(MyAppShellWithMultipleAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements headElements = this.document.head().children();
        Assert.assertEquals((long)7L, (long)headElements.size());
        Assert.assertEquals((Object)"text/css", (Object)((Element)headElements.get(0)).attr("type"));
        Assert.assertEquals((Object)"style", (Object)((Element)headElements.get(0)).tagName());
        Assert.assertTrue((boolean)((Element)headElements.get(0)).outerHtml().contains("#preloadedDiv"));
        Assert.assertEquals((Object)"foo", (Object)((Element)headElements.get(1)).attr("name"));
        Assert.assertEquals((Object)"lorem", (Object)((Element)headElements.get(2)).attr("name"));
        Assert.assertEquals((Object)"viewport", (Object)((Element)headElements.get(3)).attr("name"));
        Assert.assertEquals((Object)"title", (Object)((Element)headElements.get(4)).tagName());
        Assert.assertEquals((Object)"my-title", (Object)((Element)headElements.get(4)).childNode(0).toString());
        Assert.assertEquals((Object)"text/css", (Object)((Element)headElements.get(5)).attr("type"));
        Assert.assertEquals((Object)"style", (Object)((Element)headElements.get(5)).tagName());
        Assert.assertTrue((boolean)((Element)headElements.get(5)).outerHtml().contains("width:my-width"));
        Assert.assertTrue((boolean)((Element)headElements.get(5)).outerHtml().contains("height:my-height"));
        Assert.assertEquals((Object)"text/javascript", (Object)((Element)headElements.get(6)).attr("type"));
        Assert.assertEquals((Object)"script", (Object)((Element)headElements.get(6)).tagName());
        Assert.assertTrue((boolean)((Element)headElements.get(6)).outerHtml().contains("might not yet be accessible"));
        Elements bodyElements = this.document.body().children();
        Assert.assertEquals((long)1L, (long)bodyElements.size());
        Assert.assertEquals((Object)"text/javascript", (Object)((Element)bodyElements.get(0)).attr("type"));
        Assert.assertEquals((Object)"script", (Object)((Element)bodyElements.get(0)).tagName());
        Assert.assertTrue((boolean)((Element)bodyElements.get(0)).outerHtml().contains("window.messages.push"));
    }

    @Test
    public void should_modifyPushConfiguration_when_annotatedAppShell() throws Exception {
        this.classes.add(MyAppShellWithMultipleAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyPushConfiguration(this.pushConfiguration);
        ((PushConfiguration)Mockito.verify((Object)this.pushConfiguration)).setPushMode(PushMode.MANUAL);
        ((PushConfiguration)Mockito.verify((Object)this.pushConfiguration)).setTransport(Transport.WEBSOCKET);
    }

    @Test
    public void should_not_haveMetas_when_not_callingInitializer() throws Exception {
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements elements = this.document.head().children();
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void should_not_modifyPushConfiguration_when_not_callingInitializer() throws Exception {
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyPushConfiguration(this.pushConfiguration);
        ((PushConfiguration)Mockito.verify((Object)this.pushConfiguration, (VerificationMode)Mockito.never())).setPushMode((PushMode)Mockito.any(PushMode.class));
    }

    @Test
    public void should_reuseContextAppShell_when_creatingNewInstance() throws Exception {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        Assert.assertSame((Object)registry, (Object)AppShellRegistry.getInstance((VaadinContext)this.context));
    }

    @Test
    public void should_throw_when_offendingClass() throws Exception {
        this.exception.expect(InvalidApplicationConfigurationException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)"Found app shell configuration annotations in non"));
        this.exception.expectMessage(CoreMatchers.containsString((String)"- @Meta, @Inline, @Viewport, @BodySize, @Push, @Theme from"));
        this.classes.add(MyAppShellWithoutAnnotations.class);
        this.classes.add(OffendingClass.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void offendingEmbeddedThemeClass_shouldNotThrow() throws Exception {
        this.classes.add(NonOffendingExporter.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void should_throw_when_multipleAppShell() throws Exception {
        this.exception.expect(InvalidApplicationConfigurationException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)"Multiple classes implementing `AppShellConfigurator` were found"));
        this.classes.add(MyAppShellWithoutAnnotations.class);
        this.classes.add(MyAppShellWithMultipleAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void should_not_throw_when_interface_and_abstract_and_concrete_AppShell() throws Exception {
        this.classes.add(InterfaceAppShellWithoutAnnotations.class);
        this.classes.add(AbstractAppShellWithoutAnnotations.class);
        this.classes.add(MyAppShellWithoutAnnotations.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void should_not_throw_when_appShellAnnotationsAreAllowed_and_offendingClass() throws Exception {
        Mockito.when((Object)this.appConfig.getBooleanProperty("allow.appshell.annotations", false)).thenReturn((Object)true);
        this.classes.add(OffendingClass.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements elements = this.document.head().children();
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void styleSheetOnAppShell_injectedAsLinksInOrder() throws Exception {
        this.classes.add(MyAppShellWithStyleSheets.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assert.assertEquals((long)2L, (long)links.size());
        Assert.assertEquals((Object)"/my-styles.css", (Object)((Element)links.get(0)).attr("href"));
        Assert.assertEquals((Object)"https://cdn.example.com/ui.css", (Object)((Element)links.get(1)).attr("href"));
    }

    @Test
    public void duplicateStyleSheets_deduplicated() throws Exception {
        this.classes.add(MyAppShellWithDuplicateStyles.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/"));
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"/theme-base.css", (Object)((Element)links.get(0)).attr("href"));
    }

    @Test
    public void should_link_to_PWA_article() throws Exception {
        Mockito.when((Object)this.appConfig.getBooleanProperty("allow.appshell.annotations", false)).thenReturn((Object)true);
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        this.classes.add(OffendingPwaClass.class);
        this.initializer.process(this.classes, this.servletContext);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error((String)arg.capture());
        Assert.assertTrue((boolean)((String)arg.getValue()).contains("We changed the way you configure PWAs"));
    }

    @Test
    public void should_not_link_to_PWA_article() throws Exception {
        Mockito.when((Object)this.appConfig.getBooleanProperty("allow.appshell.annotations", false)).thenReturn((Object)true);
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        this.classes.add(OffendingNonPwaClass.class);
        this.initializer.process(this.classes, this.servletContext);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error((String)arg.capture());
        Assert.assertFalse((boolean)((String)arg.getValue()).contains("We changed the way you configure PWAs"));
        Assert.assertTrue((boolean)((String)arg.getValue()).contains("@Viewport"));
    }

    @Test(expected=InvalidApplicationConfigurationException.class)
    public void should_throwException_when_appShellExtendsComponent() throws Exception {
        this.classes.add(AppShellExtendingComponent.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void styleSheetOnComponent_notOffending() throws Exception {
        this.classes.add(ComponentWithStylesheet.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void multipleStyleSheetOnComponent_notOffending() throws Exception {
        this.classes.add(ComponentWithMultipleStylesheet.class);
        this.initializer.process(this.classes, this.servletContext);
    }

    @Test
    public void styleSheetResolution_variousScenarios() throws Exception {
        this.classes.add(MyAppShellWithVariousStyleSheets.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/", "/ctx"));
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assert.assertEquals((long)4L, (long)links.size());
        Assert.assertEquals((Object)"/trimmed.css", (Object)((Element)links.get(0)).attr("href"));
        Assert.assertEquals((Object)"/ctx/foo/bar.css", (Object)((Element)links.get(1)).attr("href"));
        Assert.assertEquals((Object)"HTTP://cdn.Example.com/u.css", (Object)((Element)links.get(2)).attr("href"));
        Assert.assertEquals((Object)"/ctx/assets/site.css", (Object)((Element)links.get(3)).attr("href"));
    }

    @Test
    public void styleSheetResolution_handlesDotSlash() throws Exception {
        this.classes.add(MyAppShellWithDotSlash.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/", "/ctx"));
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assert.assertEquals((long)1L, (long)links.size());
        Assert.assertEquals((Object)"/ctx/local.css", (Object)((Element)links.get(0)).attr("href"));
    }

    @Test
    public void styleSheetResolution_rejectsTraversal() throws Exception {
        this.classes.add(MyAppShellWithTraversal.class);
        this.initializer.process(this.classes, this.servletContext);
        AppShellRegistry.getInstance((VaadinContext)this.context).modifyIndexHtml(this.document, (VaadinRequest)this.createVaadinRequest("/", "/ctx"));
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assert.assertEquals((long)0L, (long)links.size());
    }

    private VaadinServletRequest createVaadinRequest(String pathInfo) {
        HttpServletRequest request = this.createRequest(pathInfo);
        return new VaadinServletRequest(request, (VaadinServletService)this.service);
    }

    private Logger mockLog(Class clz) throws Exception {
        Logger spy = (Logger)Mockito.spy((Object)LoggerFactory.getLogger((String)clz.getName()));
        ConcurrentMap<String, Logger> ilogger = this.clearIlogger();
        ilogger.put(clz.getName(), spy);
        return spy;
    }

    private ConcurrentMap<String, Logger> clearIlogger() throws Exception {
        ILoggerFactory ilogger = LoggerFactory.getILoggerFactory();
        Field field = SimpleLoggerFactory.class.getDeclaredField("loggerMap");
        field.setAccessible(true);
        ConcurrentMap map = (ConcurrentMap)field.get(ilogger);
        map.clear();
        return map;
    }

    private ApplicationConfiguration mockApplicationConfiguration() {
        ApplicationConfiguration config = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)config.getStringProperty(Mockito.anyString(), Mockito.anyString())).thenAnswer(invocation -> invocation.getArgument(1));
        Mockito.when((Object)config.getBooleanProperty(Mockito.anyString(), Mockito.anyBoolean())).thenAnswer(invocation -> invocation.getArgument(1));
        return config;
    }

    private VaadinServletRequest createVaadinRequest(String pathInfo, String contextPath) {
        HttpServletRequest request = this.createRequest(pathInfo, contextPath);
        return new VaadinServletRequest(request, (VaadinServletService)this.service);
    }

    private HttpServletRequest createRequest(String pathInfo) {
        return this.createRequest(pathInfo, "");
    }

    private HttpServletRequest createRequest(String pathInfo, String contextPath) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(pathInfo));
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        return request;
    }

    public static class MyAppShellWithoutAnnotations
    extends AbstractAppShellWithoutAnnotations {
    }

    @Meta.Container(value={@Meta(name="foo", content="bar"), @Meta(name="lorem", content="ipsum")})
    @Inline.Container(value={@Inline(value="inline.html"), @Inline(position=Inline.Position.PREPEND, value="inline.css"), @Inline(wrapping=Inline.Wrapping.JAVASCRIPT, position=Inline.Position.APPEND, target=TargetElement.BODY, value="inline.js")})
    @Viewport(value="my-viewport")
    @BodySize(height="my-height", width="my-width")
    @PageTitle(value="my-title")
    @Push(value=PushMode.MANUAL, transport=Transport.WEBSOCKET)
    @Theme(themeClass=AbstractTheme.class)
    public static class MyAppShellWithMultipleAnnotations
    implements AppShellConfigurator {
    }

    @Meta.Container(value={@Meta(name="foo", content="bar"), @Meta(name="lorem", content="ipsum")})
    @Inline.Container(value={@Inline(value="inline.html"), @Inline(position=Inline.Position.PREPEND, value="inline.css"), @Inline(wrapping=Inline.Wrapping.JAVASCRIPT, position=Inline.Position.APPEND, target=TargetElement.BODY, value="inline.js")})
    @Viewport(value="my-viewport")
    @BodySize(height="my-height", width="my-width")
    @PageTitle(value="my-title")
    @Push(value=PushMode.MANUAL, transport=Transport.WEBSOCKET)
    @Theme(themeClass=AbstractTheme.class)
    public static class OffendingClass {
    }

    @Theme(themeClass=AbstractTheme.class)
    @Push(value=PushMode.AUTOMATIC)
    public static class NonOffendingExporter
    extends WebComponentExporter<WebHolder> {
        public NonOffendingExporter() {
            super("web-component");
        }

        public void configureInstance(WebComponent<WebHolder> webComponent, WebHolder component) {
        }
    }

    public static interface InterfaceAppShellWithoutAnnotations
    extends AppShellConfigurator {
    }

    public static abstract class AbstractAppShellWithoutAnnotations
    implements InterfaceAppShellWithoutAnnotations {
    }

    @StyleSheet.Container(value={@StyleSheet(value="context://my-styles.css"), @StyleSheet(value="https://cdn.example.com/ui.css")})
    public static class MyAppShellWithStyleSheets
    implements AppShellConfigurator {
    }

    @StyleSheet.Container(value={@StyleSheet(value="context://theme-base.css"), @StyleSheet(value="context://theme-base.css")})
    public static class MyAppShellWithDuplicateStyles
    implements AppShellConfigurator {
    }

    @PWA(name="name", shortName="n")
    @Viewport(value="my-viewport")
    public static class OffendingPwaClass {
    }

    @Viewport(value="my-viewport")
    public static class OffendingNonPwaClass {
    }

    @Tag(value="div")
    public static class AppShellExtendingComponent
    extends Component
    implements AppShellConfigurator {
    }

    @StyleSheet(value="./foo.css")
    public static class ComponentWithStylesheet
    extends Component {
    }

    @StyleSheet.Container(value={@StyleSheet(value="./foo1.css"), @StyleSheet(value="./foo2.css"), @StyleSheet(value="./foo3.css"), @StyleSheet(value="./foo4.css")})
    public static class ComponentWithMultipleStylesheet
    extends Component {
    }

    @StyleSheet.Container(value={@StyleSheet(value="  /trimmed.css  "), @StyleSheet(value="   "), @StyleSheet(value="foo/bar.css"), @StyleSheet(value="HTTP://cdn.Example.com/u.css"), @StyleSheet(value="context://assets/site.css")})
    public static class MyAppShellWithVariousStyleSheets
    implements AppShellConfigurator {
    }

    @StyleSheet(value="./local.css")
    public static class MyAppShellWithDotSlash
    implements AppShellConfigurator {
    }

    @StyleSheet(value="../secrets.css")
    public static class MyAppShellWithTraversal
    implements AppShellConfigurator {
    }

    @PWA(name="name", shortName="n")
    @Viewport(value="my-viewport")
    @BodySize(height="my-height", width="my-width")
    public static class AppShellWithPWA
    implements AppShellConfigurator {
    }

    public static class MyAppShellWithConfigurator
    implements AppShellConfigurator {
        public void configurePage(AppShellSettings settings) {
            settings.setViewport("my-viewport");
            settings.setPageTitle("my-title");
            settings.addMetaTag("foo", "bar");
            settings.addMetaTag("lorem", "ipsum");
            settings.addInlineFromFile("inline.html", Inline.Wrapping.AUTOMATIC);
            settings.addInlineFromFile(Inline.Position.PREPEND, "inline.css", Inline.Wrapping.AUTOMATIC);
            settings.addInlineFromFile(TargetElement.BODY, Inline.Position.APPEND, "inline.js", Inline.Wrapping.JAVASCRIPT);
            settings.setBodySize("my-width", "my-height");
            settings.addFavIcon("icon1", "icon1.png", "1x1");
            settings.addFavIcon("icon2", "icon2.png", "2x2");
            settings.addInlineWithContents(Inline.Position.PREPEND, "window.messages = window.messages || [];\nwindow.messages.push(\"content script\");", Inline.Wrapping.JAVASCRIPT);
            settings.addInlineFromFile(Inline.Position.PREPEND, "inline.js", Inline.Wrapping.JAVASCRIPT);
            settings.addLink("icons/favicon.ico", (Map)new LinkedHashMap<String, String>(){
                {
                    this.put("rel", "shortcut icon");
                }
            });
            settings.addLink("icons/icon-192.png", (Map)new LinkedHashMap<String, String>(){
                {
                    this.put("rel", "icon");
                    this.put("sizes", "192x192");
                }
            });
            settings.addLink("shortcut icon", "icons/favicon.ico");
            settings.addFavIcon("icon", "icons/icon-192.png", "192x192");
            settings.addFavIcon("icon", "icons/icon-200.png", "2");
        }
    }

    public static class WebHolder
    extends Component {
    }
}

