/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MockVaadinSession
extends VaadinSession {
    private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
    private int closeCount;
    private ReentrantLock lock = new ReentrantLock();

    public MockVaadinSession(VaadinService service) {
        super(service);
    }

    public MockVaadinSession() {
        this((VaadinService)new MockVaadinServletService());
    }

    public void close() {
        super.close();
        ++this.closeCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public Lock getLockInstance() {
        return this.lock;
    }

    public void lock() {
        super.lock();
        referenceKeeper.set(this);
    }

    public void unlock() {
        super.unlock();
        referenceKeeper.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithLock(Callable<T> action) throws Exception {
        Map previous = CurrentInstance.setCurrent((VaadinSession)this);
        this.lock();
        try {
            T t = action.call();
            return t;
        }
        finally {
            this.unlock();
            CurrentInstance.restoreInstances((Map)previous);
        }
    }
}

