/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouteParameterFormatOption;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteModel;
import com.vaadin.flow.router.internal.RouteTarget;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class RouteModelTest {
    private RouteModel getRouteModel() {
        RouteModel root = RouteModel.create((boolean)true);
        root.addRoute("", this.routeTarget(Root.class));
        root.addRoute("trunk", this.routeTarget(Trunk.class));
        root.addRoute("trunk/branch", this.routeTarget(Branch.class));
        root.addRoute("trunk/branch/:id(^[-+]?\\d+$)", this.routeTarget(Branch.class));
        root.addRoute("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", this.routeTarget(BranchChildren.class));
        root.addRoute("trunk/:name?/:type?/branch/:id?(^[-+]?\\d+$)/edit", this.routeTarget(BranchEdit.class));
        root.addRoute("trunk/:name/:type?/branch/:id(^[-+]?\\d+$)/flower/:open(^[+-]?[0-9]{1,19}$)/edit", this.routeTarget(FlowerEdit.class));
        root.addRoute("trunk/twig/:leafs*", this.routeTarget(Twig.class));
        return root;
    }

    @Test
    public void route_model_provides_navigation_route_target() {
        RouteModel root = this.getRouteModel();
        this.assertNavigation(root, "trunk/twig", Twig.class, RouteModelTest.parameters(new String[0]));
        this.assertNavigation(root, "trunk/twig/a/b/c", Twig.class, RouteModelTest.parameters("leafs", RouteModelTest.varargs("a", "b", "c")));
        this.assertNavigation(root, "", Root.class, RouteModelTest.parameters(new String[0]));
        this.assertNavigation(root, "trunk", Trunk.class, RouteModelTest.parameters(new String[0]));
        this.assertNavigation(root, "trunk/branch", Branch.class, RouteModelTest.parameters(new String[0]));
        this.assertNavigation(root, "trunk/branch/12", Branch.class, RouteModelTest.parameters("id", "12"));
        this.assertNavigation(root, "trunk/branch/12/1/2/3/4/5/6/7", BranchChildren.class, RouteModelTest.parameters("id", "12", "list", RouteModelTest.varargs("1", "2", "3", "4", "5", "6", "7")));
        this.assertNavigation(root, "trunk/branch/view", null, null);
        this.assertNavigation(root, "trunk/branch/edit", BranchEdit.class, RouteModelTest.parameters(new String[0]));
        this.assertNavigation(root, "trunk/red/branch/12/edit", BranchEdit.class, RouteModelTest.parameters("id", "12", "name", "red"));
        this.assertNavigation(root, "trunk/branch/12/edit", BranchEdit.class, RouteModelTest.parameters("id", "12"));
        this.assertNavigation(root, "trunk/red/birch/branch/12/edit", BranchEdit.class, RouteModelTest.parameters("id", "12", "name", "red", "type", "birch"));
        this.assertNavigation(root, "trunk/red/branch/12/flower/1234567890/edit", FlowerEdit.class, RouteModelTest.parameters("id", "12", "name", "red", "open", "1234567890"));
        this.assertNavigation(root, "trunk/red/branch/12/flower/edit", null, null);
    }

    @Test
    public void varargs_url_parameter_defined_only_as_last_segment() {
        RouteModel root = RouteModel.create((boolean)true);
        try {
            root.addRoute("trunk/:vararg*/edit", this.routeTarget(Root.class));
            Assert.fail((String)"Varargs url parameter accepted in the middle of the path.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        root.addRoute("trunk/edit/:vararg*", this.routeTarget(Root.class));
        String path = "trunk/edit/1/2/3";
        this.assertNavigation(root, path, Root.class, RouteModelTest.parameters("vararg", RouteModelTest.varargs("1", "2", "3")));
    }

    @Test
    public void remove_route_target_not_found() {
        RouteModel root = this.getRouteModel();
        this.assertNavigation(root, "trunk/branch/12", Branch.class, RouteModelTest.parameters("id", "12"));
        root.removeRoute("trunk/branch/:id(^[-+]?\\d+$)");
        this.assertNavigation(root, "trunk/branch/12", BranchChildren.class, RouteModelTest.parameters("id", "12"));
        root.removeRoute("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)");
        this.assertNavigation(root, "trunk/branch/12", null, null);
    }

    @Test
    public void remove_route_url_not_found() {
        RouteModel root = this.getRouteModel();
        String expectedUrl = "trunk/branch/12";
        String template = "trunk/branch/:id(^[-+]?\\d+$)";
        RouteParameters parameters = RouteModelTest.parameters("id", "12");
        this.assertUrl(root, "trunk/branch/12", "trunk/branch/:id(^[-+]?\\d+$)", parameters);
        root.removeRoute("trunk/branch/:id(^[-+]?\\d+$)");
        try {
            this.assertUrl(root, "trunk/branch/12", "trunk/branch/:id(^[-+]?\\d+$)", parameters);
            Assert.fail((String)"Route was just removed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void route_model_provides_route_target() {
        RouteModel root = this.getRouteModel();
        String template = "trunk/branch/:id(^[-+]?\\d+$)";
        RouteParameters parameters = RouteModelTest.parameters("id", "12");
        this.assertRoute(root, Branch.class, "trunk/branch/:id(^[-+]?\\d+$)", parameters);
        root.removeRoute("trunk/branch/:id(^[-+]?\\d+$)");
        try {
            root.getRouteTarget("trunk/branch/:id(^[-+]?\\d+$)", parameters);
            Assert.fail((String)"Route was just removed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void route_model_provides_url_template_format() {
        RouteModel root = this.getRouteModel();
        String template = "trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)";
        Assert.assertEquals((Object)"trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", (Object)root.formatTemplate("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.REGEX, RouteParameterFormatOption.MODIFIER)));
        Assert.assertEquals((Object)"trunk/branch/:id(integer)/:list*(long)", (Object)root.formatTemplate("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.REGEX_NAME, RouteParameterFormatOption.MODIFIER)));
        Assert.assertEquals((Object)"trunk/branch/:id(integer)/:list(long)", (Object)root.formatTemplate("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.REGEX_NAME)));
        Assert.assertEquals((Object)"trunk/branch/:id/:list*", (Object)root.formatTemplate("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", EnumSet.of(RouteParameterFormatOption.NAME, RouteParameterFormatOption.MODIFIER)));
        Assert.assertEquals((Object)"trunk/branch/:integer/:long", (Object)root.formatTemplate("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)", EnumSet.of(RouteParameterFormatOption.REGEX_NAME)));
    }

    @Test
    public void route_model_provides_parameters() {
        RouteModel root = this.getRouteModel();
        String template = "trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)";
        Map parameters = root.getParameters("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)");
        Assert.assertEquals((String)"Incorrect parameters size", (long)2L, (long)parameters.size());
        Assert.assertTrue((String)"Missing parameter", (boolean)parameters.containsKey("id"));
        Assert.assertTrue((String)"Missing parameter", (boolean)parameters.containsKey("list"));
        Assert.assertEquals((String)"Wrong parameter data", (Object)":id(^[-+]?\\d+$)", (Object)((RouteParameterData)parameters.get("id")).getTemplate());
        Assert.assertEquals((String)"Wrong parameter data", (Object)":list*(^[+-]?[0-9]{1,19}$)", (Object)((RouteParameterData)parameters.get("list")).getTemplate());
    }

    @Test
    public void route_model_provides_routes() {
        RouteModel root = this.getRouteModel();
        Map routes = root.getRoutes();
        Assert.assertEquals((String)"Incorrect routes size", (long)8L, (long)routes.size());
        String template = "trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)";
        Assert.assertEquals((String)"Wrong route mapping", BranchChildren.class, (Object)((RouteTarget)routes.get("trunk/branch/:id(^[-+]?\\d+$)/:list*(^[+-]?[0-9]{1,19}$)")).getTarget());
    }

    @Test
    public void mutable_methods_throw_when_model_is_immutable() {
        RouteModel immutable = RouteModel.create((boolean)false);
        try {
            immutable.addRoute("foo/:foo", this.routeTarget(Root.class));
            Assert.fail((String)"Immutable model should not be mutable.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RouteModel mutable = RouteModel.create((boolean)true);
        mutable.addRoute("foo/:foo", this.routeTarget(Root.class));
        RouteModel immutableCopy = RouteModel.copy((RouteModel)mutable, (boolean)false);
        try {
            immutableCopy.removeRoute("foo/:foo");
            Assert.fail((String)"Immutable model should not be mutable.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void assertUrl(RouteModel root, String expectedUrl, String template, RouteParameters parameters) {
        String modelUrl = root.getUrl(template, parameters);
        Assert.assertEquals((Object)expectedUrl, (Object)modelUrl);
    }

    private void assertNavigation(RouteModel model, String url, Class<? extends Component> target, RouteParameters parameters) {
        NavigationRouteTarget result = model.getNavigationRouteTarget(url);
        Assert.assertEquals((String)"Invalid url", (Object)url, (Object)result.getPath());
        RouteTarget routeTarget = result.getRouteTarget();
        this.assertTarget(target, routeTarget);
        if (target != null) {
            Assert.assertEquals((String)"Invalid url", (Object)parameters, (Object)result.getRouteParameters());
        }
    }

    private void assertRoute(RouteModel model, Class<? extends Component> target, String template, RouteParameters parameters) {
        this.assertTarget(target, model.getRouteTarget(template, parameters));
    }

    private void assertTarget(Class<? extends Component> target, RouteTarget routeTarget) {
        Assert.assertTrue((String)("Weird expected target [" + String.valueOf(target) + "], actual [" + String.valueOf(routeTarget) + "]"), (target == null == (routeTarget == null) ? 1 : 0) != 0);
        if (target != null) {
            Assert.assertTrue((String)("Invalid expected target [" + String.valueOf(target) + "], actual " + String.valueOf(routeTarget.getTarget())), (boolean)routeTarget.getTarget().equals(target));
        }
    }

    private RouteTarget routeTarget(Class<? extends Component> target) {
        return new RouteTarget(target, null);
    }

    public static RouteParameters parameters(String ... namesAndValues) {
        if (namesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Input varargs must be of even size.");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(namesAndValues.length / 2);
        for (int i = 0; i < namesAndValues.length; i += 2) {
            String name = namesAndValues[i];
            if (paramsMap.containsKey(name)) {
                throw new IllegalArgumentException("Parameter " + name + " is specified more than once.");
            }
            String value = namesAndValues[i + 1];
            paramsMap.put(name, value);
        }
        return new RouteParameters(paramsMap);
    }

    public static String varargs(String ... varargs) {
        return PathUtil.getPath(Arrays.asList(varargs));
    }

    @Tag(value="div")
    public static class Root
    extends Component {
    }

    @Tag(value="div")
    public static class Trunk
    extends Component {
    }

    @Tag(value="div")
    public static class Branch
    extends Component {
    }

    @Tag(value="div")
    public static class BranchChildren
    extends Component {
    }

    @Tag(value="div")
    public static class BranchEdit
    extends Component {
    }

    @Tag(value="div")
    public static class FlowerEdit
    extends Component {
    }

    @Tag(value="div")
    public static class Twig
    extends Component {
    }
}

