/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.node.ArrayNode;

public class ReturnChannelMapTest {
    private StateNode node = new StateNode(new Class[]{ReturnChannelMap.class});
    private ReturnChannelMap returnChannelMap = (ReturnChannelMap)this.node.getFeature(ReturnChannelMap.class);

    @Test
    public void registerHandler_regstrationHasCorrectData() {
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableBiConsumer & Serializable)(arguments, channel) -> {});
        Assert.assertEquals((String)"Node id should match", (long)this.node.getId(), (long)registration.getStateNodeId());
        Assert.assertSame((String)"Registration should be findable based on id", (Object)registration, (Object)this.returnChannelMap.get(registration.getChannelId()));
        Assert.assertEquals((String)"Default disabled update mode should be to allow when enabled", (Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)registration.getDisabledUpdateMode());
    }

    @Test
    public void twoArgsHandler_invoked() {
        AtomicReference observedArguments = new AtomicReference();
        AtomicReference observedRegistration = new AtomicReference();
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableBiConsumer & Serializable)(arguments, channel) -> {
            Assert.assertNotNull((String)"Arguments should not be null", (Object)arguments);
            Assert.assertNull((String)"There should be no previous arguments", (Object)observedArguments.getAndSet(arguments));
            Assert.assertNull((String)"There should be no previous channel", (Object)observedRegistration.getAndSet(channel));
        });
        Assert.assertNull((String)"Handler should not yet be invoked", observedArguments.get());
        ArrayNode arguments2 = JacksonUtils.createArrayNode();
        registration.invoke(arguments2);
        Assert.assertSame((Object)arguments2, observedArguments.get());
        Assert.assertSame((Object)registration, observedRegistration.get());
    }

    @Test
    public void shorthandHandler_invoked() {
        AtomicReference observedArguments = new AtomicReference();
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableConsumer & Serializable)arguments -> {
            Assert.assertNotNull((String)"Arguments should not be null", (Object)arguments);
            Assert.assertNull((String)"There should be no previous arguments", (Object)observedArguments.getAndSet(arguments));
        });
        Assert.assertNull((String)"Handler should not yet be invoked", observedArguments.get());
        ArrayNode arguments2 = JacksonUtils.createArrayNode();
        registration.invoke(arguments2);
        Assert.assertSame((Object)arguments2, observedArguments.get());
    }
}

