/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.Range;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test(expected=IllegalArgumentException.class)
    public void startAfterEndTest() {
        Range.between((int)10, (int)9);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeLengthTest() {
        Range.withLength((int)10, (int)-1);
    }

    @Test
    public void constructorEquivalenceTest() {
        Assert.assertEquals((String)"10 == [10,11[", (Object)Range.withOnly((int)10), (Object)Range.between((int)10, (int)11));
        Assert.assertEquals((String)"[10,20[ == 10, length 10", (Object)Range.between((int)10, (int)20), (Object)Range.withLength((int)10, (int)10));
        Assert.assertEquals((String)"10 == 10, length 1", (Object)Range.withOnly((int)10), (Object)Range.withLength((int)10, (int)1));
    }

    @Test
    public void boundsTest() {
        Range range = Range.between((int)0, (int)10);
        Assert.assertEquals((String)"between(0, 10) start", (long)0L, (long)range.getStart());
        Assert.assertEquals((String)"between(0, 10) end", (long)10L, (long)range.getEnd());
        Range single = Range.withOnly((int)10);
        Assert.assertEquals((String)"withOnly(10) start", (long)10L, (long)single.getStart());
        Assert.assertEquals((String)"withOnly(10) end", (long)11L, (long)single.getEnd());
        Range length = Range.withLength((int)10, (int)5);
        Assert.assertEquals((String)"withLength(10, 5) start", (long)10L, (long)length.getStart());
        Assert.assertEquals((String)"withLength(10, 5) end", (long)15L, (long)length.getEnd());
    }

    @Test
    public void equalsTest() {
        Range range1 = Range.between((int)0, (int)10);
        Range range2 = Range.withLength((int)0, (int)11);
        Assert.assertTrue((String)"null", (!range1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"reflexive", (boolean)range1.equals((Object)range1));
        Assert.assertEquals((String)"symmetric", (Object)range1.equals((Object)range2), (Object)range2.equals((Object)range1));
    }

    @Test
    public void containsTest() {
        boolean start = false;
        int end = 10;
        Range range = Range.between((int)0, (int)10);
        Assert.assertTrue((String)"start should be contained", (boolean)range.contains(0));
        Assert.assertTrue((String)"start-1 should not be contained", (!range.contains(-1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"end should not be contained", (!range.contains(10) ? 1 : 0) != 0);
        Assert.assertTrue((String)"end-1 should be contained", (boolean)range.contains(9));
        Assert.assertTrue((String)"[0..10[ contains 5", (boolean)Range.between((int)0, (int)10).contains(5));
        Assert.assertTrue((String)"empty range does not contain 5", (!Range.between((int)5, (int)5).contains(5) ? 1 : 0) != 0);
    }

    @Test
    public void emptyTest() {
        Assert.assertTrue((String)"[0..0[ should be empty", (boolean)Range.between((int)0, (int)0).isEmpty());
        Assert.assertTrue((String)"Range of length 0 should be empty", (boolean)Range.withLength((int)0, (int)0).isEmpty());
        Assert.assertTrue((String)"[0..1[ should not be empty", (!Range.between((int)0, (int)1).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Range of length 1 should not be empty", (!Range.withLength((int)0, (int)1).isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void splitTest() {
        Range startRange = Range.between((int)0, (int)10);
        Range[] splitRanges = startRange.splitAt(5);
        Assert.assertEquals((String)"[0..10[ split at 5, lower", (Object)Range.between((int)0, (int)5), (Object)splitRanges[0]);
        Assert.assertEquals((String)"[0..10[ split at 5, upper", (Object)Range.between((int)5, (int)10), (Object)splitRanges[1]);
    }

    @Test
    public void split_valueBefore() {
        Range range = Range.between((int)10, (int)20);
        Range[] splitRanges = range.splitAt(5);
        Assert.assertEquals((Object)Range.between((int)10, (int)10), (Object)splitRanges[0]);
        Assert.assertEquals((Object)range, (Object)splitRanges[1]);
    }

    @Test
    public void split_valueAfter() {
        Range range = Range.between((int)10, (int)20);
        Range[] splitRanges = range.splitAt(25);
        Assert.assertEquals((Object)range, (Object)splitRanges[0]);
        Assert.assertEquals((Object)Range.between((int)20, (int)20), (Object)splitRanges[1]);
    }

    @Test
    public void emptySplitTest() {
        Range range = Range.between((int)5, (int)10);
        Range[] split1 = range.splitAt(0);
        Assert.assertTrue((String)"split1, [0]", (boolean)split1[0].isEmpty());
        Assert.assertEquals((String)"split1, [1]", (Object)range, (Object)split1[1]);
        Range[] split2 = range.splitAt(15);
        Assert.assertEquals((String)"split2, [0]", (Object)range, (Object)split2[0]);
        Assert.assertTrue((String)"split2, [1]", (boolean)split2[1].isEmpty());
    }

    @Test
    public void lengthTest() {
        Assert.assertEquals((String)"withLength length", (long)5L, (long)Range.withLength((int)10, (int)5).length());
        Assert.assertEquals((String)"between length", (long)5L, (long)Range.between((int)10, (int)15).length());
        Assert.assertEquals((String)"withOnly 10 length", (long)1L, (long)Range.withOnly((int)10).length());
    }

    @Test
    public void intersectsTest() {
        Assert.assertTrue((String)"[0..10[ intersects [5..15[", (boolean)Range.between((int)0, (int)10).intersects(Range.between((int)5, (int)15)));
        Assert.assertTrue((String)"[0..10[ does not intersect [10..20[", (!Range.between((int)0, (int)10).intersects(Range.between((int)10, (int)20)) ? 1 : 0) != 0);
    }

    @Test
    public void intersects_emptyInside() {
        Assert.assertTrue((String)"[5..5[ does intersect with [0..10[", (boolean)Range.between((int)5, (int)5).intersects(Range.between((int)0, (int)10)));
        Assert.assertTrue((String)"[0..10[ does intersect with [5..5[", (boolean)Range.between((int)0, (int)10).intersects(Range.between((int)5, (int)5)));
    }

    @Test
    public void intersects_emptyOutside() {
        Assert.assertTrue((String)"[15..15[ does not intersect with [0..10[", (!Range.between((int)15, (int)15).intersects(Range.between((int)0, (int)10)) ? 1 : 0) != 0);
        Assert.assertTrue((String)"[0..10[ does not intersect with [15..15[", (!Range.between((int)0, (int)10).intersects(Range.between((int)15, (int)15)) ? 1 : 0) != 0);
    }

    @Test
    public void subsetTest() {
        Assert.assertTrue((String)"[5..10[ is subset of [0..20[", (boolean)Range.between((int)5, (int)10).isSubsetOf(Range.between((int)0, (int)20)));
        Range range = Range.between((int)0, (int)10);
        Assert.assertTrue((String)"range is subset of self", (boolean)range.isSubsetOf(range));
        Assert.assertTrue((String)"[0..10[ is not subset of [5..15[", (!Range.between((int)0, (int)10).isSubsetOf(Range.between((int)5, (int)15)) ? 1 : 0) != 0);
    }

    @Test
    public void offsetTest() {
        Assert.assertEquals((Object)Range.between((int)5, (int)15), (Object)Range.between((int)0, (int)10).offsetBy(5));
    }

    @Test
    public void rangeStartsBeforeTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)1, (int)5);
        Assert.assertTrue((String)"former should starts before latter", (boolean)former.startsBefore(latter));
        Assert.assertTrue((String)"latter shouldn't start before latter", (!latter.startsBefore(former) ? 1 : 0) != 0);
        Assert.assertTrue((String)"no overlap allowed", (!Range.between((int)0, (int)5).startsBefore(Range.between((int)0, (int)10)) ? 1 : 0) != 0);
    }

    @Test
    public void rangeStartsAfterTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)5, (int)10);
        Assert.assertTrue((String)"latter should start after former", (boolean)latter.startsAfter(former));
        Assert.assertTrue((String)"former shouldn't start after latter", (!former.startsAfter(latter) ? 1 : 0) != 0);
        Assert.assertTrue((String)"no overlap allowed", (!Range.between((int)5, (int)10).startsAfter(Range.between((int)0, (int)6)) ? 1 : 0) != 0);
    }

    @Test
    public void rangeEndsBeforeTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)5, (int)10);
        Assert.assertTrue((String)"latter should end before former", (boolean)former.endsBefore(latter));
        Assert.assertTrue((String)"former shouldn't end before latter", (!latter.endsBefore(former) ? 1 : 0) != 0);
        Assert.assertTrue((String)"no overlap allowed", (!Range.between((int)5, (int)10).endsBefore(Range.between((int)9, (int)15)) ? 1 : 0) != 0);
    }

    @Test
    public void rangeEndsAfterTest() {
        Range former = Range.between((int)1, (int)5);
        Range latter = Range.between((int)1, (int)6);
        Assert.assertTrue((String)"latter should end after former", (boolean)latter.endsAfter(former));
        Assert.assertTrue((String)"former shouldn't end after latter", (!former.endsAfter(latter) ? 1 : 0) != 0);
        Assert.assertTrue((String)"no overlap allowed", (!Range.between((int)0, (int)10).endsAfter(Range.between((int)5, (int)10)) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void combine_notOverlappingFirstSmaller() {
        Range.between((int)0, (int)10).combineWith(Range.between((int)11, (int)20));
    }

    @Test(expected=IllegalArgumentException.class)
    public void combine_notOverlappingSecondLarger() {
        Range.between((int)11, (int)20).combineWith(Range.between((int)0, (int)10));
    }

    @Test(expected=IllegalArgumentException.class)
    public void combine_firstEmptyNotOverlapping() {
        Range.between((int)15, (int)15).combineWith(Range.between((int)0, (int)10));
    }

    @Test(expected=IllegalArgumentException.class)
    public void combine_secondEmptyNotOverlapping() {
        Range.between((int)0, (int)10).combineWith(Range.between((int)15, (int)15));
    }

    @Test
    public void combine_barelyOverlapping() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)10, (int)20);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assert.assertEquals((Object)combined1, (Object)combined2);
        Assert.assertEquals((long)0L, (long)combined1.getStart());
        Assert.assertEquals((long)20L, (long)combined1.getEnd());
    }

    @Test
    public void combine_subRange() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)2, (int)8);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assert.assertEquals((Object)combined1, (Object)combined2);
        Assert.assertEquals((Object)r1, (Object)combined1);
    }

    @Test
    public void combine_intersecting() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)5, (int)15);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assert.assertEquals((Object)combined1, (Object)combined2);
        Assert.assertEquals((long)0L, (long)combined1.getStart());
        Assert.assertEquals((long)15L, (long)combined1.getEnd());
    }

    @Test
    public void combine_emptyInside() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)5, (int)5);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assert.assertEquals((Object)combined1, (Object)combined2);
        Assert.assertEquals((Object)r1, (Object)combined1);
    }

    @Test
    public void expand_basic() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = r1.expand(2, 3);
        Assert.assertEquals((Object)Range.between((int)3, (int)13), (Object)r2);
    }

    @Test
    public void expand_negativeLegal() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = r1.expand(-2, -2);
        Assert.assertEquals((Object)Range.between((int)7, (int)8), (Object)r2);
        Range r3 = r1.expand(-3, -2);
        Assert.assertEquals((Object)Range.between((int)8, (int)8), (Object)r3);
        Range r4 = r1.expand(3, -8);
        Assert.assertEquals((Object)Range.between((int)2, (int)2), (Object)r4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void expand_negativeIllegal1() {
        Range r1 = Range.between((int)5, (int)10);
        r1.expand(-3, -3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void expand_negativeIllegal2() {
        Range r1 = Range.between((int)5, (int)10);
        r1.expand(3, -9);
    }

    @Test
    public void restrictTo_fullyInside() {
        Range r2;
        Range r3;
        Range r1 = Range.between((int)5, (int)10);
        Assert.assertTrue((r1 == (r3 = r1.restrictTo(r2 = Range.between((int)4, (int)11))) ? 1 : 0) != 0);
    }

    @Test
    public void restrictTo_fullyOutside() {
        Range r3;
        Range r1 = Range.between((int)4, (int)11);
        Range r2 = Range.between((int)5, (int)10);
        Assert.assertTrue((r2 == (r3 = r1.restrictTo(r2)) ? 1 : 0) != 0);
    }

    @Test
    public void restrictTo_notInterstecting() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)15, (int)20);
        Range r3 = r1.restrictTo(r2);
        Assert.assertTrue((String)"Non-intersecting ranges should produce an empty result", (boolean)r3.isEmpty());
        Range r4 = r2.restrictTo(r1);
        Assert.assertTrue((String)"Non-intersecting ranges should produce an empty result", (boolean)r4.isEmpty());
    }

    @Test
    public void restrictTo_startOutside() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)7, (int)15);
        Range r3 = r1.restrictTo(r2);
        Assert.assertEquals((Object)Range.between((int)7, (int)10), (Object)r3);
        Assert.assertEquals((Object)r2.restrictTo(r1), (Object)r3);
    }

    @Test
    public void restrictTo_endOutside() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)4, (int)7);
        Range r3 = r1.restrictTo(r2);
        Assert.assertEquals((Object)Range.between((int)5, (int)7), (Object)r3);
        Assert.assertEquals((Object)r2.restrictTo(r1), (Object)r3);
    }

    @Test
    public void restrictTo_empty() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)0, (int)0);
        Range r3 = r1.restrictTo(r2);
        Assert.assertTrue((boolean)r3.isEmpty());
        Range r4 = r2.restrictTo(r1);
        Assert.assertTrue((boolean)r4.isEmpty());
    }
}

