/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.open.OSUtils;
import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FileIOUtilsTest {
    @Test
    public void projectFolderOnWindows() throws Exception {
        Assume.assumeTrue((boolean)OSUtils.isWindows());
        URL url = new URL("file:/C:/Users/John%20Doe/Downloads/my-app%20(21)/my-app/target/classes/");
        Assert.assertEquals((Object)new File("C:\\Users\\John Doe\\Downloads\\my-app (21)\\my-app"), (Object)FileIOUtils.getProjectFolderFromClasspath((URL)url));
    }

    @Test
    public void projectFolderOnMacOrLinux() throws Exception {
        Assume.assumeFalse((boolean)OSUtils.isWindows());
        URL url = new URL("file:/Users/John%20Doe/Downloads/my-app%20(21)/my-app/target/classes/");
        Assert.assertEquals((Object)new File("/Users/John Doe/Downloads/my-app (21)/my-app"), (Object)FileIOUtils.getProjectFolderFromClasspath((URL)url));
    }

    @Test
    public void tempFilesAreTempFiles() {
        Assert.assertTrue((boolean)FileIOUtils.isProbablyTemporaryFile((File)new File("foo.txt~")));
        Assert.assertFalse((boolean)FileIOUtils.isProbablyTemporaryFile((File)new File("foo.txt")));
    }
}

