/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ElementFactoryTest {
    private Map<String, String> methodToTag = new HashMap<String, String>();

    public ElementFactoryTest() {
        this.methodToTag.put("anchor", "a");
        this.methodToTag.put("horizontalrule", "hr");
        this.methodToTag.put("preformatted", "pre");
        this.methodToTag.put("paragraph", "p");
        this.methodToTag.put("emphasis", "em");
        this.methodToTag.put("listitem", "li");
        this.methodToTag.put("unorderedlist", "ul");
        for (int i = 1; i <= 6; ++i) {
            this.methodToTag.put("heading" + i, "h" + i);
        }
    }

    @Test
    public void automatedTest() throws Exception {
        for (Method method : ElementFactory.class.getMethods()) {
            this.testMethod(method);
        }
    }

    @Test
    public void createAnchor() {
        String href = "hrefhref";
        String textContent = "textContent";
        this.assertElement("<a href='" + href + "'></a>", ElementFactory.createAnchor((String)href));
        this.assertElement("<a href='" + href + "'>textContent</a>", ElementFactory.createAnchor((String)href, (String)textContent));
        this.assertElement("<a href='" + href + "' router-link=''>textContent</a>", ElementFactory.createRouterLink((String)href, (String)textContent));
    }

    @Test
    public void createTextInput() {
        String type = "typetype";
        this.assertElement("<input type='" + type + "'></input>", ElementFactory.createInput((String)type));
    }

    private void assertElement(String expectedOuterHtml, Element createAnchor) {
        String actualHtml = this.getOuterHtml(createAnchor);
        Assert.assertEquals((Object)expectedOuterHtml, (Object)actualHtml);
    }

    private String getOuterHtml(Element e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(e.getTag());
        String attrs = e.getAttributeNames().sorted().map(name -> name + "='" + e.getAttribute(name) + "'").collect(Collectors.joining(" "));
        if (!attrs.isEmpty()) {
            sb.append(" ").append(attrs);
        }
        sb.append(">");
        sb.append(e.getTextRecursively());
        sb.append("</");
        sb.append(e.getTag());
        sb.append(">");
        return sb.toString();
    }

    private boolean isSimpleCreateMethod(Method method) {
        if (!method.getName().startsWith("create")) {
            return false;
        }
        return method.getParameterTypes().length == 0;
    }

    private void testMethod(Method method) throws Exception {
        if (this.isTestedSeparately(method)) {
            return;
        }
        if (this.isSimpleCreateMethod(method)) {
            Element element = (Element)method.invoke(null, new Object[0]);
            String expectedTag = this.tagNameFromMethod(method);
            this.assertElement("<" + expectedTag + "></" + expectedTag + ">", element);
        } else if (this.isTextContentMethod(method)) {
            Element element = (Element)method.invoke(null, "textContent");
            String expectedTag = this.tagNameFromMethod(method);
            this.assertElement("<" + expectedTag + ">textContent</" + expectedTag + ">", element);
        } else {
            Assert.fail((String)("Untested method: " + method.getName() + "(" + Stream.of(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(",")) + ")"));
        }
    }

    private boolean isTestedSeparately(Method method) {
        if (method.getName().equals("createAnchor") && method.getParameterTypes().length > 0) {
            return true;
        }
        if (method.getName().equals("createRouterLink") && method.getParameterTypes().length > 0) {
            return true;
        }
        return method.getName().equals("createInput") && method.getParameterTypes().length > 0;
    }

    private boolean isTextContentMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] == String.class;
    }

    private String tagNameFromMethod(Method method) {
        String tagFromMethod = method.getName().replace("create", "").toLowerCase(Locale.ENGLISH);
        if (this.methodToTag.containsKey(tagFromMethod)) {
            return this.methodToTag.get(tagFromMethod);
        }
        return tagFromMethod;
    }
}

