/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonSerializer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.webcomponent.PropertyData;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import java.io.Serializable;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

public class WebComponentExporterTest {
    private static final String TAG = "my-component";
    private MyComponentExporter exporter;
    private WebComponentConfiguration<MyComponent> config;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Before
    public void setUp() {
        this.exporter = new MyComponentExporter();
        this.config = new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)this.exporter);
    }

    @Test
    public void addProperty_differentTypes() {
        this.exporter.addProperty("int", 1);
        this.exporter.addProperty("string", "string");
        this.exporter.addProperty("boolean", true);
        this.exporter.addProperty("double", 1.0);
        WebComponentExporterTest.assertProperty(this.config, "int", 1);
        WebComponentExporterTest.assertProperty(this.config, "string", "string");
        WebComponentExporterTest.assertProperty(this.config, "boolean", true);
        WebComponentExporterTest.assertProperty(this.config, "double", 1.0);
        Bean bean = new Bean();
        bean.setInteger(5);
        BaseJsonNode value = (BaseJsonNode)JacksonSerializer.toJson((Object)bean);
        this.exporter.addProperty("json", value);
        WebComponentExporterTest.assertProperty(this.config, "json", value);
    }

    @Test
    public void addProperty_propertyWithTheSameNameGetsOverwritten() {
        this.exporter.addProperty("int", 1);
        Assert.assertTrue((boolean)this.config.hasProperty("int"));
        this.exporter.addProperty("int", 2);
        Assert.assertEquals((String)"Configuration should have one property", (long)1L, (long)this.config.getPropertyDataSet().size());
        WebComponentExporterTest.assertProperty(this.config, "int", 2);
    }

    @Test
    public void configuration_getTag() {
        Assert.assertEquals((Object)TAG, (Object)this.config.getTag());
    }

    @Test
    public void configuration_getPropertyType_differentTypes() {
        this.exporter.addProperty("int", 1);
        this.exporter.addProperty("string", "string");
        this.exporter.addProperty("boolean", true);
        this.exporter.addProperty("double", 1.0);
        Assert.assertEquals(Integer.class, (Object)this.config.getPropertyType("int"));
        Assert.assertEquals(String.class, (Object)this.config.getPropertyType("string"));
        Assert.assertEquals(Boolean.class, (Object)this.config.getPropertyType("boolean"));
        Assert.assertEquals(Double.class, (Object)this.config.getPropertyType("double"));
    }

    @Test
    public void configuration_deliverPropertyUpdate() {
        this.exporter.addProperty("int", 0).onChange(MyComponent::update);
        WebComponentBinding binding = this.config.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.createObjectNode());
        Assert.assertNotNull((Object)binding);
        binding.updateProperty("int", (Serializable)Integer.valueOf(1));
        Assert.assertEquals((String)"Component should have been updated", (long)1L, (long)((MyComponent)binding.getComponent()).getValue());
    }

    @Test
    public void configuration_getPropertyDataSet() {
        this.exporter.addProperty("int", 1);
        this.exporter.addProperty("string", "string");
        this.exporter.addProperty("boolean", true);
        this.exporter.addProperty("double", 1.0);
        Set set = this.config.getPropertyDataSet();
        Assert.assertEquals((long)4L, (long)set.size());
    }

    @Test
    public void configuration_getComponentClass() {
        Assert.assertEquals((String)"Component class should be MyComponent.class", MyComponent.class, (Object)this.config.getComponentClass());
    }

    @Test
    public void configuration_createWebComponentBinding() {
        this.exporter = new MyComponentExporter(){

            @Override
            public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
                component.flop();
            }
        };
        this.exporter.addProperty("value", 1).onChange(MyComponent::update);
        this.config = new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)this.exporter);
        WebComponentBinding binding = this.config.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.createObjectNode());
        Assert.assertNotNull((String)"Binding should not be null", (Object)binding);
        Assert.assertNotNull((String)"Binding's component should not be null", (Object)binding.getComponent());
        Assert.assertTrue((String)"configureInstance() should have set 'flip' to true", (boolean)((MyComponent)binding.getComponent()).getFlip());
        Assert.assertEquals((String)"value should be set to 1 by default", (long)1L, (long)((MyComponent)binding.getComponent()).value);
    }

    @Test
    public void configuration_createWebComponentBinding_overridesDefaultValues() {
        this.exporter.addProperty("value", 1).onChange(MyComponent::update);
        this.config = new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)this.exporter);
        WebComponentBinding binding = this.config.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.readTree((String)"{\"value\":2}"));
        Assert.assertEquals((String)"attribute should have set default value to two", (long)2L, (long)((MyComponent)binding.getComponent()).value);
    }

    @Test
    public void configuration_bindProxy_withoutInstanceConfigurator() {
        WebComponentBinding binding = this.config.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.createObjectNode());
        Assert.assertNotNull((String)"Binding should not be null", (Object)binding);
        Assert.assertNotNull((String)"Binding's component should not be null", (Object)binding.getComponent());
        Assert.assertFalse((String)"'flip' should have been false", (boolean)((MyComponent)binding.getComponent()).getFlip());
    }

    @Test(expected=IllegalStateException.class)
    public void configuration_bindProxy_throwsIfExporterSharesTagWithComponent() {
        SharedTagExporter sharedTagExporter = new SharedTagExporter();
        WebComponentConfiguration sharedConfig = new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)sharedTagExporter);
        sharedConfig.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.createObjectNode());
    }

    @Test
    public void configuration_hasProperty() {
        this.exporter.addProperty("int", 1);
        this.exporter.addProperty("string", "string");
        this.exporter.addProperty("boolean", true);
        this.exporter.addProperty("double", 1.0);
        Assert.assertTrue((boolean)this.config.hasProperty("int"));
        Assert.assertTrue((boolean)this.config.hasProperty("string"));
        Assert.assertTrue((boolean)this.config.hasProperty("boolean"));
        Assert.assertTrue((boolean)this.config.hasProperty("double"));
        Assert.assertFalse((boolean)this.config.hasProperty("does-not-exist"));
    }

    @Test
    public void configuration_callAddProperty_throws() {
        this.expectedEx.expect(IllegalStateException.class);
        this.expectedEx.expectMessage("'addProperty'");
        AddPropertyInsideConfigureInstance exporter = new AddPropertyInsideConfigureInstance();
        WebComponentConfiguration config = new WebComponentExporter.WebComponentConfigurationFactory().create((WebComponentExporter)exporter);
        config.createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), (Element)Mockito.mock(Element.class), (JsonNode)JacksonUtils.createObjectNode());
    }

    @Test(expected=IllegalStateException.class)
    public void exporterConstructorThrowsIfNoComponentDefined() {
        NoComponentExporter exporter = new NoComponentExporter();
    }

    private static void assertProperty(WebComponentConfiguration<?> config, String property, Object value) {
        PropertyData data = config.getPropertyDataSet().stream().filter(d -> d.getName().equals(property)).findFirst().orElse(null);
        Assert.assertNotNull((String)("Property " + property + " should not be null"), (Object)data);
        Assert.assertEquals((Object)value, (Object)data.getDefaultValue());
    }

    public static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            super(WebComponentExporterTest.TAG);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class Bean {
        protected int integer = 0;

        public int getInteger() {
            return this.integer;
        }

        public void setInteger(int i) {
            this.integer = i;
        }

        public int hashCode() {
            return this.integer;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bean) {
                return this.integer == ((Bean)obj).integer;
            }
            return false;
        }
    }

    @Tag(value="test")
    public static class MyComponent
    extends Component {
        private boolean flip = false;
        private int value = 0;

        public void flop() {
            this.flip = true;
        }

        public void update(int i) {
            this.value = i;
        }

        public boolean getFlip() {
            return this.flip;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class SharedTagExporter
    extends WebComponentExporter<SharedTagComponent> {
        public SharedTagExporter() {
            super("shared-tag");
        }

        public void configureInstance(WebComponent<SharedTagComponent> webComponent, SharedTagComponent component) {
        }
    }

    public static class AddPropertyInsideConfigureInstance
    extends WebComponentExporter<MyComponent> {
        public AddPropertyInsideConfigureInstance() {
            super("foo");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
            this.addProperty("bar", 1);
        }
    }

    public static class NoComponentExporter
    extends WebComponentExporter {
        public NoComponentExporter() {
            super("tag");
        }

        public void configureInstance(WebComponent webComponent, Component component) {
        }
    }

    @Tag(value="shared-tag")
    public static class SharedTagComponent
    extends Component {
    }
}

