/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShortcutRegistrationTest {
    private UI ui;
    private Component lifecycleOwner;
    private Component[] listenOn = new Component[3];
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void initTests() {
        this.ui = (UI)Mockito.mock(UI.class);
        this.lifecycleOwner = (Component)Mockito.mock(Component.class);
        Arrays.setAll(this.listenOn, i -> (Component)Mockito.mock(Component.class));
        Mockito.when((Object)this.lifecycleOwner.getUI()).thenReturn(Optional.of(this.ui));
        Mockito.when((Object)this.lifecycleOwner.addAttachListener((ComponentEventListener)ArgumentMatchers.any())).thenReturn((Object)((Registration)Mockito.mock(Registration.class)));
        Mockito.when((Object)this.lifecycleOwner.addDetachListener((ComponentEventListener)ArgumentMatchers.any())).thenReturn((Object)((Registration)Mockito.mock(Registration.class)));
        for (Component component : this.listenOn) {
            Mockito.when((Object)component.getUI()).thenReturn(Optional.of(this.ui));
        }
    }

    @Test
    public void registrationWillBeCompletedBeforeClientResponse() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        this.clientResponse();
        Assert.assertTrue((boolean)registration.isShortcutActive());
        Assert.assertFalse((boolean)registration.isDirty());
    }

    @Test
    public void constructedRegistrationIsDirty() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertTrue((boolean)registration.isDirty());
    }

    @Test
    public void lateUpdateOfModifiersDirtiesRegistration() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        this.clientResponse();
        Assert.assertFalse((boolean)registration.isDirty());
        registration.withModifiers(new KeyModifier[]{KeyModifier.ALT});
        Assert.assertTrue((boolean)registration.isDirty());
        Assert.assertEquals((long)1L, (long)registration.getModifiers().size());
    }

    @Test
    public void fluentModifiersAreAddedCorrectly() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        registration.withAlt().withCtrl().withMeta().withShift();
        Assert.assertEquals((long)4L, (long)registration.getModifiers().size());
    }

    @Test
    public void preventDefaultAndStopPropagationValuesDefaultToTrue() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertFalse((boolean)registration.isBrowserDefaultAllowed());
        Assert.assertFalse((boolean)registration.isEventPropagationAllowed());
        registration.allowBrowserDefault().allowEventPropagation();
        Assert.assertTrue((boolean)registration.isBrowserDefaultAllowed());
        Assert.assertTrue((boolean)registration.isEventPropagationAllowed());
    }

    @Test
    public void resetFocusOnActiveElementValuesDefaultToTrue() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertFalse((boolean)registration.isResetFocusOnActiveElement());
        registration.resetFocusOnActiveElement();
        Assert.assertTrue((boolean)registration.isResetFocusOnActiveElement());
    }

    @Test
    public void bindLifecycleToChangesLifecycleOwner() {
        Component newOwner = (Component)Mockito.mock(Component.class);
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertEquals((Object)this.lifecycleOwner, (Object)registration.getLifecycleOwner());
        registration.bindLifecycleTo(newOwner);
        Assert.assertEquals((Object)newOwner, (Object)registration.getLifecycleOwner());
    }

    @Test
    public void settersAndGettersChangeValuesCorrectly() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        registration.setBrowserDefaultAllowed(true);
        registration.setEventPropagationAllowed(true);
        registration.setResetFocusOnActiveElement(true);
        this.clientResponse();
        Assert.assertTrue((String)"Allow default was not set to true", (boolean)registration.isBrowserDefaultAllowed());
        Assert.assertTrue((String)"Allow propagation was not set to true", (boolean)registration.isBrowserDefaultAllowed());
        Assert.assertTrue((String)"Reset focus on active element was not set to true", (boolean)registration.isResetFocusOnActiveElement());
        registration.setBrowserDefaultAllowed(false);
        registration.setEventPropagationAllowed(false);
        registration.setResetFocusOnActiveElement(false);
        this.clientResponse();
        Assert.assertFalse((String)"Allow default was not set to false", (boolean)registration.isBrowserDefaultAllowed());
        Assert.assertFalse((String)"Allow propagation was not set to false", (boolean)registration.isEventPropagationAllowed());
        Assert.assertFalse((String)"Reset focus on active element was not set to false", (boolean)registration.isResetFocusOnActiveElement());
    }

    @Test
    public void listenOnChangesTheComponentThatOwnsTheListener() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        for (Component component : this.listenOn) {
            Mockito.when((Object)component.addDetachListener((ComponentEventListener)Mockito.any())).thenReturn((Object)((Registration)Mockito.mock(Registration.class)));
        }
        this.clientResponse();
        Assert.assertArrayEquals((Object[])this.listenOn, (Object[])registration.getOwners());
        Object[] newListenOn = new Component[2];
        Arrays.setAll(newListenOn, i -> (Component)Mockito.mock(Component.class));
        for (Component component : newListenOn) {
            Mockito.when((Object)component.getUI()).thenReturn(Optional.of(this.ui));
        }
        registration.listenOn((Component[])newListenOn);
        this.clientResponse((Component[])newListenOn);
        Assert.assertArrayEquals((Object[])newListenOn, (Object[])registration.getOwners());
    }

    @Test
    public void listenOnComponentIsChanged_eventIsPopulatedForANewListenOnComponent() {
        UI ui = (UI)Mockito.spy(UI.class);
        FakeComponent owner = new FakeComponent();
        FakeComponent initialComponentToListenOn = new FakeComponent();
        Component[] components = new Component[]{initialComponentToListenOn};
        ui.add(new Component[]{owner});
        ui.add(new Component[]{initialComponentToListenOn});
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        ArgumentCaptor captor = ArgumentCaptor.forClass(SerializableConsumer.class);
        ((UI)Mockito.verify((Object)ui, (VerificationMode)Mockito.atLeastOnce())).beforeClientResponse((Component)ArgumentMatchers.eq((Object)((Object)owner)), (SerializableConsumer)captor.capture());
        SerializableConsumer consumer = (SerializableConsumer)captor.getValue();
        consumer.accept(Mockito.mock(ExecutionContext.class));
        Assert.assertTrue((boolean)this.hasKeyAInKeyDownExpression(initialComponentToListenOn));
        FakeComponent replacementComponentToListenOn = new FakeComponent();
        components[0] = replacementComponentToListenOn;
        ui.add(new Component[]{components[0]});
        ui.remove(new Component[]{initialComponentToListenOn});
        ui.remove(new Component[]{owner});
        ui.add(new Component[]{owner});
        consumer.accept(Mockito.mock(ExecutionContext.class));
        Assert.assertTrue((boolean)this.hasKeyAInKeyDownExpression(replacementComponentToListenOn));
    }

    @Test
    public void listenOnUIIsClosing_eventIsPopulatedForANewUI() {
        UI ui = (UI)Mockito.spy(UI.class);
        FakeComponent owner = new FakeComponent();
        Component[] components = new Component[]{ui};
        ui.add(new Component[]{owner});
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        UI newUI = (UI)Mockito.spy(UI.class);
        ui.close();
        components[0] = newUI;
        owner.getElement().removeFromTree(false);
        newUI.add(new Component[]{owner});
        ArgumentCaptor captor = ArgumentCaptor.forClass(SerializableConsumer.class);
        ((UI)Mockito.verify((Object)ui, (VerificationMode)Mockito.atLeastOnce())).beforeClientResponse((Component)ArgumentMatchers.eq((Object)((Object)owner)), (SerializableConsumer)captor.capture());
        SerializableConsumer consumer = (SerializableConsumer)captor.getValue();
        consumer.accept(Mockito.mock(ExecutionContext.class));
        Assert.assertTrue((boolean)this.hasKeyAInKeyDownExpression((Component)newUI));
    }

    @Test
    public void shortcutRegistrationReturnedByClickNotifierHasCorrectDefault() {
        FakeComponent fakeComponent = new FakeComponent();
        ShortcutRegistration registration = fakeComponent.addClickShortcut(Key.KEY_A, new KeyModifier[0]);
        Assert.assertTrue((String)"Allows default was not true", (boolean)registration.isBrowserDefaultAllowed());
        Assert.assertFalse((String)"Allows propagation was not false", (boolean)registration.isEventPropagationAllowed());
        Assert.assertFalse((String)"Reset focus on active element was not set to false", (boolean)registration.isResetFocusOnActiveElement());
    }

    @Test
    public void shortcutRegistrationReturnedByFocusableHasCorrectDefaults() {
        FakeComponent fakeComponent = new FakeComponent();
        ShortcutRegistration registration = fakeComponent.addFocusShortcut(Key.KEY_A, new KeyModifier[0]);
        Assert.assertFalse((String)"Allows default was not false", (boolean)registration.isBrowserDefaultAllowed());
        Assert.assertFalse((String)"Allows propagation was not false", (boolean)registration.isEventPropagationAllowed());
        Assert.assertFalse((String)"Reset focus on active element was not set to false", (boolean)registration.isResetFocusOnActiveElement());
    }

    @Test
    public void listenOnWithDuplicateShouldThrowException() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("listenOnComponents should not have duplicate entries!");
        registration.listenOn(new Component[]{this.listenOn[0], this.listenOn[1], this.listenOn[1]});
    }

    @Test
    public void listenOnWithNullEntriesShouldThrowException() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("listenOnComponents should not contain null!");
        registration.listenOn(new Component[]{this.listenOn[0], null, this.listenOn[1]});
    }

    @Test
    public void listenOnItemsAreChangedAfterCallingListenOnShouldNotHaveAnyEffect() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Component[] newListenOn = new Component[]{this.listenOn[0], this.listenOn[1]};
        registration.listenOn(newListenOn);
        newListenOn[0] = null;
        newListenOn[1] = null;
        this.clientResponse();
        Assert.assertTrue((boolean)registration.isShortcutActive());
    }

    @Test
    public void listenOnComponentHasElementLocatorJs_jsExecutionScheduled() {
        ElementLocatorTestFixture fixture = new ElementLocatorTestFixture(this);
        Key key = Key.KEY_A;
        fixture.createNewShortcut(key);
        List<PendingJavaScriptInvocation> pendingJavaScriptInvocations = fixture.writeResponse();
        PendingJavaScriptInvocation js = pendingJavaScriptInvocations.get(0);
        String expression = js.getInvocation().getExpression();
        Assert.assertTrue((String)("element locator string " + fixture.elementLocatorJs + " missing from JS execution string " + expression), (boolean)expression.contains("const delegate=" + fixture.elementLocatorJs + ";"));
        Assert.assertTrue((String)("JS execution string should have event.preventDefault() in it" + expression), (boolean)expression.contains("event.preventDefault();"));
        Assert.assertTrue((String)("JS execution string should always have event.stopPropagation() in it" + expression), (boolean)expression.contains("event.stopPropagation();"));
        Assert.assertTrue((String)("JS execution string missing the key" + String.valueOf(key)), (boolean)expression.contains((CharSequence)key.getKeys().get(0)));
        Assert.assertFalse((String)("JS execution string should not have blur() and focus() on active element in it" + expression), (boolean)expression.contains("window.Vaadin.Flow.resetFocus()"));
        fixture.registration.remove();
        fixture.createNewShortcut(Key.KEY_X);
        pendingJavaScriptInvocations = fixture.writeResponse();
        Assert.assertEquals((long)0L, (long)pendingJavaScriptInvocations.size());
    }

    @Test
    public void listenOnComponentHasElementLocatorJs_allowBrowserDefault_JsExecutionDoesNotPreventDefault() {
        ElementLocatorTestFixture fixture = new ElementLocatorTestFixture(this);
        Key key = Key.KEY_A;
        fixture.createNewShortcut(key).allowBrowserDefault();
        List<PendingJavaScriptInvocation> pendingJavaScriptInvocations = fixture.writeResponse();
        PendingJavaScriptInvocation js = pendingJavaScriptInvocations.get(0);
        String expression = js.getInvocation().getExpression();
        Assert.assertFalse((String)("JS execution string should NOT have event.preventDefault() in it" + expression), (boolean)expression.contains("event.preventDefault();"));
    }

    @Test
    public void listenOnComponentHasElementLocatorJs_resetFocusOnActiveElement_JsExecutionResetFocusOnActiveElement() {
        ElementLocatorTestFixture fixture = new ElementLocatorTestFixture(this);
        Key key = Key.KEY_A;
        fixture.createNewShortcut(key).resetFocusOnActiveElement();
        List<PendingJavaScriptInvocation> pendingJavaScriptInvocations = fixture.writeResponse();
        PendingJavaScriptInvocation js = pendingJavaScriptInvocations.get(0);
        String expression = js.getInvocation().getExpression();
        Assert.assertTrue((String)("JS execution string should have blur() and focus() on active element in it" + expression), (boolean)expression.contains("window.Vaadin.Flow.resetFocus()"));
    }

    @Test
    public void constructedRegistration_lifecycleIsVisibleAndEnabled_shorcutEventIsFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A);
        this.mockLifecycle(true);
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNotNull(event.get());
    }

    @Test
    public void constructedRegistration_lifecycleOnwerIsDisabled_shorcutEventIsNotFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A);
        Element element = this.mockLifecycle(true);
        element.setEnabled(false);
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNull(event.get());
    }

    @Test
    public void constructedRegistration_lifecycleOwnerIsDisabledWithDisabledUpdateModeAlways_shortcutEventIsFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        Element element = this.mockLifecycle(true);
        element.setEnabled(false);
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNotNull(event.get());
    }

    @Test
    public void constructedRegistration_lifecycleOnwerIsInvisible_shorcutEventIsNotFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A);
        this.mockLifecycle(false);
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNull(event.get());
    }

    @Test
    public void constructedRegistration_lifecycleOnwerAncestorsAreVisible_shorcutEventIsFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A);
        this.mockLifecycle(true);
        Mockito.when((Object)this.lifecycleOwner.getParent()).thenReturn(Optional.of(new FakeComponent()));
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNotNull(event.get());
    }

    @Test
    public void uiRegistration_uiHasModalComponent_eventIsSentFromModalComponentInsteadOfUi() {
        AtomicReference eventRef = new AtomicReference();
        Component modal = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)modal.getUI()).thenReturn(Optional.of(this.ui));
        Mockito.when((Object)modal.getEventBus()).thenReturn((Object)new ComponentEventBus(modal));
        Mockito.when((Object)modal.getElement()).thenReturn((Object)new Element("tag"));
        Mockito.when((Object)modal.isVisible()).thenReturn((Object)true);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Mockito.when((Object)uiInternals.hasModalComponent()).thenReturn((Object)true);
        Mockito.when((Object)uiInternals.getActiveModalComponent()).thenReturn((Object)modal);
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)uiInternals);
        this.listenOn = new Component[]{this.ui};
        Mockito.when((Object)this.ui.getUI()).thenReturn(Optional.of(this.ui));
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, eventRef::set, Key.KEY_A);
        this.mockLifecycle(true);
        Mockito.when((Object)this.lifecycleOwner.getParent()).thenReturn(Optional.of(modal));
        this.clientResponse(this.listenOn);
        modal.getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        ShortcutEvent event = (ShortcutEvent)eventRef.get();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)modal, (Object)event.getSource());
    }

    @Test
    public void constructedRegistration_lifecycleOnwerHasInvisibleParent_shorcutEventIsNotFired() {
        AtomicReference event = new AtomicReference();
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, event::set, Key.KEY_A);
        this.mockLifecycle(true);
        FakeComponent component = new FakeComponent();
        component.setVisible(false);
        Mockito.when((Object)this.lifecycleOwner.getParent()).thenReturn(Optional.of(component));
        this.clientResponse();
        this.listenOn[0].getEventBus().fireEvent((ComponentEvent)new KeyDownEvent(this.listenOn[0], Key.KEY_A.toString()));
        Assert.assertNull(event.get());
    }

    @Test
    public void constructedRegistration_lifeCycleOwnerIsDetached_detachListenerIsDeregisteredFromListenOnComponents() {
        AtomicReference detachListener = new AtomicReference();
        ((Component)Mockito.doAnswer(invocaation -> {
            detachListener.set((ComponentEventListener)invocaation.getArgument(0, ComponentEventListener.class));
            return Mockito.mock(Registration.class);
        }).when((Object)this.lifecycleOwner)).addDetachListener((ComponentEventListener)ArgumentMatchers.any());
        new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Registration registration = (Registration)Mockito.mock(Registration.class);
        for (Component component : this.listenOn) {
            Mockito.when((Object)component.addDetachListener((ComponentEventListener)Mockito.any())).thenReturn((Object)registration);
        }
        this.clientResponse();
        ((ComponentEventListener)detachListener.get()).onComponentEvent((ComponentEvent)new DetachEvent(this.lifecycleOwner));
        ((Registration)Mockito.verify((Object)registration, (VerificationMode)Mockito.times((int)3))).remove();
    }

    @Test
    public void reattachComponent_detachListenerIsAddedOnEveryAttach_listenOnUIIsClosing_eventIsPopulatedForANewUI() {
        UI ui = (UI)Mockito.spy(UI.class);
        FakeComponent owner = new FakeComponent();
        Registration registration = (Registration)Mockito.mock(Registration.class);
        AtomicInteger count = new AtomicInteger();
        ((UI)Mockito.doAnswer(invocation -> {
            count.incrementAndGet();
            return registration;
        }).when((Object)ui)).addDetachListener((ComponentEventListener)ArgumentMatchers.any());
        Component[] components = new Component[]{ui};
        ui.add(new Component[]{owner});
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        ArgumentCaptor captor = ArgumentCaptor.forClass(SerializableConsumer.class);
        ((UI)Mockito.verify((Object)ui, (VerificationMode)Mockito.atLeastOnce())).beforeClientResponse((Component)ArgumentMatchers.eq((Object)((Object)owner)), (SerializableConsumer)captor.capture());
        SerializableConsumer consumer = (SerializableConsumer)captor.getValue();
        consumer.accept(Mockito.mock(ExecutionContext.class));
        Assert.assertEquals((long)1L, (long)count.get());
        ui.remove(new Component[]{owner});
        ui.add(new Component[]{owner});
        consumer.accept(Mockito.mock(ExecutionContext.class));
        Assert.assertEquals((long)2L, (long)count.get());
        UI newUI = (UI)Mockito.spy(UI.class);
        ui.close();
        components[0] = newUI;
        owner.getElement().removeFromTree(false);
        newUI.add(new Component[]{owner});
        ((UI)Mockito.verify((Object)newUI, (VerificationMode)Mockito.atLeastOnce())).beforeClientResponse((Component)ArgumentMatchers.eq((Object)((Object)owner)), (SerializableConsumer)captor.capture());
        ((SerializableConsumer)captor.getValue()).accept(Mockito.mock(ExecutionContext.class));
        Assert.assertTrue((boolean)this.hasKeyAInKeyDownExpression((Component)newUI));
    }

    @Test
    public void attachAndDetachComponent_sameRoundTrip_beforeClientResponseListenerRemoved() {
        UI ui = (UI)Mockito.spy(UI.class);
        FakeComponent owner = new FakeComponent();
        final ArrayList beforeClientRegistrations = new ArrayList();
        ((UI)Mockito.doAnswer(i -> {
            StateTree.ExecutionRegistration registration = new StateTree.ExecutionRegistration(){

                public void remove() {
                    beforeClientRegistrations.remove(this);
                }
            };
            beforeClientRegistrations.add(registration);
            return registration;
        }).when((Object)ui)).beforeClientResponse((Component)ArgumentMatchers.eq((Object)((Object)owner)), (SerializableConsumer)ArgumentMatchers.any());
        ui.add(new Component[]{owner});
        Component[] components = new Component[]{ui};
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertEquals((long)1L, (long)beforeClientRegistrations.size());
        ui.remove(new Component[]{owner});
        Assert.assertEquals((long)0L, (long)beforeClientRegistrations.size());
        ui.add(new Component[]{owner});
        Assert.assertEquals((long)1L, (long)beforeClientRegistrations.size());
        ui.remove(new Component[]{owner});
        Assert.assertEquals((long)0L, (long)beforeClientRegistrations.size());
    }

    @Test
    public void toString_listenOnComponentsNotInitialized_doesNotFail() {
        ShortcutRegistration registration = new ShortcutRegistration(this.lifecycleOwner, (SerializableSupplier & Serializable)() -> this.listenOn, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        Assert.assertTrue((boolean)registration.toString().contains("listenOn = []"));
        this.clientResponse();
        Assert.assertTrue((boolean)registration.toString().matches(".*listenOn = \\[[^]]+],.*"));
    }

    private Element mockLifecycle(boolean visible) {
        Mockito.when((Object)this.lifecycleOwner.isVisible()).thenReturn((Object)visible);
        Element element = ElementFactory.createAnchor();
        Mockito.when((Object)this.lifecycleOwner.getElement()).thenReturn((Object)element);
        return element;
    }

    private void clientResponse() {
        this.clientResponse(this.listenOn);
    }

    private void clientResponse(Component[] listenOnMock) {
        for (Component component : listenOnMock) {
            Mockito.when((Object)component.getElement()).thenReturn((Object)new Element("tag"));
            Mockito.when((Object)component.getEventBus()).thenReturn((Object)new ComponentEventBus(component));
        }
        ArgumentCaptor captor = ArgumentCaptor.forClass(SerializableConsumer.class);
        ((UI)Mockito.verify((Object)this.ui, (VerificationMode)Mockito.atLeastOnce())).beforeClientResponse((Component)ArgumentMatchers.eq((Object)this.lifecycleOwner), (SerializableConsumer)captor.capture());
        SerializableConsumer consumer = (SerializableConsumer)captor.getValue();
        consumer.accept(Mockito.mock(ExecutionContext.class));
    }

    private boolean hasKeyAInKeyDownExpression(Component component) {
        ElementListenerMap map = (ElementListenerMap)component.getElement().getNode().getFeature(ElementListenerMap.class);
        boolean hasKeyA = false;
        for (String expression : map.getExpressions("keydown")) {
            if (!expression.contains((CharSequence)Key.KEY_A.getKeys().get(0))) continue;
            hasKeyA = true;
        }
        return hasKeyA;
    }

    @Tag(value="imaginary-tag")
    private class FakeComponent
    extends Component
    implements ClickNotifier<FakeComponent>,
    Focusable<FakeComponent> {
        private FakeComponent() {
        }
    }

    class ElementLocatorTestFixture {
        final Registration registration;
        final Component owner;
        private final String elementLocatorJs;
        private final Component[] components;
        private final UI ui;

        ElementLocatorTestFixture(ShortcutRegistrationTest this$0) {
            VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
            Mockito.when((Object)session.hasLock()).thenReturn((Object)true);
            this.ui = (UI)Mockito.spy(UI.class);
            this.ui.getInternals().setSession(session);
            this.owner = this$0.new FakeComponent();
            FakeComponent initialComponentToListenOn = this$0.new FakeComponent();
            this.components = new Component[]{initialComponentToListenOn};
            this.ui.add(new Component[]{this.owner});
            this.ui.add(new Component[]{initialComponentToListenOn});
            this.elementLocatorJs = "foobar";
            this.registration = Shortcuts.setShortcutListenOnElement((String)this.elementLocatorJs, (Component)initialComponentToListenOn);
        }

        List<PendingJavaScriptInvocation> writeResponse() {
            this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
            return this.ui.getInternals().dumpPendingJavaScriptInvocations();
        }

        ShortcutRegistration createNewShortcut(Key key) {
            return new ShortcutRegistration(this.owner, (SerializableSupplier & Serializable)() -> this.components, (ShortcutEventListener & Serializable)event -> {}, key);
        }
    }
}

