/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.tests.util.MockUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocationObserverTest {
    protected Router router;
    private UI ui;
    private static List<String> eventCollector = new ArrayList<String>(0);

    @Before
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.ui = new MockUI();
        eventCollector.clear();
    }

    @Test
    public void navigation_and_locale_change_should_fire_locale_change_observer() throws InvalidRouteConfigurationException {
        this.router = new Router((RouteRegistry)new TestRouteRegistry());
        this.ui = new MockUI(this.router);
        RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry()).setAnnotatedRoute(Translations.class);
        this.ui.navigate("");
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)eventCollector.size());
        Assert.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
        this.ui.setLocale(Locale.CANADA);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)2L, (long)eventCollector.size());
        Assert.assertEquals((Object)("Received locale change event for locale: " + Locale.CANADA.getDisplayName()), (Object)eventCollector.get(1));
    }

    @Test
    public void location_change_should_only_fire_if_location_actually_changed() {
        this.ui.add(new Component[]{new Translations()});
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)eventCollector.size());
        Assert.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
        this.ui.setLocale(this.ui.getLocale());
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)eventCollector.size());
        this.ui.setLocale(Locale.FRENCH);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)2L, (long)eventCollector.size());
        Assert.assertEquals((Object)("Received locale change event for locale: " + Locale.FRENCH.getDisplayName()), (Object)eventCollector.get(1));
    }

    @Test
    public void location_change_should_be_fired_also_on_component_attach() {
        RootComponent root = new RootComponent();
        this.ui.add(new Component[]{root});
        Assert.assertEquals((String)"Expected event amount was wrong", (long)0L, (long)eventCollector.size());
        root.getElement().appendChild(new Element[]{new Translations().getElement()});
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)eventCollector.size());
        Assert.assertEquals((Object)("Received locale change event for locale: " + Locale.getDefault().getDisplayName()), (Object)eventCollector.get(0));
    }

    @Test
    public void location_change_should_be_fired_also_on_consequent_component_attach() {
        RootComponent root = new RootComponent();
        this.ui.add(new Component[]{root});
        Assert.assertEquals((String)"No change observers so no events should be gotten.", (long)0L, (long)eventCollector.size());
        Translations translations = new Translations();
        root.getElement().appendChild(new Element[]{translations.getElement()});
        Assert.assertEquals((String)"Observer should have been notified on attach", (long)1L, (long)eventCollector.size());
        translations.getElement().removeFromParent();
        Assert.assertEquals((String)"No event should have been gotten for removal", (long)1L, (long)eventCollector.size());
        root.getElement().appendChild(new Element[]{translations.getElement()});
        Assert.assertEquals((String)"Reattach should have given an event", (long)2L, (long)eventCollector.size());
    }

    @Route(value="")
    @Tag(value="div")
    public static class Translations
    extends Component
    implements LocaleChangeObserver {
        public void localeChange(LocaleChangeEvent event) {
            eventCollector.add("Received locale change event for locale: " + event.getLocale().getDisplayName());
            Assert.assertNotNull((Object)event.getUI());
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootComponent
    extends Component {
    }
}

