/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.dom.ClassList;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class HasStyleTest {
    @Test
    public void addClassName() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassName("foo");
        this.assertClasses(component, "foo");
        component.addClassName("bar");
        this.assertClasses(component, "foo", "bar");
        component.getClassNames().add((Object)"baz");
        this.assertClasses(component, "foo", "bar", "baz");
    }

    @Test
    public void setClassName_useClassList() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo bar");
        component.getClassNames().set("bar", false);
        this.assertClasses(component, "foo");
    }

    @Test
    public void removeClassName() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo Bar baz");
        component.removeClassName("foo");
        this.assertClasses(component, "Bar", "baz");
        component.removeClassName("bar");
        this.assertClasses(component, "Bar", "baz");
        component.removeClassName("Bar");
        this.assertClasses(component, "baz");
        component.removeClassName("baz");
        this.assertClasses(component, new String[0]);
        component.setClassName("foo");
        component.getClassNames().remove((Object)"foo");
        this.assertClasses(component, new String[0]);
    }

    @Test
    public void setClassName() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo");
        this.assertClasses(component, "foo");
        component.setClassName("bar");
        this.assertClasses(component, "bar");
        component.setClassName("bar foo");
        this.assertClasses(component, "bar", "foo");
        component.setClassName(" ");
        this.assertClasses(component, new String[0]);
        component.setClassName("");
        this.assertClasses(component, new String[0]);
        component.setClassName("removeMe");
        component.setClassName(null);
        this.assertClasses(component, new String[0]);
    }

    @Test
    public void getClassName() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo");
        Assert.assertEquals((Object)"foo", (Object)component.getClassName());
        component.setClassName(" ");
        Assert.assertNull((Object)component.getClassName());
    }

    @Test
    public void setClassNameToggle() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo", false);
        this.assertClasses(component, new String[0]);
        component.setClassName("foo", true);
        this.assertClasses(component, "foo");
        component.setClassName("foo", false);
        this.assertClasses(component, new String[0]);
        component.setClassName("foo", true);
        component.setClassName("bar", true);
        component.setClassName("baz", true);
        this.assertClasses(component, "foo", "bar", "baz");
        component.setClassName("baz", false);
        this.assertClasses(component, "foo", "bar");
    }

    @Test
    public void hasClassName() {
        HasStyleComponent component = new HasStyleComponent();
        Assert.assertFalse((boolean)component.hasClassName("foo"));
        component.setClassName("foo");
        Assert.assertTrue((boolean)component.hasClassName("foo"));
        Assert.assertFalse((boolean)component.hasClassName("fo"));
        component.setClassName("foo bar");
        Assert.assertTrue((boolean)component.hasClassName("foo"));
        Assert.assertTrue((boolean)component.hasClassName("bar"));
    }

    @Test
    public void getClassList_elementClassList() {
        HasStyleComponent component = new HasStyleComponent();
        Assert.assertEquals((Object)component.getElement().getClassList(), (Object)component.getClassNames());
    }

    @Test
    public void testAddClassNames() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[0]);
        this.assertClasses(component, new String[0]);
        component.addClassNames(new String[]{"foo", "bar"});
        this.assertClasses(component, "foo", "bar");
        component.removeClassNames(new String[]{"foo bar"});
        this.assertClasses(component, new String[0]);
        component.addClassNames(new String[]{"foo bar"});
        this.assertClasses(component, "foo", "bar");
        component.addClassNames(new String[]{"baz1", "baz2"});
        this.assertClasses(component, "foo", "bar", "baz1", "baz2");
    }

    @Test
    public void testRemoveClassNames() {
        HasStyleComponent component = new HasStyleComponent();
        component.setClassName("foo bar baz1 baz2 foo2 bar1");
        component.removeClassNames(new String[0]);
        this.assertClasses(component, "foo", "bar", "baz1", "baz2", "foo2", "bar1");
        component.removeClassNames(new String[]{"baz2"});
        this.assertClasses(component, "foo", "bar", "baz1", "foo2", "bar1");
        component.removeClassNames(new String[]{"bar", "foo2", "foo"});
        this.assertClasses(component, "baz1", "bar1");
    }

    @Test
    public void addClassNames_extraSpacesBetweenAndAroundClassNames_validationPasses() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{"   foo  bar    baz"});
        Assert.assertEquals((String)"Unexpected component's class names count after adding 3 class names", (long)3L, (long)component.getClassNames().size());
        Assert.assertTrue((boolean)component.getClassNames().contains((Object)"foo"));
        Assert.assertTrue((boolean)component.getClassNames().contains((Object)"bar"));
        Assert.assertTrue((boolean)component.getClassNames().contains((Object)"baz"));
    }

    @Test
    public void removeClassNames_extraSpacesBetweenAndAroundClassNames_validationPasses() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{"foo", "bar", "baz"});
        component.removeClassNames(new String[]{"   foo  bar    baz"});
        Assert.assertEquals((String)"Unexpected component's class names count after removing all class names", (long)0L, (long)component.getClassNames().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addClassNames_addEmptyClassName_throws() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{" "});
    }

    @Test(expected=IllegalArgumentException.class)
    public void addClassNames_addNullClassName_throws() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeClassNames_removeEmptyClassName_throws() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{" "});
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeClassNames_removeNullClassName_throws() {
        HasStyleComponent component = new HasStyleComponent();
        component.addClassNames(new String[]{null, null});
    }

    @Test
    public void setColorScheme_setsInlineStyleProperty() {
        HasStyleComponent component = new HasStyleComponent();
        component.getStyle().setColorScheme(ColorScheme.Value.DARK);
        Assert.assertEquals((Object)"dark", (Object)component.getElement().getStyle().get("color-scheme"));
        component.getStyle().setColorScheme(ColorScheme.Value.LIGHT);
        Assert.assertEquals((Object)"light", (Object)component.getElement().getStyle().get("color-scheme"));
        component.getStyle().setColorScheme(ColorScheme.Value.LIGHT_DARK);
        Assert.assertEquals((Object)"light dark", (Object)component.getElement().getStyle().get("color-scheme"));
    }

    @Test
    public void getColorScheme_retrievesSetValue() {
        HasStyleComponent component = new HasStyleComponent();
        component.getStyle().setColorScheme(ColorScheme.Value.DARK);
        Assert.assertEquals((Object)ColorScheme.Value.DARK, (Object)component.getStyle().getColorScheme());
        component.getStyle().setColorScheme(ColorScheme.Value.LIGHT);
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)component.getStyle().getColorScheme());
    }

    @Test
    public void setColorScheme_nullClearsProperty() {
        HasStyleComponent component = new HasStyleComponent();
        component.getStyle().setColorScheme(ColorScheme.Value.DARK);
        Assert.assertEquals((Object)"dark", (Object)component.getElement().getStyle().get("color-scheme"));
        component.getStyle().setColorScheme(null);
        Assert.assertNull((Object)component.getElement().getStyle().get("color-scheme"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)component.getStyle().getColorScheme());
    }

    @Test
    public void setColorScheme_normalClearsProperty() {
        HasStyleComponent component = new HasStyleComponent();
        component.getStyle().setColorScheme(ColorScheme.Value.DARK);
        Assert.assertEquals((Object)"dark", (Object)component.getElement().getStyle().get("color-scheme"));
        component.getStyle().setColorScheme(ColorScheme.Value.NORMAL);
        Assert.assertNull((Object)component.getElement().getStyle().get("color-scheme"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)component.getStyle().getColorScheme());
    }

    @Test
    public void colorScheme_roundtripWorks() {
        HasStyleComponent component = new HasStyleComponent();
        for (ColorScheme.Value value : ColorScheme.Value.values()) {
            if (value == ColorScheme.Value.NORMAL || value == ColorScheme.Value.SYSTEM) continue;
            component.getStyle().setColorScheme(value);
            Assert.assertEquals((String)("Roundtrip failed for " + String.valueOf(value)), (Object)value, (Object)component.getStyle().getColorScheme());
        }
    }

    @Test
    public void getColorScheme_notSet_returnsNormal() {
        HasStyleComponent component = new HasStyleComponent();
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)component.getStyle().getColorScheme());
    }

    private void assertClasses(HasStyleComponent c, String ... expectedClasses) {
        ClassList actual = c.getClassNames();
        HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedClasses));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Tag(value="div")
    public static class HasStyleComponent
    extends Component
    implements HasStyle {
    }
}

