/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.dom.Element;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class HTMLTest {
    @Test
    public void attachedToElement() {
        new Html("<b>Hello</b>").getParent();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullHtml() {
        new Html((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullStream() {
        new Html((InputStream)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyHtml() {
        new Html("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void twoRoots() {
        new Html("<b></b><div></div>");
    }

    @Test(expected=IllegalArgumentException.class)
    public void text() {
        new Html("hello");
    }

    @Test
    public void simpleHtml() {
        Html html = new Html("<span>hello</span>");
        Assert.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assert.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void setHtmlContent() {
        Html html = new Html("<span>hello</span>");
        Assert.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assert.assertEquals((Object)"hello", (Object)html.getInnerHtml());
        html.setHtmlContent("<span>world</span>");
        Assert.assertEquals((Object)"world", (Object)html.getInnerHtml());
    }

    @Test(expected=IllegalStateException.class)
    public void setHtmlContent_tagMismatch() {
        Html html = new Html("<span>hello</span>");
        Assert.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assert.assertEquals((Object)"hello", (Object)html.getInnerHtml());
        html.setHtmlContent("<div>world</div>");
        Assert.assertEquals((Object)"world", (Object)html.getInnerHtml());
    }

    @Test
    public void rootAttributes() {
        Html html = new Html("<span foo='bar'>hello</span>");
        Assert.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assert.assertEquals((long)1L, (long)html.getElement().getAttributeNames().count());
        Assert.assertEquals((Object)"bar", (Object)html.getElement().getAttribute("foo"));
        Assert.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void rootSpecialAttributes() {
        Html html = new Html("<span class='foo' style='color: red'>hello</span>");
        Element element = html.getElement();
        Assert.assertEquals((Object)"span", (Object)element.getTag());
        Assert.assertEquals((long)2L, (long)element.getAttributeNames().count());
        Assert.assertEquals((Object)"foo", (Object)element.getAttribute("class"));
        Assert.assertEquals((Object)"color:red", (Object)element.getAttribute("style"));
        Assert.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void fromStream() {
        new Html((InputStream)new ByteArrayInputStream("<div><span>contents</span></div>".getBytes()));
    }

    @Test
    public void brokenHtml() {
        Html html = new Html("<b></div>");
        Assert.assertEquals((Object)"b", (Object)html.getElement().getTag());
        Assert.assertEquals((Object)"", (Object)html.getInnerHtml());
    }

    @Test
    public void extraWhitespace() {
        String input = "   <span>        <div>       <b>Hello!</b>    </div></span>  ";
        Html html = new Html(input);
        Assert.assertEquals((Object)"span", (Object)html.getElement().getTag());
        String expectedInnerHtml = input.replaceAll("^[ ]*<span>", "").replaceAll("</span>[ ]*$", "");
        Assert.assertEquals((Object)expectedInnerHtml, (Object)html.getInnerHtml());
    }

    @Test
    public void emptyAttribute_elementIsCreatedAndHasAttribute() {
        Html html = new Html("<audio controls></audio>");
        Assert.assertEquals((Object)"", (Object)html.getElement().getAttribute("controls"));
        Assert.assertEquals((Object)"<audio controls></audio>", (Object)html.getElement().getOuterHTML());
    }

    @Test
    public void styleElementAsString_elementIsUsed() {
        Html html = new Html("<style></style>");
        Assert.assertEquals((Object)"style", (Object)html.getElement().getTag());
    }

    @Test
    public void styleElementAsStream_elementIsUsed() {
        Html html = new Html((InputStream)new ByteArrayInputStream("<style></style>".getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"style", (Object)html.getElement().getTag());
    }
}

