/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.InvalidCustomElementNameException;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.startup.WebComponentConfigurationRegistryInitializer;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@NotThreadSafe
public class WebComponentConfigurationRegistryInitializerTest {
    private static final String DUPLICATE_PROPERTY_NAME = "one";
    private WebComponentConfigurationRegistryInitializer initializer;
    @Mock
    private WebComponentConfigurationRegistry registry;
    @Mock
    private ServletContext servletContext;
    @Mock
    private VaadinService vaadinService;
    @Mock
    private VaadinContext context;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute(WebComponentConfigurationRegistry.class))).thenReturn((Object)this.registry);
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute((Class)ArgumentMatchers.eq(WebComponentConfigurationRegistry.class), (Supplier)ArgumentMatchers.any()))).thenReturn((Object)this.registry);
        this.initializer = new WebComponentConfigurationRegistryInitializer();
        Mockito.when((Object)this.servletContext.getAttribute(WebComponentConfigurationRegistry.class.getName())).thenReturn((Object)this.registry);
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        Mockito.when((Object)this.vaadinService.getInstantiator()).thenReturn((Object)new MockInstantiator(new VaadinServiceInitListener[0]));
    }

    @After
    public void cleanUp() {
        CurrentInstance.clearAll();
    }

    @Test
    public void process() throws ServletException {
        this.initializer.process(Stream.of(MyComponentExporter.class, UserBoxExporter.class, ExporterFactory.class).collect(Collectors.toSet()), this.servletContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Set.class);
        ((WebComponentConfigurationRegistry)Mockito.verify((Object)this.registry)).setConfigurations((Set)captor.capture());
        Set set = (Set)captor.getValue();
        Assert.assertEquals((long)3L, (long)set.size());
        Set componentClasses = set.stream().map(WebComponentConfiguration.class::cast).map(WebComponentConfiguration::getComponentClass).collect(Collectors.toSet());
        Assert.assertTrue((boolean)componentClasses.contains(MyComponent.class));
        Assert.assertTrue((boolean)componentClasses.contains(UserBox.class));
        Assert.assertTrue((boolean)componentClasses.contains(InvalidName.class));
    }

    @Test
    public void process_noExceptionWithNullArguments() {
        try {
            this.initializer.process(null, this.servletContext);
        }
        catch (Exception e) {
            Assert.fail((String)"WebComponentRegistryInitializer.process should not throw with null argument");
        }
        ((WebComponentConfigurationRegistry)Mockito.verify((Object)this.registry)).setConfigurations(Collections.emptySet());
    }

    @Test
    public void process_noExceptionForMultipleCorrectExportsOfTheSameComponent() {
        try {
            this.initializer.process(Stream.of(MyComponentExporter.class, SiblingExporter.class).collect(Collectors.toSet()), this.servletContext);
        }
        catch (Exception e) {
            Assert.fail((String)"WebComponentRegistryInitializer.process should not throw with 'sibling' exporters");
        }
    }

    @Test
    public void emptySet_noExceptionAndWebComponentsSet() {
        try {
            this.initializer.process(Collections.emptySet(), this.servletContext);
        }
        catch (Exception e) {
            Assert.fail((String)"WebComponentRegistryInitializer.process should not throw with empty set");
        }
        ((WebComponentConfigurationRegistry)Mockito.verify((Object)this.registry)).setConfigurations(Collections.emptySet());
    }

    @Test
    public void duplicateNamesFoundprocess_exceptionIsThrown() throws ServletException {
        this.expectedEx.expect(ServletException.class);
        this.expectedEx.expectCause((Matcher)CauseMatcher.ex(IllegalArgumentException.class).msgStartsWith("Found two WebComponentExporter classes"));
        this.initializer.process(Stream.of(MyComponentExporter.class, DuplicateTagExporter.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void invalidCustomElementName_initializerThrowsException() throws ServletException {
        this.expectedEx.expect(ServletException.class);
        this.expectedEx.expectCause((Matcher)CauseMatcher.ex(InvalidCustomElementNameException.class).msgEquals(String.format("Tag name '%s' given by '%s' is not a valid custom element name.", "invalid", InvalidNameExporter.class.getCanonicalName())));
        this.initializer.process(Collections.singleton(InvalidNameExporter.class), this.servletContext);
    }

    @Test
    public void duplicatePropertyRegistration_doesNotCauseIssues() throws ServletException {
        this.initializer.process(Collections.singleton(DuplicatePropertyExporter.class), this.servletContext);
    }

    @Test
    public void duplicatePropertyRegistrationBetweenParentAndChild_doesNotCauseIssues() throws ServletException {
        this.initializer.process(Collections.singleton(ExtendingExporter.class), this.servletContext);
    }

    public static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            this("my-component");
        }

        protected MyComponentExporter(String tag) {
            super(tag);
            this.addProperty(WebComponentConfigurationRegistryInitializerTest.DUPLICATE_PROPERTY_NAME, "component");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class UserBoxExporter
    extends WebComponentExporter<UserBox> {
        public UserBoxExporter() {
            super("user-box");
            this.addProperty("user", "box");
        }

        public void configureInstance(WebComponent<UserBox> webComponent, UserBox component) {
        }
    }

    public static class ExporterFactory
    implements WebComponentExporterFactory<InvalidName> {
        public WebComponentExporter<InvalidName> create() {
            return new PrivateExporter("foo-bar");
        }
    }

    private static class MyComponent
    extends Component {
        private MyComponent() {
        }
    }

    private static class UserBox
    extends Component {
        private UserBox() {
        }
    }

    private static class InvalidName
    extends Component {
        private InvalidName() {
        }
    }

    public static class SiblingExporter
    extends WebComponentExporter<MyComponent> {
        public SiblingExporter() {
            super("my-component-sibling");
            this.addProperty("name", "something");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class CauseMatcher
    extends BaseMatcher<Throwable> {
        private final Class<? extends Throwable> throwableType;
        private boolean startsWith = false;
        private String matchable = null;

        private CauseMatcher(Class<? extends Throwable> throwableType) {
            this.throwableType = throwableType;
        }

        public boolean matches(Object o) {
            Throwable throwable = ((Throwable)o).getCause();
            if (!this.throwableType.equals(throwable.getClass())) {
                return false;
            }
            if (this.matchable != null) {
                if (this.startsWith) {
                    return throwable.getMessage().startsWith(this.matchable);
                }
                return throwable.getMessage().equals(this.matchable);
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("<%s: %s%s>", this.throwableType.getCanonicalName(), this.matchable, this.startsWith ? "..." : ""));
        }

        public static CauseMatcher ex(Class<? extends Throwable> throwableType) {
            return new CauseMatcher(throwableType);
        }

        public CauseMatcher msgStartsWith(String str) {
            this.startsWith = true;
            this.matchable = str;
            return this;
        }

        public CauseMatcher msgEquals(String str) {
            this.startsWith = false;
            this.matchable = str;
            return this;
        }
    }

    public static class DuplicateTagExporter
    extends WebComponentExporter<MyComponent> {
        public DuplicateTagExporter() {
            super("my-component");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class InvalidNameExporter
    extends WebComponentExporter<InvalidName> {
        public InvalidNameExporter() {
            super("invalid");
        }

        public void configureInstance(WebComponent<InvalidName> webComponent, InvalidName component) {
        }
    }

    public static class DuplicatePropertyExporter
    extends WebComponentExporter<MyComponent> {
        public DuplicatePropertyExporter() {
            super("tag-2");
            this.addProperty(WebComponentConfigurationRegistryInitializerTest.DUPLICATE_PROPERTY_NAME, "two");
            this.addProperty(WebComponentConfigurationRegistryInitializerTest.DUPLICATE_PROPERTY_NAME, "four");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class ExtendingExporter
    extends MyComponentExporter {
        public ExtendingExporter() {
            super("tag-1");
            this.addProperty(WebComponentConfigurationRegistryInitializerTest.DUPLICATE_PROPERTY_NAME, "something");
        }
    }

    private static class PrivateExporter
    extends WebComponentExporter<InvalidName> {
        private PrivateExporter(String tag) {
            super(tag);
        }

        protected void configureInstance(WebComponent<InvalidName> webComponent, InvalidName component) {
        }
    }
}

