/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.startup.BaseLicenseCheckerServiceInitListener;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.Capabilities;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.util.List;
import java.util.function.Consumer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class BaseLicenseCheckerServiceInitListenerTest {
    private static final String PRODUCT_NAME = "vaadin-test-commercial-addon";
    private static final String PRODUCT_VERSION = "1.2.3";
    BaseLicenseCheckerServiceInitListener listener = new BaseLicenseCheckerServiceInitListener("vaadin-test-commercial-addon", "1.2.3"){};
    MockDeploymentConfiguration config = new MockDeploymentConfiguration();
    VaadinService service = new MockVaadinServletService((DeploymentConfiguration)this.config, false);
    ServiceInitEvent event = new ServiceInitEvent(this.service);

    @Test
    public void serviceInit_productionMode_licenseNotChecked() {
        this.config.setProductionMode(true);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            this.listener.serviceInit(this.event);
            licenseChecker.verifyNoInteractions();
        }
    }

    @Test
    public void serviceInit_devToolsDisabled_validLicense_noAction() {
        this.config.setProductionMode(false);
        this.config.setDevToolsEnabled(false);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            this.listener.serviceInit(this.event);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))));
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)), (int)ArgumentMatchers.anyInt(), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class))), Mockito.never());
        }
    }

    @Test
    public void serviceInit_devToolsDisabled_missingOrInvalid_throws() {
        this.config.setProductionMode(false);
        this.config.setDevToolsEnabled(false);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            LicenseException checkerException = new LicenseException("Invalid or missing license");
            licenseChecker.when(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)))).thenThrow(new Throwable[]{checkerException});
            LicenseException exception = (LicenseException)Assert.assertThrows(LicenseException.class, () -> this.listener.serviceInit(this.event));
            Assert.assertSame((Object)checkerException, (Object)exception);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)), (int)ArgumentMatchers.anyInt(), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class))), Mockito.never());
        }
    }

    @Test
    public void serviceInit_devToolsEnabled_missingLicense_delegateHandlingToDevTools() {
        this.config.setProductionMode(false);
        this.config.setDevToolsEnabled(true);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            licenseChecker.when(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)), (int)ArgumentMatchers.eq((int)0), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)))).then(i -> {
                ((Consumer)i.getArgument(3)).accept("URL");
                return null;
            });
            this.listener.serviceInit(this.event);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))), Mockito.never());
            List indexHtmlRequestListeners = this.event.getAddedIndexHtmlRequestListeners().toList();
            Assert.assertEquals((String)"Expected index html request listener to be installed, but was not", (long)1L, (long)indexHtmlRequestListeners.size());
            Document document = Jsoup.parse((String)"<html><head></head><body></body></html>");
            IndexHtmlResponse indexHtmlResponse = new IndexHtmlResponse((VaadinRequest)Mockito.mock(VaadinRequest.class), (VaadinResponse)Mockito.mock(VaadinResponse.class), document);
            ((IndexHtmlRequestListener)indexHtmlRequestListeners.get(0)).modifyIndexHtmlResponse(indexHtmlResponse);
            String headHTML = document.head().html();
            Assert.assertTrue((boolean)headHTML.contains("window.Vaadin.devTools.createdCvdlElements.push(product);"));
            Assert.assertTrue((boolean)headHTML.contains("registerProduct('%s','%s');".formatted(PRODUCT_NAME, PRODUCT_VERSION)));
        }
    }

    @Test
    public void serviceInit_devToolsEnabled_missingLicense_multipleListenersCollectedIntoSingleScript() {
        this.config.setProductionMode(false);
        this.config.setDevToolsEnabled(true);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            licenseChecker.when(() -> LicenseChecker.checkLicense((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)), (int)ArgumentMatchers.eq((int)0), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)))).then(i -> {
                ((Consumer)i.getArgument(3)).accept("URL");
                return null;
            });
            this.listener.serviceInit(this.event);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))), Mockito.never());
            new BaseLicenseCheckerServiceInitListener("productB", "1.0.0"){}.serviceInit(this.event);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)"productB")), (String)((String)ArgumentMatchers.eq((Object)"1.0.0")), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))), Mockito.never());
            new BaseLicenseCheckerServiceInitListener("productC", "2.4.6"){}.serviceInit(this.event);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)"productC")), (String)((String)ArgumentMatchers.eq((Object)"2.4.6")), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))), Mockito.never());
            List indexHtmlRequestListeners = this.event.getAddedIndexHtmlRequestListeners().toList();
            Assert.assertEquals((String)"Expected a single index html request listener to be installed", (long)1L, (long)indexHtmlRequestListeners.size());
            Document document = Jsoup.parse((String)"<html><head></head><body></body></html>");
            IndexHtmlResponse indexHtmlResponse = new IndexHtmlResponse((VaadinRequest)Mockito.mock(VaadinRequest.class), (VaadinResponse)Mockito.mock(VaadinResponse.class), document);
            ((IndexHtmlRequestListener)indexHtmlRequestListeners.get(0)).modifyIndexHtmlResponse(indexHtmlResponse);
            String headHTML = document.head().html();
            Assert.assertTrue((boolean)headHTML.contains("window.Vaadin.devTools.createdCvdlElements.push(product);"));
            Assert.assertTrue((boolean)headHTML.contains("registerProduct('%s','%s');".formatted(PRODUCT_NAME, PRODUCT_VERSION)));
            Assert.assertTrue((boolean)headHTML.contains("registerProduct('%s','%s');".formatted("productB", "1.0.0")));
            Assert.assertTrue((boolean)headHTML.contains("registerProduct('%s','%s');".formatted("productC", "2.4.6")));
        }
    }

    @Test
    public void serviceInit_devToolsEnabled_invalidLicense_throws() {
        this.config.setProductionMode(false);
        this.config.setDevToolsEnabled(true);
        try (MockedStatic licenseChecker = Mockito.mockStatic(LicenseChecker.class);){
            LicenseException checkerException = new LicenseException("Invalid or missing license");
            licenseChecker.when(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)), (int)ArgumentMatchers.eq((int)0), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)))).thenThrow(new Throwable[]{checkerException});
            LicenseException exception = (LicenseException)Assert.assertThrows(LicenseException.class, () -> this.listener.serviceInit(this.event));
            Assert.assertSame((Object)checkerException, (Object)exception);
            licenseChecker.verify(() -> LicenseChecker.checkLicense((String)((String)ArgumentMatchers.eq((Object)PRODUCT_NAME)), (String)((String)ArgumentMatchers.eq((Object)PRODUCT_VERSION)), (Capabilities)((Capabilities)ArgumentMatchers.any(Capabilities.class)), (BuildType)((BuildType)ArgumentMatchers.isNull(BuildType.class))), Mockito.never());
        }
    }
}

