/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EventUtilTest {
    private UI ui;

    @Before
    public void setUp() {
        final VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.ui = new UI(){

            public VaadinSession getSession() {
                return session;
            }
        };
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        DefaultInstantiator instantiator = new DefaultInstantiator(service);
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)instantiator);
        UI.setCurrent((UI)this.ui);
    }

    @After
    public void tearDown() {
        UI.setCurrent(null);
    }

    @Test
    public void collectBeforeNavigationObserversFromUI() throws Exception {
        UI ui = UI.getCurrent();
        Element node = ui.getElement();
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        Component.from((Element)nested, LeaveObserver.class);
        List beforeNavigationObservers = EventUtil.collectBeforeLeaveObservers((UI)ui);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectBeforeNavigationObserversFromUI_elementHasVirtualChildren() throws Exception {
        UI ui = UI.getCurrent();
        Element node = ui.getElement();
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendVirtualChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        node.getStateProvider().appendVirtualChild(node.getNode(), new Element("attached-by-id"), "@id", "id");
        Component.from((Element)nested, LeaveObserver.class);
        List beforeNavigationObservers = EventUtil.collectBeforeLeaveObservers((UI)ui);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectBeforeNavigationObserversFromChains() throws Exception {
        Foo foo = new Foo();
        EnterObserver toBeDetached = new EnterObserver();
        foo.getElement().appendChild(new Element[]{new EnterObserver().getElement(), toBeDetached.getElement()});
        Bar bar = new Bar();
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new EnterObserver().getElement()});
        bar.getElement().appendChild(new Element[]{new Foo().getElement(), nested});
        EnterObserver toBeAttached = new EnterObserver();
        List<Component> oldChain = Arrays.asList(new Component[]{foo, toBeDetached});
        List<Component> newChain = Arrays.asList(new Component[]{foo, toBeAttached});
        List beforeNavigationObservers = EventUtil.collectBeforeEnterObservers(oldChain, newChain);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)2L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectAfterNavigationObservers() {
        UI ui = UI.getCurrent();
        Element menu = new Element("menu");
        menu.appendChild(new Element[]{new AfterObserver().getElement()});
        Element node = ui.getElement();
        node.appendChild(new Element[]{new Element("main"), menu});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        Component.from((Element)nested, AfterObserver.class);
        List beforeNavigationObservers = EventUtil.collectAfterNavigationObservers((UI)ui);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)2L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void inspectChildrenHierarchy() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        ArrayList elements = new ArrayList();
        EventUtil.inspectHierarchy((Element)node, elements, element -> true);
        Assert.assertEquals((String)"Missing elements from list.", (long)6L, (long)elements.size());
    }

    @Test
    public void inspectChildrenHierarchy_selective() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        ArrayList elements = new ArrayList();
        EventUtil.inspectHierarchy((Element)node, elements, element -> !nested.equals(element));
        Assert.assertEquals((String)"Missing elements from list.", (long)3L, (long)elements.size());
    }

    @Test
    public void inspectMixedChildrenHierarchy() throws Exception {
        Element node = new Element("root");
        node.appendVirtualChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendVirtualChild(new Element[]{new Element("nested-virtual-child"), new Element("nested-virtual-child-2")});
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        nested.getStateProvider().appendVirtualChild(nested.getNode(), new Element("attached-by-id"), "@id", "id");
        nested.getStateProvider().appendVirtualChild(nested.getNode(), new Element("attached-by-id"), "subTemplate", "");
        node.appendChild(new Element[]{nested});
        ArrayList elements = new ArrayList();
        EventUtil.inspectHierarchy((Element)node, elements, element -> true);
        Assert.assertEquals((String)"Missing elements from list.", (long)10L, (long)elements.size());
    }

    @Test
    public void getImplementingComponents() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        Component.from((Element)nested, EnterObserver.class);
        ArrayList elements = new ArrayList();
        EventUtil.inspectHierarchy((Element)node, elements, element -> true);
        List listenerComponents = EventUtil.getImplementingComponents(elements.stream(), BeforeEnterObserver.class).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)listenerComponents.size());
    }

    @Test
    public void getImplementingComponents_elementHasVirtualChildren() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.getStateProvider().appendVirtualChild(node.getNode(), nested, "subTemplate", "");
        Component.from((Element)nested, EnterObserver.class);
        ArrayList elements = new ArrayList();
        EventUtil.inspectHierarchy((Element)node, elements, element -> true);
        List listenerComponents = EventUtil.getImplementingComponents(elements.stream(), BeforeEnterObserver.class).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)listenerComponents.size());
    }

    @Test
    public void collectLocaleChangeObserverFromElement() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        Element nested = new Element("nested-locale");
        nested.appendChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendChild(new Element[]{nested});
        Component.from((Element)nested, Locale.class);
        List beforeNavigationObservers = EventUtil.collectLocaleChangeObservers((Element)node);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectLocaleChangeObserverFromElement_elementHasVirtualChildren() throws Exception {
        Element node = new Element("root");
        node.appendChild(new Element[]{new Element("main"), new Element("menu")});
        node.appendVirtualChild(new Element[]{new Element("main-virtual"), new Element("menu-virtual")});
        Element nested = new Element("nested-locale");
        nested.appendVirtualChild(new Element[]{new Element("nested-child"), new Element("nested-child-2")});
        node.appendVirtualChild(new Element[]{nested});
        Component.from((Element)nested, Locale.class);
        List beforeNavigationObservers = EventUtil.collectLocaleChangeObservers((Element)node);
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)1L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectLocaleChangeObserverFromComponentList() throws Exception {
        Foo foo = new Foo();
        foo.getElement().appendChild(new Element[]{new Locale().getElement()});
        Bar bar = new Bar();
        Element nested = new Element("nested-locale");
        nested.appendChild(new Element[]{new Element("nested-child"), new Locale().getElement()});
        bar.getElement().appendChild(new Element[]{new Foo().getElement(), nested});
        List beforeNavigationObservers = EventUtil.collectLocaleChangeObservers(Arrays.asList(new HasElement[]{foo, bar}));
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)2L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void collectLocaleChangeObserverFromComponentList_elementHasVirtualChildren() throws Exception {
        Foo foo = new Foo();
        foo.getElement().appendChild(new Element[]{new Locale().getElement()});
        Bar bar = new Bar();
        Element nested = new Element("nested-locale");
        nested.appendChild(new Element[]{new Element("nested-child"), new Locale().getElement()});
        bar.getElement().appendChild(new Element[]{new Foo().getElement(), nested});
        List beforeNavigationObservers = EventUtil.collectLocaleChangeObservers(Arrays.asList(new HasElement[]{foo, bar}));
        Assert.assertEquals((String)"Wrong amount of listener instances found", (long)2L, (long)beforeNavigationObservers.size());
    }

    @Test
    public void getImplementingComponents_hasComposite_originalComponentIsReturned() {
        CompositeWrapper wrapper = new CompositeWrapper();
        List components = EventUtil.getImplementingComponents(Stream.of(wrapper.getElement()), BeforeEnterObserver.class).distinct().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals(EnterObserver.class, (Object)((BeforeEnterObserver)components.get(0)).getClass());
    }

    @Tag(value="nested")
    public static class LeaveObserver
    extends Component
    implements BeforeLeaveObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
        }
    }

    @Tag(value="div")
    public static class Foo
    extends Component {
    }

    @Tag(value="nested")
    public static class EnterObserver
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
        }
    }

    @Tag(value="div")
    public static class Bar
    extends Component {
    }

    @Tag(value="nested")
    public static class AfterObserver
    extends Component
    implements AfterNavigationObserver {
        public void afterNavigation(AfterNavigationEvent event) {
        }
    }

    @Tag(value="nested-locale")
    public static class Locale
    extends Component
    implements LocaleChangeObserver {
        public void localeChange(LocaleChangeEvent event) {
        }
    }

    public static class CompositeWrapper
    extends Composite<EnterObserver> {
    }
}

