/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.di.OneTimeInitializerPredicate;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.VaadinApplicationInitializationBootstrap;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.AppShellPredicate;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory;
import com.vaadin.flow.server.startup.testdata.AnotherTestInstantiatorFactory;
import com.vaadin.flow.server.startup.testdata.OneMoreTestInstantiatorFactory;
import com.vaadin.flow.server.startup.testdata.TestInstantiatorFactory;
import com.vaadin.flow.server.startup.testdata.TestResourceProvider;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ObjectNode;

public class LookupInitializerTest {
    private LookupInitializer initializer = new LookupInitializer();

    @Test(expected=IllegalStateException.class)
    public void createLookup_instantiatorsAreProvidedAsAService_lookupThrows() throws ServletException {
        Lookup lookup = this.initializer.createLookup(null, new HashMap());
        lookup.lookup(InstantiatorFactory.class);
    }

    @Test(expected=IllegalStateException.class)
    public void createLookup_instantiatorsAreProvidedAsScannedClasses_multipleInstantiatorInstances_lookupThrows() throws ServletException {
        Lookup lookup = this.initializer.createLookup(null, Collections.singletonMap(InstantiatorFactory.class, Arrays.asList(TestInstantiatorFactory.class, AnotherTestInstantiatorFactory.class)));
        lookup.lookup(InstantiatorFactory.class);
    }

    @Test
    public void initialize_noResourcePorvider_defaultResourceProviderIsCreated() throws ServletException, IOException {
        AtomicReference capture = new AtomicReference();
        this.initializer.initialize(null, new HashMap(), capture::set);
        Lookup lookup = (Lookup)capture.get();
        this.assertResourceProvider((ResourceProvider)lookup.lookup(ResourceProvider.class));
    }

    @Test
    public void initialize_noStaticFileHandlerFactory_defaultStaticFileHandlerFactoryCreated() throws ServletException {
        AtomicReference capture = new AtomicReference();
        this.initializer.initialize(null, new HashMap(), capture::set);
        Lookup lookup = (Lookup)capture.get();
        StaticFileHandlerFactory factory = (StaticFileHandlerFactory)lookup.lookup(StaticFileHandlerFactory.class);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)configuration);
        ClassLoader loader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)service.getClassLoader()).thenReturn((Object)loader);
        StaticFileHandler handler = factory.createHandler(service);
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals(StaticFileServer.class, (Object)handler.getClass());
    }

    @Test
    public void initialize_StaticFileHandlerFactoryIdDelegatedToEnsureService() throws ServletException {
        final Map mock = (Map)Mockito.mock(Map.class);
        final AtomicBoolean factoryIsPassed = new AtomicBoolean();
        this.initializer = new LookupInitializer(this){

            protected <T> void ensureService(Map<Class<?>, Collection<Class<?>>> services, Class<T> serviceType, Class<? extends T> serviceImpl) {
                Assert.assertSame((Object)mock, services);
                if (StaticFileHandlerFactory.class.equals(serviceType)) {
                    factoryIsPassed.set(true);
                }
            }
        };
        AtomicReference capture = new AtomicReference();
        this.initializer.initialize(null, mock, capture::set);
        Assert.assertTrue((boolean)factoryIsPassed.get());
    }

    @Test
    public void initialize_hasOneTimeInitializerPredicate_predicateReturnsTrue() throws ServletException, IOException {
        AtomicReference capture = new AtomicReference();
        this.initializer.initialize(null, new HashMap(), capture::set);
        Lookup lookup = (Lookup)capture.get();
        OneTimeInitializerPredicate predicate = (OneTimeInitializerPredicate)lookup.lookup(OneTimeInitializerPredicate.class);
        Assert.assertNotNull((Object)predicate);
        Assert.assertTrue((boolean)predicate.runOnce());
    }

    @Test
    public void ensureResourceProvider_defaultImplClassIsStoredAsAService() {
        HashMap map = new HashMap();
        this.initializer.ensureService(map, ResourceProvider.class, LookupInitializer.ResourceProviderImpl.class);
        Collection collection = (Collection)map.get(ResourceProvider.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Class clazz = (Class)collection.iterator().next();
        Assert.assertEquals(LookupInitializer.ResourceProviderImpl.class, (Object)clazz);
    }

    @Test
    public void ensureResourceProvider_defaultImplClassIsProvided_defaultImplIsStoredAsAService() {
        HashMap<Class<ResourceProvider>, List<Class<LookupInitializer.ResourceProviderImpl>>> map = new HashMap<Class<ResourceProvider>, List<Class<LookupInitializer.ResourceProviderImpl>>>();
        map.put(ResourceProvider.class, Collections.singletonList(LookupInitializer.ResourceProviderImpl.class));
        this.initializer.ensureService(map, ResourceProvider.class, LookupInitializer.ResourceProviderImpl.class);
        Collection collection = (Collection)map.get(ResourceProvider.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Class clazz = (Class)collection.iterator().next();
        Assert.assertEquals(LookupInitializer.ResourceProviderImpl.class, (Object)clazz);
    }

    @Test
    public void ensureRoutePathResolver_defaultImplClassIsStoredAsAService() {
        HashMap map = new HashMap();
        this.initializer.ensureService(map, RoutePathProvider.class, DefaultRoutePathProvider.class);
        Collection collection = (Collection)map.get(RoutePathProvider.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Class clazz = (Class)collection.iterator().next();
        Assert.assertEquals(DefaultRoutePathProvider.class, (Object)clazz);
    }

    @Test
    public void ensureRoutePathResolver_defaultImplClassIsProvided_defaultImplIsStoredAsAService() {
        HashMap<Class<RoutePathProvider>, List<Class<DefaultRoutePathProvider>>> map = new HashMap<Class<RoutePathProvider>, List<Class<DefaultRoutePathProvider>>>();
        map.put(RoutePathProvider.class, Collections.singletonList(DefaultRoutePathProvider.class));
        this.initializer.ensureService(map, RoutePathProvider.class, DefaultRoutePathProvider.class);
        Collection collection = (Collection)map.get(RoutePathProvider.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Class clazz = (Class)collection.iterator().next();
        Assert.assertEquals(DefaultRoutePathProvider.class, (Object)clazz);
    }

    @Test
    public void ensureApplicationConfigurationFactories_defaultFactoryOnly_defaultFactoryIsReturned() throws ServletException {
        HashMap<Class<ApplicationConfigurationFactory>, List<Class<DefaultApplicationConfigurationFactory>>> map = new HashMap<Class<ApplicationConfigurationFactory>, List<Class<DefaultApplicationConfigurationFactory>>>();
        map.put(ApplicationConfigurationFactory.class, Collections.singletonList(DefaultApplicationConfigurationFactory.class));
        this.initializer.ensureService(map, ApplicationConfigurationFactory.class, DefaultApplicationConfigurationFactory.class);
        Collection factories = (Collection)map.get(ApplicationConfigurationFactory.class);
        Assert.assertEquals((long)1L, (long)factories.size());
        Assert.assertEquals(DefaultApplicationConfigurationFactory.class, factories.iterator().next());
    }

    @Test
    public void ensureApplicationConfigurationFactories_noAvailableFactory_defaultFactoryIsReturned() throws ServletException {
        HashMap map = new HashMap();
        map.put(ApplicationConfigurationFactory.class, Collections.emptyList());
        this.initializer.ensureService(map, ApplicationConfigurationFactory.class, DefaultApplicationConfigurationFactory.class);
        Collection collection = (Collection)map.get(ApplicationConfigurationFactory.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Class clazz = (Class)collection.iterator().next();
        Assert.assertEquals(DefaultApplicationConfigurationFactory.class, (Object)clazz);
    }

    @Test
    public void createLookup_createLookupIsInvoked_lookupcontainsProvidedServices() throws ServletException {
        HashMap<Class, List<Class<Object>>> map = new HashMap<Class, List<Class<Object>>>();
        map.put(List.class, Arrays.asList(ArrayList.class, LinkedList.class));
        map.put(ResourceProvider.class, Collections.singletonList(TestResourceProvider.class));
        Lookup lookup = this.initializer.createLookup(null, map);
        ResourceProvider resourceProvider = (ResourceProvider)lookup.lookup(ResourceProvider.class);
        Assert.assertEquals(TestResourceProvider.class, (Object)resourceProvider.getClass());
        Collection lists = lookup.lookupAll(List.class);
        Assert.assertEquals((long)2L, (long)lists.size());
        Iterator iterator = lists.iterator();
        List next = (List)iterator.next();
        Assert.assertEquals(ArrayList.class, next.getClass());
        next = (List)iterator.next();
        Assert.assertEquals(LinkedList.class, next.getClass());
    }

    @Test
    public void createLookup_instantiatorsAreProvidedAsScannedClassAndAsAService_lookupReturnsTheProviderInstance_lookupAllReturnsAllInstances() throws ServletException {
        HashMap<Class<InstantiatorFactory>, Set<Class<TestInstantiatorFactory>>> map = new HashMap<Class<InstantiatorFactory>, Set<Class<TestInstantiatorFactory>>>();
        map.put(InstantiatorFactory.class, Collections.singleton(TestInstantiatorFactory.class));
        Lookup lookup = this.initializer.createLookup(null, map);
        InstantiatorFactory factory = (InstantiatorFactory)lookup.lookup(InstantiatorFactory.class);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(TestInstantiatorFactory.class, (Object)factory.getClass());
        Collection factories = lookup.lookupAll(InstantiatorFactory.class);
        Assert.assertEquals((long)3L, (long)factories.size());
        Iterator iterator = factories.iterator();
        Assert.assertEquals(TestInstantiatorFactory.class, (Object)((InstantiatorFactory)iterator.next()).getClass());
        HashSet<Class> factoryClasses = new HashSet<Class>();
        factoryClasses.add(((InstantiatorFactory)iterator.next()).getClass());
        factoryClasses.add(((InstantiatorFactory)iterator.next()).getClass());
        Assert.assertTrue((boolean)factoryClasses.contains(AnotherTestInstantiatorFactory.class));
        Assert.assertTrue((boolean)factoryClasses.contains(OneMoreTestInstantiatorFactory.class));
    }

    @Test
    public void resourceProviderImpl_returnsClassPathResources() throws IOException {
        this.assertResourceProvider((ResourceProvider)new LookupInitializer.ResourceProviderImpl());
    }

    @Test
    public void initialize_callEnsureMethodsAndBootstrap() throws ServletException {
        LookupInitializer initializer = (LookupInitializer)Mockito.spy(LookupInitializer.class);
        Map services = (Map)Mockito.mock(HashMap.class);
        VaadinApplicationInitializationBootstrap bootstrap = (VaadinApplicationInitializationBootstrap)Mockito.mock(VaadinApplicationInitializationBootstrap.class);
        initializer.initialize(null, services, bootstrap);
        ((LookupInitializer)Mockito.verify((Object)initializer)).ensureService(services, ResourceProvider.class, LookupInitializer.ResourceProviderImpl.class);
        ((LookupInitializer)Mockito.verify((Object)initializer)).ensureService(services, ApplicationConfigurationFactory.class, DefaultApplicationConfigurationFactory.class);
        ((LookupInitializer)Mockito.verify((Object)initializer)).ensureService(services, AppShellPredicate.class, LookupInitializer.AppShellPredicateImpl.class);
        ((VaadinApplicationInitializationBootstrap)Mockito.verify((Object)bootstrap)).bootstrap((Lookup)Mockito.any());
    }

    @Test
    public void ensureService_noServiceProvided_defaultIsUsed() {
        HashMap services = new HashMap();
        this.initializer.ensureService(services, List.class, ArrayList.class);
        Assert.assertEquals((long)1L, (long)services.size());
        Collection collection = (Collection)services.get(List.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertEquals(ArrayList.class, collection.iterator().next());
    }

    @Test
    public void ensureService_defaultServiceProvided_defaultIsUsed() {
        HashMap<Class<List>, Set<Class<ArrayList>>> services = new HashMap<Class<List>, Set<Class<ArrayList>>>();
        services.put(List.class, Collections.singleton(ArrayList.class));
        this.initializer.ensureService(services, List.class, ArrayList.class);
        Assert.assertEquals((long)1L, (long)services.size());
        Collection collection = (Collection)services.get(List.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertEquals(ArrayList.class, collection.iterator().next());
    }

    @Test(expected=IllegalStateException.class)
    public void ensureService_severalServicesProvided_throws() {
        HashMap<Class<List>, List<Class>> services = new HashMap<Class<List>, List<Class>>();
        services.put(List.class, Arrays.asList(Vector.class, LinkedList.class));
        this.initializer.ensureService(services, List.class, ArrayList.class);
    }

    private void assertResourceProvider(ResourceProvider resourceProvider) throws IOException {
        Assert.assertEquals(LookupInitializer.ResourceProviderImpl.class, (Object)resourceProvider.getClass());
        URL applicationResource = resourceProvider.getApplicationResource("resource-provider/some-resource.json");
        Assert.assertNotNull((Object)applicationResource);
        List resources = resourceProvider.getApplicationResources("resource-provider/some-resource.json");
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertNotNull(resources.get(0));
        URL nonExistent = resourceProvider.getApplicationResource("resource-provider/non-existent.txt");
        Assert.assertNull((Object)nonExistent);
        URL clientResource = resourceProvider.getClientResource("resource-provider/some-resource.json");
        Assert.assertNotNull((Object)clientResource);
        InputStream stream = resourceProvider.getClientResourceAsStream("resource-provider/some-resource.json");
        String content = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        ObjectNode object = JacksonUtils.readTree((String)content);
        Assert.assertTrue((boolean)object.get("client-resource").booleanValue());
    }
}

