/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ExtendedClientDetailsTest {
    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    @Test
    public void initializeWithClientValues_gettersReturnExpectedValues() {
        ExtendedClientDetails details = new ExtendBuilder(this).buildDetails();
        Assert.assertEquals((long)2560L, (long)details.getScreenWidth());
        Assert.assertEquals((long)1450L, (long)details.getScreenHeight());
        Assert.assertEquals((long)2400L, (long)details.getWindowInnerWidth());
        Assert.assertEquals((long)1400L, (long)details.getWindowInnerHeight());
        Assert.assertEquals((long)1600L, (long)details.getBodyClientWidth());
        Assert.assertEquals((long)1360L, (long)details.getBodyClientHeight());
        Assert.assertEquals((long)16200000L, (long)details.getTimezoneOffset());
        Assert.assertEquals((Object)"Asia/Tehran", (Object)details.getTimeZoneId());
        Assert.assertEquals((long)12600000L, (long)details.getRawTimezoneOffset());
        Assert.assertEquals((long)3600000L, (long)details.getDSTSavings());
        Assert.assertEquals((Object)true, (Object)details.isDSTInEffect());
        Assert.assertEquals((Object)false, (Object)details.isTouchDevice());
        Assert.assertEquals((double)2.0, (double)details.getDevicePixelRatio(), (double)0.0);
        Assert.assertEquals((Object)"ROOT-1234567-0.1234567", (Object)details.getWindowName());
        Assert.assertFalse((boolean)details.isIPad());
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)details.getColorScheme());
        Assert.assertEquals((Object)"aura", (Object)details.getThemeName());
    }

    @Test
    public void differentNavigatorPlatformDetails_isIPadReturnsExpectedValue() {
        ExtendBuilder detailsBuilder = new ExtendBuilder(this);
        ExtendedClientDetails details = detailsBuilder.buildDetails();
        Assert.assertFalse((String)"Linux is not an iPad", (boolean)details.isIPad());
        detailsBuilder.setNavigatorPlatform("iPad");
        details = detailsBuilder.buildDetails();
        Assert.assertTrue((String)"'iPad' is an iPad", (boolean)details.isIPad());
        detailsBuilder.setNavigatorPlatform("MacIntel");
        details = detailsBuilder.buildDetails();
        Assert.assertFalse((String)"MacIntel on non touch device is not an iPad", (boolean)details.isIPad());
        detailsBuilder.setTouchDevice("true");
        details = detailsBuilder.buildDetails();
        Assert.assertTrue((String)"MacIntel on touch device is an iPad", (boolean)details.isIPad());
    }

    @Test
    public void differentNavigatorPlatformDetails_Ipod_isIOSReturnsExpectedValue() {
        ExtendedClientDetails details = new ExtendBuilder(this).setNavigatorPlatform("iPod ..").buildDetails();
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        CurrentInstance.setCurrent((VaadinSession)session);
        WebBrowser browser = (WebBrowser)Mockito.mock(WebBrowser.class);
        Mockito.when((Object)session.getBrowser()).thenReturn((Object)browser);
        Mockito.when((Object)browser.isIPhone()).thenReturn((Object)false);
        Assert.assertTrue((boolean)details.isIOS());
        CurrentInstance.clearAll();
    }

    @Test
    public void isIOS_isIPad_returnsTrue() {
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        ((ExtendedClientDetails)Mockito.doCallRealMethod().when((Object)details)).isIOS();
        Mockito.when((Object)details.isIPad()).thenReturn((Object)true);
        Assert.assertTrue((boolean)details.isIOS());
    }

    @Test
    public void isIOS_notIPadIsIPhone_returnsTrue() {
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        ((ExtendedClientDetails)Mockito.doCallRealMethod().when((Object)details)).isIOS();
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        WebBrowser browser = (WebBrowser)Mockito.mock(WebBrowser.class);
        Mockito.when((Object)session.getBrowser()).thenReturn((Object)browser);
        Mockito.when((Object)browser.isIPhone()).thenReturn((Object)true);
        Assert.assertTrue((boolean)details.isIOS());
    }

    @Test
    public void isIOS_notIPad_notIsIPhone_returnsFalse() {
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        ((ExtendedClientDetails)Mockito.doCallRealMethod().when((Object)details)).isIOS();
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        WebBrowser browser = (WebBrowser)Mockito.mock(WebBrowser.class);
        Mockito.when((Object)session.getBrowser()).thenReturn((Object)browser);
        Mockito.when((Object)browser.isIPhone()).thenReturn((Object)false);
        Assert.assertFalse((boolean)details.isIOS());
    }

    private class ExtendBuilder {
        private String screenWidth = "2560";
        private String screenHeight = "1450";
        private String windowInnerWidth = "2400";
        private String windowInnerHeight = "1400";
        private String bodyClientWidth = "1600";
        private String bodyClientHeight = "1360";
        private String timezoneOffset = "-270";
        private String rawTimezoneOffset = "-210";
        private String dstSavings = "60";
        private String dstInEffect = "true";
        private String timeZoneId = "Asia/Tehran";
        private String clientServerTimeDelta = "1555000000000";
        private String touchDevice = "false";
        private String devicePixelRatio = "2.0";
        private String windowName = "ROOT-1234567-0.1234567";
        private String navigatorPlatform = "Linux i686";
        private String colorScheme = "light";
        private String themeName = "aura";

        private ExtendBuilder(ExtendedClientDetailsTest extendedClientDetailsTest) {
        }

        public ExtendedClientDetails buildDetails() {
            return new ExtendedClientDetails(null, this.screenWidth, this.screenHeight, this.windowInnerWidth, this.windowInnerHeight, this.bodyClientWidth, this.bodyClientHeight, this.timezoneOffset, this.rawTimezoneOffset, this.dstSavings, this.dstInEffect, this.timeZoneId, this.clientServerTimeDelta, this.touchDevice, this.devicePixelRatio, this.windowName, this.navigatorPlatform, this.colorScheme, this.themeName);
        }

        public ExtendBuilder setScreenWidth(String screenWidth) {
            this.screenWidth = screenWidth;
            return this;
        }

        public ExtendBuilder setScreenHeight(String screenHeight) {
            this.screenHeight = screenHeight;
            return this;
        }

        public ExtendBuilder setWindowInnerWidth(String windowInnerWidth) {
            this.windowInnerWidth = windowInnerWidth;
            return this;
        }

        public ExtendBuilder setWindowInnerHeight(String windowInnerHeight) {
            this.windowInnerHeight = windowInnerHeight;
            return this;
        }

        public ExtendBuilder setBodyClientWidth(String bodyClientWidth) {
            this.bodyClientWidth = bodyClientWidth;
            return this;
        }

        public ExtendBuilder setBodyClientHeight(String bodyClientHeight) {
            this.bodyClientHeight = bodyClientHeight;
            return this;
        }

        public ExtendBuilder setTimezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public ExtendBuilder setRawTimezoneOffset(String rawTimezoneOffset) {
            this.rawTimezoneOffset = rawTimezoneOffset;
            return this;
        }

        public ExtendBuilder setDstSavings(String dstSavings) {
            this.dstSavings = dstSavings;
            return this;
        }

        public ExtendBuilder setDstInEffect(String dstInEffect) {
            this.dstInEffect = dstInEffect;
            return this;
        }

        public ExtendBuilder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public ExtendBuilder setClientServerTimeDelta(String clientServerTimeDelta) {
            this.clientServerTimeDelta = clientServerTimeDelta;
            return this;
        }

        public ExtendBuilder setTouchDevice(String touchDevice) {
            this.touchDevice = touchDevice;
            return this;
        }

        public ExtendBuilder setDevicePixelRatio(String devicePixelRatio) {
            this.devicePixelRatio = devicePixelRatio;
            return this;
        }

        public ExtendBuilder setWindowName(String windowName) {
            this.windowName = windowName;
            return this;
        }

        public ExtendBuilder setNavigatorPlatform(String navigatorPlatform) {
            this.navigatorPlatform = navigatorPlatform;
            return this;
        }
    }
}

