/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Text;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TextTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void elementAttached() {
        new Text("Foo").getParent();
    }

    @Test
    public void nullText_transformsToEmptyAndDoesNotThrowException() {
        Assert.assertEquals((Object)"", (Object)new Text(null).getText());
    }

    @Test
    public void emptyText() {
        Assert.assertEquals((Object)"", (Object)new Text("").getText());
    }

    @Test
    public void setText_emptyTextCanBeChangedLater() {
        Text text = new Text(null);
        text.setText("Non Empty");
        Assert.assertEquals((Object)"Non Empty", (Object)text.getText());
    }

    @Test
    public void setText_nullIsChangedToEmptyAndDoesNotThrowException() {
        Text text = new Text("Default");
        text.setText(null);
        Assert.assertEquals((Object)"", (Object)text.getText());
    }

    @Test
    public void setGetText() {
        Assert.assertEquals((Object)"Simple", (Object)new Text("Simple").getText());
        Assert.assertEquals((Object)"\u00e5\u00e4\u00f6 \u20ac#%\u00b0#", (Object)new Text("\u00e5\u00e4\u00f6 \u20ac#%\u00b0#").getText());
    }

    @Test
    public void setId_throwsWithMeaningfulMessage() {
        this.assertExceptionOnSetProperty("id");
        new Text("").setId("foo");
    }

    @Test
    public void setFooProperty_throwsWithMeaningfulMessage() {
        this.assertExceptionOnSetProperty("foo");
        new Text("").set(PropertyDescriptors.propertyWithDefault((String)"foo", (Boolean)true), (Object)false);
    }

    @Test
    public void setVisibility_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot change Text component visibility"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").setVisible(false);
    }

    @Test
    public void addClassName_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot add a class to the Text"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").addClassName("foo");
    }

    @Test
    public void addClassNames_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot add classes to the Text"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").addClassNames(new String[]{"foor", "bar"});
    }

    @Test
    public void removeClassName_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot remove a class from the Text"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").removeClassName("foo");
    }

    @Test
    public void removeClassNames_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot remove classes from the Text"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").removeClassNames(new String[]{"foo", "bar"});
    }

    @Test
    public void setClassName_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot set the Text component class"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").setClassName("foo");
    }

    @Test
    public void setClassName_withBooleanParameter_throwsWithMeaningfulMessage() {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Cannot set the Text component class"), (Matcher)CoreMatchers.containsString((String)"because it doesn't represent an HTML Element")));
        new Text("").setClassName("foo", true);
    }

    private void assertExceptionOnSetProperty(String property) {
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)("Cannot set '" + property + "' ")), (Matcher)CoreMatchers.containsString((String)"component because it doesn't represent an HTML Element")));
    }
}

