/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.Tag;
import org.junit.Assert;
import org.junit.Test;

public class HasAriaLabelTest {
    @Test
    public void withoutAriaLabelComponent_getAriaLabelReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        Assert.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void withNullAriaLabel_getAriaLabelReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        component.setAriaLabel(null);
        Assert.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void withEmptyAriaLabel_getAriaLabelReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("");
        Assert.assertEquals((Object)"", component.getAriaLabel().get());
    }

    @Test
    public void withAriaLabel_setAriaLabelToNullClearsAriaLabel() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("test AriaLabel");
        component.setAriaLabel(null);
        Assert.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void setAriaLabel() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("test AriaLabel");
        Assert.assertEquals((Object)"test AriaLabel", component.getAriaLabel().get());
    }

    @Test
    public void withoutAriaLabelledByComponent_getAriaLabelledByReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        Assert.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void withNullAriaLabelledBy_getAriaLabelledByReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy(null);
        Assert.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void withEmptyAriaLabelledBy_getAriaLabelledByReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("");
        Assert.assertEquals((Object)"", component.getAriaLabelledBy().get());
    }

    @Test
    public void withAriaLabelledBy_setAriaLabelledByToNullClearsAriaLabelledBy() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("test AriaLabelledBy");
        component.setAriaLabelledBy(null);
        Assert.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void setAriaLabelledBy() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("test AriaLabelledBy");
        Assert.assertEquals((Object)"test AriaLabelledBy", component.getAriaLabelledBy().get());
    }

    @Tag(value="main")
    private static class TestComponent
    extends Component
    implements HasAriaLabel {
        private TestComponent() {
        }
    }
}

