/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.server.communication.rpc.AttachTemplateChildRpcHandler;
import java.util.HashMap;
import java.util.function.Supplier;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class AttachTemplateChildRpcHandlerTest {
    @Test(expected=IllegalStateException.class)
    public void handleNode_attachById_elementNotFound() {
        this.doHandleNode_attach_elementNotFound(JacksonUtils.createNode((Object)"id"));
    }

    @Test(expected=IllegalStateException.class)
    public void handleNode_attachCustomElement_elementNotFound() {
        this.doHandleNode_attach_elementNotFound((JsonNode)JacksonUtils.nullNode());
    }

    @Test(expected=IllegalStateException.class)
    public void handleNode_attachByIdExistingRequest_throwReservedId() {
        this.doHandleNode_attach_throwReservedId(JacksonUtils.createNode((Object)2));
    }

    @Test(expected=IllegalStateException.class)
    public void handleNode_attachCustonElementCustomId_throwReservedId() {
        this.doHandleNode_attach_throwReservedId((JsonNode)JacksonUtils.nullNode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void handleNode_success_throwIllegalInvocation() {
        this.assertHandleNode(1, JacksonUtils.createNode((Object)"id"));
    }

    private void doHandleNode_attach_elementNotFound(JsonNode id) {
        this.assertHandleNode(-1, id);
    }

    private void doHandleNode_attach_throwReservedId(JsonNode id) {
        this.assertHandleNode(2, id);
    }

    private void assertHandleNode(int assignedId, JsonNode id) {
        AttachTemplateChildRpcHandler handler = new AttachTemplateChildRpcHandler();
        int requestedId = 1;
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("attachReqId", requestedId);
        object.put("attachAssignedId", assignedId);
        object.set("attachId", id);
        StateNode node = (StateNode)Mockito.mock(StateNode.class);
        StateNode parentNode = (StateNode)Mockito.mock(StateNode.class);
        StateTree tree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)node.getOwner()).thenReturn((Object)tree);
        Mockito.when((Object)node.getParent()).thenReturn((Object)parentNode);
        Mockito.when((Object)tree.getNodeById(requestedId)).thenReturn((Object)node);
        Mockito.when((Object)node.getChangeTracker((NodeFeature)Mockito.any(), (Supplier)Mockito.any())).thenReturn(new HashMap());
        ElementData data = new ElementData(node);
        data.setTag("foo");
        Mockito.when((Object)((ElementData)node.getFeature(ElementData.class))).thenReturn((Object)data);
        Mockito.when((Object)parentNode.getId()).thenReturn((Object)3);
        handler.handleNode(node, (JsonNode)object);
    }
}

