/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SignalBindingFeature
extends ServerSideFeature {
    public static final String ENABLED = "enabled";
    private Map<String, SignalBinding> values;

    public SignalBindingFeature(StateNode node) {
        super(node);
    }

    public void setBinding(String key, Registration registration, Signal<?> signal) {
        this.ensureValues();
        this.values.put(key, new SignalBinding(signal, registration));
    }

    public boolean hasBinding(String key) {
        if (this.values == null) {
            return false;
        }
        SignalBinding binding = this.values.get(key);
        return binding != null && binding.signal != null && binding.registration != null;
    }

    public void removeBinding(String key) {
        if (this.values == null) {
            return;
        }
        SignalBinding binding = this.values.get(key);
        if (binding != null && binding.registration != null) {
            binding.registration.remove();
        }
        this.values.remove(key);
    }

    private void ensureValues() {
        if (this.values == null) {
            this.values = new HashMap<String, SignalBinding>();
        }
    }

    private record SignalBinding(Signal<?> signal, Registration registration) implements Serializable
    {
    }
}

