/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class WebComponentExporterUtilsTest {
    @Test
    public void getFactories_notEligibleExportersAreFiltered_factoriesAreReturned() {
        Set factories = WebComponentExporterUtils.getFactories(new HashSet<Class>(Arrays.asList(GoodExporter.class, AbstractExporter.class, PackageLocalExporter.class, NoPublicCtorExporter.class, ExporterFactory.class)));
        Assert.assertEquals((long)2L, (long)factories.size());
        Iterator iterator = factories.iterator();
        WebComponentExporterFactory factory = (WebComponentExporterFactory)iterator.next();
        WebComponentExporterFactory another = (WebComponentExporterFactory)iterator.next();
        if (factory instanceof ExporterFactory) {
            this.assertFactories(factory, another);
        } else {
            this.assertFactories(another, factory);
        }
    }

    private void assertFactories(WebComponentExporterFactory factory, WebComponentExporterFactory anotherFactory) {
        Assert.assertTrue((boolean)(anotherFactory instanceof WebComponentExporterFactory.DefaultWebComponentExporterFactory));
        WebComponentExporter exporter = anotherFactory.create();
        MatcherAssert.assertThat((Object)exporter, (Matcher)CoreMatchers.instanceOf(GoodExporter.class));
        exporter = factory.create();
        MatcherAssert.assertThat((Object)exporter, (Matcher)CoreMatchers.instanceOf(NoDefaultCtorExporter.class));
    }

    public static class GoodExporter
    extends WebComponentExporter<Component> {
        public GoodExporter() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    public static abstract class AbstractExporter
    extends WebComponentExporter<Component> {
        public AbstractExporter() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    static abstract class PackageLocalExporter
    extends WebComponentExporter<Component> {
        public PackageLocalExporter() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    public static class NoPublicCtorExporter
    extends WebComponentExporter<Component> {
        NoPublicCtorExporter() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    public static class ExporterFactory
    implements WebComponentExporterFactory<Component> {
        public WebComponentExporter<Component> create() {
            return new NoDefaultCtorExporter("foo-bar");
        }
    }

    public static class NoDefaultCtorExporter
    extends WebComponentExporter<Component> {
        public NoDefaultCtorExporter(String tag) {
            super(tag);
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }
}

