/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.template.internal.DeprecatedPolymerPublishedEventHandler;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.VaadinApplicationInitializationBootstrap;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory;
import com.vaadin.flow.server.startup.DeferredServletContextInitializers;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import com.vaadin.flow.server.startup.testdata.TestResourceProvider;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;

public class LookupServletContainerInitializerTest {
    private LookupServletContainerInitializer initializer = new LookupServletContainerInitializer();

    @Test
    public void processLookupServletContainerInitializer_resourceProviderIsProvidedAsScannedClass_lookupReturnsTheProviderInstance() throws ServletException {
        Lookup lookup = this.mockLookup(TestResourceProvider.class);
        ResourceProvider provider = (ResourceProvider)lookup.lookup(ResourceProvider.class);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals(TestResourceProvider.class, (Object)provider.getClass());
        Collection allProviders = lookup.lookupAll(ResourceProvider.class);
        Assert.assertEquals((long)1L, (long)allProviders.size());
        Assert.assertEquals(TestResourceProvider.class, (Object)((ResourceProvider)allProviders.iterator().next()).getClass());
    }

    @Test
    public void processLookupServletContainerInitializer_polymerPublishedEventHandlerIsProvidedAsScannedClass_lookupReturnsTheProviderInstance() throws ServletException {
        Lookup lookup = this.mockLookup(TestPolymerPublishedEventHandler.class);
        DeprecatedPolymerPublishedEventHandler handler = (DeprecatedPolymerPublishedEventHandler)lookup.lookup(DeprecatedPolymerPublishedEventHandler.class);
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals(TestPolymerPublishedEventHandler.class, (Object)handler.getClass());
        Collection allHandlers = lookup.lookupAll(DeprecatedPolymerPublishedEventHandler.class);
        Assert.assertEquals((long)1L, (long)allHandlers.size());
        Assert.assertEquals(TestPolymerPublishedEventHandler.class, (Object)((DeprecatedPolymerPublishedEventHandler)allHandlers.iterator().next()).getClass());
    }

    @Test
    public void processLookupServletContainerInitializer_routePathProviderIsProvidedAsScannedClass_lookupReturnsTheProviderInstance() throws ServletException {
        Lookup lookup = this.mockLookup(TestRoutePathProvider.class);
        RoutePathProvider handler = (RoutePathProvider)lookup.lookup(RoutePathProvider.class);
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals(TestRoutePathProvider.class, (Object)handler.getClass());
        Collection allHandlers = lookup.lookupAll(RoutePathProvider.class);
        Assert.assertEquals((long)1L, (long)allHandlers.size());
        Assert.assertEquals(TestRoutePathProvider.class, (Object)((RoutePathProvider)allHandlers.iterator().next()).getClass());
    }

    @Test
    public void processLookupServletContainerInitializer_contextHasDeferredInitializers_runInitializersAndClearAttribute() throws ServletException {
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        DeferredServletContextInitializers deferredInitializers = (DeferredServletContextInitializers)Mockito.mock(DeferredServletContextInitializers.class);
        Mockito.when((Object)context.getAttribute(DeferredServletContextInitializers.class.getName())).thenReturn((Object)deferredInitializers);
        this.mockLookup(context, new Class[0]);
        ((DeferredServletContextInitializers)Mockito.verify((Object)deferredInitializers)).runInitializers(context);
        ((ServletContext)Mockito.verify((Object)context)).removeAttribute(DeferredServletContextInitializers.class.getName());
    }

    @Test
    public void processApplicationConfigurationFactory_factoryIsProvided_providedFactoryIsCreated() throws ServletException {
        Lookup lookup = this.mockLookup(DefaultApplicationConfigurationFactory.class, TestApplicationConfigurationFactory.class);
        ApplicationConfigurationFactory config = (ApplicationConfigurationFactory)lookup.lookup(ApplicationConfigurationFactory.class);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)(config instanceof TestApplicationConfigurationFactory));
    }

    @Test
    public void process_customLookupInitializerIsProvided_servicesHasCustomImpls_customInitializerIsCalledWithProvidedImpls() throws ServletException {
        Lookup lookup = this.mockLookup(TestPolymerPublishedEventHandler.class, TestResourceProvider.class, TestApplicationConfigurationFactory.class, TestLookupInitializer.class);
        Assert.assertTrue((boolean)(lookup instanceof TestLookup));
        TestLookup customLookup = (TestLookup)lookup;
        Map<Class<?>, Collection<Class<?>>> services = customLookup.services;
        Assert.assertFalse((boolean)services.containsKey(LookupInitializer.class));
        Assert.assertEquals(TestPolymerPublishedEventHandler.class, services.get(DeprecatedPolymerPublishedEventHandler.class).iterator().next());
        Assert.assertEquals(TestResourceProvider.class, services.get(ResourceProvider.class).iterator().next());
        Assert.assertEquals(TestApplicationConfigurationFactory.class, services.get(ApplicationConfigurationFactory.class).iterator().next());
    }

    @Test
    public void getServiceTypes_getServiceTypesIsInvoked_initializerIsInvokdedWithProvidedServices() throws ServletException {
        this.initializer = new LookupServletContainerInitializer(this){

            protected Collection<Class<?>> getServiceTypes() {
                return Arrays.asList(List.class);
            }
        };
        Lookup lookup = this.mockLookup(TestLookupInitializer.class, ArrayList.class);
        Assert.assertTrue((boolean)(lookup instanceof TestLookup));
        TestLookup customLookup = (TestLookup)lookup;
        Map<Class<?>, Collection<Class<?>>> services = customLookup.services;
        Assert.assertFalse((boolean)services.containsKey(LookupInitializer.class));
        Assert.assertTrue((boolean)services.containsKey(List.class));
        Collection<Class<?>> collection = services.get(List.class);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertEquals(ArrayList.class, collection.iterator().next());
    }

    @Test(expected=ServletException.class)
    public void process_classSetIsNull_throws() throws ServletException {
        this.initializer.process(null, (ServletContext)Mockito.mock(ServletContext.class));
    }

    private Lookup mockLookup(ServletContext context, Class<?> ... classes) throws ServletException {
        ArgumentCaptor lookupCapture = ArgumentCaptor.forClass(Lookup.class);
        Stream<Class<?>> stream = Stream.concat(Stream.of(LookupInitializer.class), Stream.of(classes));
        this.initializer.process(stream.collect(Collectors.toSet()), context);
        ((ServletContext)Mockito.verify((Object)context)).setAttribute((String)Mockito.eq((Object)Lookup.class.getName()), lookupCapture.capture());
        return (Lookup)lookupCapture.getValue();
    }

    private Lookup mockLookup(Class<?> ... classes) throws ServletException {
        return this.mockLookup((ServletContext)Mockito.mock(ServletContext.class), classes);
    }

    public static class TestPolymerPublishedEventHandler
    implements DeprecatedPolymerPublishedEventHandler {
        public boolean isTemplateModelValue(Component instance, JsonNode argValue, Class<?> convertedType) {
            return false;
        }

        public Object getTemplateItem(Component template, JsonNode argValue, Type convertedType) {
            return null;
        }
    }

    public static class TestRoutePathProvider
    implements RoutePathProvider {
        public String getRoutePath(Class<?> navigationTarget) {
            return null;
        }
    }

    public static class TestApplicationConfigurationFactory
    implements ApplicationConfigurationFactory {
        public ApplicationConfiguration create(VaadinContext context) {
            return null;
        }
    }

    public static class TestLookupInitializer
    extends LookupInitializer {
        public void initialize(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services, VaadinApplicationInitializationBootstrap bootstrap) throws ServletException {
            TestLookup lookup = new TestLookup();
            lookup.services = services;
            bootstrap.bootstrap((Lookup)lookup);
        }
    }

    private static class TestLookup
    implements Lookup {
        private Map<Class<?>, Collection<Class<?>>> services;

        private TestLookup() {
        }

        public <T> T lookup(Class<T> serviceClass) {
            return null;
        }

        public <T> Collection<T> lookupAll(Class<T> serviceClass) {
            return null;
        }
    }
}

