/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.AnnotationValidator;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class AnnotationValidatorTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private AnnotationValidator annotationValidator;
    private ServletContext servletContext;

    @Before
    public void init() {
        this.annotationValidator = new AnnotationValidator();
        this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
    }

    @Test
    public void onStartUp_all_failing_anotations_are_reported() throws ServletException {
        try {
            this.annotationValidator.process(Stream.of(InlineViewportWithParent.class, BodySizeViewportWithParent.class, ViewPortViewportWithParent.class).collect(Collectors.toSet()), this.servletContext);
            Assert.fail((String)"No exception was thrown for faulty setup.");
        }
        catch (InvalidApplicationConfigurationException iace) {
            String errorMessage = iace.getMessage();
            Assert.assertTrue((String)"Exception has wrong beginning.", (boolean)errorMessage.startsWith("Found configuration annotations that will not be used in the application. \nMove the following annotations to a single route or the top RouterLayout of the application: \n"));
            Assert.assertTrue((String)"Exception was missing Inline exception", (boolean)errorMessage.contains(String.format("Non parent Route target: %s contains: %s", InlineViewportWithParent.class.getName(), "@" + Inline.class.getSimpleName())));
            Assert.assertTrue((String)"Exception was missing Viewport exception", (boolean)errorMessage.contains(String.format("Non parent Route target: %s contains: %s", ViewPortViewportWithParent.class.getName(), "@" + Viewport.class.getSimpleName())));
            Assert.assertTrue((String)"Exception was missing BodySize exception", (boolean)errorMessage.contains(String.format("Non parent Route target: %s contains: %s", BodySizeViewportWithParent.class.getName(), "@" + BodySize.class.getSimpleName())));
        }
    }

    @Test
    public void onStartUp_all_failing_annotations_are_marked_for_class() throws ServletException {
        this.expectedEx.expect(InvalidApplicationConfigurationException.class);
        this.expectedEx.expectMessage("Found configuration annotations that will not be used in the application. \nMove the following annotations to a single route or the top RouterLayout of the application: \n" + String.format("Non parent Route target: %s contains: %s", FailingMultiAnnotation.class.getName(), "@" + BodySize.class.getSimpleName() + ", @" + Inline.class.getSimpleName()));
        this.annotationValidator.process(Stream.of(FailingMultiAnnotation.class).collect(Collectors.toSet()), this.servletContext);
        Assert.fail((String)"No exception was thrown for faulty setup.");
    }

    @Test
    public void onStartUp_no_exception_is_thrown_for_correctly_setup_classes() throws ServletException {
        this.annotationValidator.process(Stream.of(MultiAnnotation.class, AbstractMain.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void selfReferencesAreRemoved() {
        HandlesTypesTest annotationTest = new HandlesTypesTest();
        this.assertTypes(annotationTest, Set.of(Viewport.class), Set.of());
        this.assertTypes(annotationTest, Set.of(Viewport.class, AnnotationValidatorTest.class), Set.of(AnnotationValidatorTest.class));
        this.assertTypes(annotationTest, Set.of(Viewport.class, AnnotationValidatorTest.class), Set.of(AnnotationValidatorTest.class));
        ExtendedHandlesTypesTest extendedAnnotationTest = new ExtendedHandlesTypesTest();
        this.assertTypes(extendedAnnotationTest, Set.of(Viewport.class), Set.of());
        HasErrorParameterTest interfaceTest = new HasErrorParameterTest(this);
        this.assertTypes(interfaceTest, Set.of(DummyHasErrorParameter.class), Set.of(DummyHasErrorParameter.class));
        this.assertTypes(interfaceTest, Set.of(DummyHasErrorParameter.class), Set.of(DummyHasErrorParameter.class));
        this.assertTypes(interfaceTest, Set.of(HasErrorParameter.class, DummyHasErrorParameter.class), Set.of(DummyHasErrorParameter.class));
        this.assertTypes(interfaceTest, Set.of(HasErrorParameter.class, HasSomethingElse.class, DummyHasErrorParameter.class, DummySomethingElse.class), Set.of(DummyHasErrorParameter.class, DummySomethingElse.class));
    }

    private void assertTypes(Object testObject, Set<Class<?>> input, Set<Class<?>> expectedOutput) {
        Assert.assertEquals(expectedOutput, (Object)AbstractAnnotationValidator.removeHandleTypesSelfReferences(input, (Object)testObject));
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    @Inline(value="inline.css")
    public static class InlineViewportWithParent
    extends Component {
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    @BodySize(width="100vw")
    public static class BodySizeViewportWithParent
    extends Component {
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    @Viewport(value="width=device-width")
    public static class ViewPortViewportWithParent
    extends Component {
    }

    @Route(value="multiple_annotations", layout=Parent.class)
    @Inline(value="inlie.css")
    @BodySize(width="100vw")
    public static class FailingMultiAnnotation
    extends Component {
    }

    @Route(value="multiple_annotations")
    @Inline(value="inlie.css")
    @BodySize(width="100vw")
    @Viewport(value="width=device-width")
    public static class MultiAnnotation
    extends Component {
    }

    @Tag(value="div")
    public static abstract class AbstractMain
    extends Component {
    }

    @HandlesTypes(value={Viewport.class, BodySize.class, Inline.class})
    public static class HandlesTypesTest
    implements ServletContainerInitializer {
        public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        }
    }

    public static class ExtendedHandlesTypesTest
    extends HandlesTypesTest {
    }

    @HandlesTypes(value={HasErrorParameter.class, HasSomethingElse.class})
    public class HasErrorParameterTest
    implements ServletContainerInitializer {
        public HasErrorParameterTest(AnnotationValidatorTest this$0) {
        }

        public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        }
    }

    public static class DummyHasErrorParameter
    implements HasErrorParameter {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter parameter) {
            return 0;
        }
    }

    public static interface HasSomethingElse {
    }

    public static class DummySomethingElse
    implements HasSomethingElse {
    }

    @Tag(value="div")
    public static class Parent
    extends Component
    implements RouterLayout {
    }
}

