/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ListFeatureSetViewTest {
    private TestFeature feature;
    private NodeList.SetView<String> set;

    @Before
    public void setup() {
        this.feature = new TestFeature();
        this.set = new TestSetView((NodeList<String>)this.feature);
    }

    @Test
    public void testSetViewAdd() {
        this.set.add((Serializable)((Object)"0"));
        this.assertContents("0");
        this.set.add((Serializable)((Object)"1"));
        this.assertContents("0", "1");
        this.set.add((Serializable)((Object)"2"));
        this.assertContents("0", "1", "2");
    }

    @Test
    public void testSetViewSize() {
        this.set.add((Serializable)((Object)"0"));
        Assert.assertEquals((long)1L, (long)this.set.size());
        this.set.add((Serializable)((Object)"1"));
        Assert.assertEquals((long)2L, (long)this.set.size());
        this.set.remove((Object)"1");
        Assert.assertEquals((long)1L, (long)this.set.size());
        this.set.remove((Object)"1");
        Assert.assertEquals((long)1L, (long)this.set.size());
        this.set.remove((Object)"0");
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testSetViewRemove() {
        this.set.add((Serializable)((Object)"0"));
        this.set.add((Serializable)((Object)"1"));
        this.set.remove((Object)"0");
        this.assertContents("1");
        this.set.remove((Object)"1");
        this.assertContents(new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetViewValidateAdd() {
        this.set.add((Serializable)((Object)"as89w4573"));
    }

    @Test
    public void testSetViewClear() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        this.set.clear();
        this.assertContents(new String[0]);
        this.set.clear();
    }

    @Test
    public void testSetViewIteratorIterate() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Iterator i = this.set.iterator();
        Assert.assertEquals((Object)"a", i.next());
        Assert.assertEquals((Object)"b", i.next());
        Assert.assertEquals((Object)"c", i.next());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testSetViewIteratorRemove() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Iterator i = this.set.iterator();
        i.next();
        i.next();
        i.remove();
        this.assertContents("a", "c");
    }

    @Test
    public void testSetViewContains() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Assert.assertTrue((boolean)this.set.contains((Object)"a"));
        Assert.assertTrue((boolean)this.set.contains((Object)"b"));
        Assert.assertTrue((boolean)this.set.contains((Object)"c"));
        Assert.assertFalse((boolean)this.set.contains((Object)"d"));
    }

    @Test
    public void testSetViewSameFeatureEquals() {
        this.set.add((Serializable)((Object)"a"));
        TestSetView otherSet = new TestSetView((NodeList<String>)this.feature);
        Assert.assertEquals(this.set, (Object)((Object)otherSet));
        Assert.assertEquals((long)this.set.hashCode(), (long)otherSet.hashCode());
    }

    @Test
    public void testSetViewDifferentFeatureEquals() {
        this.set.add((Serializable)((Object)"a"));
        TestFeature otherFeature = new TestFeature();
        TestSetView otherSet = new TestSetView((NodeList<String>)otherFeature);
        otherSet.add((Serializable)((Object)"a"));
        Assert.assertEquals(this.set, (Object)((Object)otherSet));
        Assert.assertEquals((long)this.set.hashCode(), (long)otherSet.hashCode());
    }

    private void assertContents(String ... expected) {
        Object[] actual = new String[this.feature.size()];
        for (int i = 0; i < this.feature.size(); ++i) {
            actual[i] = (String)((Object)this.feature.get(i));
        }
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    private static class TestFeature
    extends SerializableNodeList<String> {
        private final ArrayList<AbstractListChange<String>> changes = new ArrayList();

        public TestFeature() {
            super((StateNode)Mockito.mock(StateNode.class));
        }

        protected List<AbstractListChange<String>> getChangeTracker() {
            return this.changes;
        }
    }

    private static class TestSetView
    extends NodeList.SetView<String> {
        public TestSetView(NodeList<String> list) {
            super(list);
        }

        protected void validate(String string) {
            if (string.length() > 5) {
                throw new IllegalArgumentException("All strings must be less than 5 characters");
            }
        }
    }
}

