/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.tests.util.MockUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class DependencyListTest {
    private static final String URL = "https://example.net/";
    private MockUI ui;
    private DependencyList deps;

    @Before
    public void before() {
        this.ui = MockUI.createUI();
        this.deps = this.ui.getInternals().getDependencyList();
        Assert.assertEquals((long)0L, (long)this.deps.getPendingSendToClient().size());
    }

    @After
    public void after() {
        UI.setCurrent(null);
    }

    @Test
    public void addStyleSheetDependency_eager1() {
        this.ui.getPage().addStyleSheet(URL);
        this.validateDependency(URL, Dependency.Type.STYLESHEET, LoadMode.EAGER);
    }

    @Test
    public void addStyleSheetDependency_eager2() {
        this.ui.getPage().addStyleSheet(URL, LoadMode.EAGER);
        this.validateDependency(URL, Dependency.Type.STYLESHEET, LoadMode.EAGER);
    }

    @Test
    public void addStyleSheetDependency_lazy() {
        this.ui.getPage().addStyleSheet(URL, LoadMode.LAZY);
        this.validateDependency(URL, Dependency.Type.STYLESHEET, LoadMode.LAZY);
    }

    @Test
    public void addStyleSheetDependency_inline() {
        this.ui.getPage().addStyleSheet(URL, LoadMode.INLINE);
        this.validateDependency(URL, Dependency.Type.STYLESHEET, LoadMode.INLINE);
    }

    @Test
    public void addJavaScriptDependency_eager1() {
        this.ui.getPage().addJavaScript(URL);
        this.validateDependency(URL, Dependency.Type.JAVASCRIPT, LoadMode.EAGER);
    }

    @Test
    public void addJavaScriptDependency_eager2() {
        this.ui.getPage().addJavaScript(URL, LoadMode.EAGER);
        this.validateDependency(URL, Dependency.Type.JAVASCRIPT, LoadMode.EAGER);
    }

    @Test
    public void addJavaScriptDependency_lazy() {
        this.ui.getPage().addJavaScript(URL, LoadMode.LAZY);
        this.validateDependency(URL, Dependency.Type.JAVASCRIPT, LoadMode.LAZY);
    }

    @Test
    public void addJavaScriptDependency_inline() {
        this.ui.getPage().addJavaScript(URL, LoadMode.INLINE);
        this.validateDependency(URL, Dependency.Type.JAVASCRIPT, LoadMode.INLINE);
    }

    private void validateDependency(String url, Dependency.Type dependencyType, LoadMode loadMode) {
        Assert.assertEquals((String)"Expected to receive exactly one dependency", (long)1L, (long)this.deps.getPendingSendToClient().size());
        Dependency dependency = (Dependency)this.deps.getPendingSendToClient().iterator().next();
        Assert.assertEquals((String)"URL mismatch", (Object)url, (Object)dependency.getUrl());
        Assert.assertEquals((String)"Type mismatch", (Object)dependencyType, (Object)dependency.getType());
        Assert.assertEquals((String)"LoadMode mismatch", (Object)loadMode, (Object)dependency.getLoadMode());
        ObjectNode expectedJson = JacksonUtils.createObjectNode();
        expectedJson.put("url", url);
        expectedJson.put("type", dependencyType.name());
        expectedJson.put("loadMode", loadMode.name());
        ObjectNode actualJson = (ObjectNode)JacksonUtils.getMapper().valueToTree((Object)dependency);
        actualJson.remove("id");
        Assert.assertTrue((String)String.format("Dependencies' json representations are different, expected = \n'%s'\n, actual = \n'%s'", expectedJson.toString(), actualJson.toString()), (boolean)JacksonUtils.jsonEquals((JsonNode)expectedJson, (JsonNode)actualJson));
    }

    @Test
    public void specialUrls() {
        this.assertUrlUnchanged("/foo?bar");
        this.assertUrlUnchanged("/foo/baz?bar=http://some.thing");
        this.assertUrlUnchanged("/foo/baz?bar=http://some.thing&ftp://bar");
        this.assertUrlUnchanged("http://foo?bar");
        this.assertUrlUnchanged("http://foo/baz");
        this.assertUrlUnchanged("http://foo/baz?bar");
        this.assertUrlUnchanged("http://foo/baz?bar=http://some.thing");
        this.assertUrlUnchanged("ftp://some.host/some/where");
        this.assertUrlUnchanged("https://some.host/some/where");
        this.assertUrlUnchanged("//same.protocol.some.host/some/where");
        this.assertUrlUnchanged("context://foo?bar=frontend://baz");
    }

    private void assertUrlUnchanged(String url) {
        this.assertDependencyUrl(url, url);
    }

    private void assertDependencyUrl(String expectedUrl, String dependencyUrl) {
        this.addSimpleDependency(dependencyUrl);
        Assert.assertEquals((Object)expectedUrl, (Object)((Dependency)this.deps.getPendingSendToClient().iterator().next()).getUrl());
        this.deps.clearPendingSendToClient();
    }

    @Test
    public void urlAddedOnlyOnce() {
        this.addSimpleDependency("foo/bar.js");
        this.addSimpleDependency("foo/bar.js");
        Assert.assertEquals((long)1L, (long)this.deps.getPendingSendToClient().size());
        this.deps.clearPendingSendToClient();
        this.addSimpleDependency("foo/bar.js");
        Assert.assertEquals((long)0L, (long)this.deps.getPendingSendToClient().size());
    }

    private void addSimpleDependency(String foo) {
        this.deps.add(new Dependency(Dependency.Type.JAVASCRIPT, foo, LoadMode.EAGER));
    }

    @Test
    public void addSameDependencyInDifferentModes_usesMostEagerLoadMode() {
        this.testAddingDuplicateDependencies(LoadMode.EAGER, LoadMode.EAGER, LoadMode.EAGER);
        this.testAddingDuplicateDependencies(LoadMode.EAGER, LoadMode.LAZY, LoadMode.EAGER);
        this.testAddingDuplicateDependencies(LoadMode.EAGER, LoadMode.INLINE, LoadMode.INLINE);
        this.testAddingDuplicateDependencies(LoadMode.LAZY, LoadMode.EAGER, LoadMode.EAGER);
        this.testAddingDuplicateDependencies(LoadMode.LAZY, LoadMode.LAZY, LoadMode.LAZY);
        this.testAddingDuplicateDependencies(LoadMode.LAZY, LoadMode.INLINE, LoadMode.INLINE);
        this.testAddingDuplicateDependencies(LoadMode.INLINE, LoadMode.EAGER, LoadMode.INLINE);
        this.testAddingDuplicateDependencies(LoadMode.INLINE, LoadMode.LAZY, LoadMode.INLINE);
        this.testAddingDuplicateDependencies(LoadMode.INLINE, LoadMode.INLINE, LoadMode.INLINE);
    }

    private void testAddingDuplicateDependencies(LoadMode first, LoadMode second, LoadMode expected) {
        String url = "foo/bar.js";
        Dependency.Type type = Dependency.Type.JAVASCRIPT;
        this.deps = new DependencyList();
        this.deps.add(new Dependency(type, url, first));
        this.deps.add(new Dependency(type, url, second));
        Collection pendingSendToClient = this.deps.getPendingSendToClient();
        Assert.assertEquals((String)"Expected to have only one dependency", (long)1L, (long)pendingSendToClient.size());
        Assert.assertEquals((String)"Wrong load mode resolved", (Object)((Dependency)pendingSendToClient.iterator().next()).getLoadMode(), (Object)expected);
    }

    @Test
    public void addDependencyPerformance() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            this.addSimpleDependency("foo" + i + "/bar.js");
        }
        long time = System.currentTimeMillis() - start;
        Assert.assertTrue((String)("Adding 10K dependencies should take about 50ms. Took " + time + "ms"), (time < 500L ? 1 : 0) != 0);
    }

    @Test
    public void ensureDependenciesSentToClientHaveTheSameOrderAsAdded() {
        Dependency eagerJs = new Dependency(Dependency.Type.JAVASCRIPT, "eager.js", LoadMode.EAGER);
        Dependency eagerCss = new Dependency(Dependency.Type.STYLESHEET, "eager.css", LoadMode.EAGER);
        Dependency lazyJs = new Dependency(Dependency.Type.JAVASCRIPT, "lazy.js", LoadMode.LAZY);
        Dependency lazyCss = new Dependency(Dependency.Type.STYLESHEET, "lazy.css", LoadMode.LAZY);
        Assert.assertEquals((String)"Expected the dependency to be eager", (Object)LoadMode.EAGER, (Object)eagerJs.getLoadMode());
        Assert.assertEquals((String)"Expected the dependency to be eager", (Object)LoadMode.EAGER, (Object)eagerCss.getLoadMode());
        Assert.assertEquals((String)"Expected the dependency to be lazy", (Object)LoadMode.LAZY, (Object)lazyJs.getLoadMode());
        Assert.assertEquals((String)"Expected the dependency to be lazy", (Object)LoadMode.LAZY, (Object)lazyCss.getLoadMode());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(Arrays.asList(eagerJs, eagerCss, lazyJs, lazyCss));
        Assert.assertEquals((String)"Expected to have 4 dependencies", (long)4L, (long)dependencies.size());
        Collections.shuffle(dependencies);
        dependencies.forEach(arg_0 -> ((DependencyList)this.deps).add(arg_0));
        ArrayList pendingSendToClient = new ArrayList(this.deps.getPendingSendToClient());
        for (int i = 0; i < pendingSendToClient.size(); ++i) {
            Dependency actualDependency = (Dependency)pendingSendToClient.get(i);
            Dependency expectedDependency = (Dependency)dependencies.get(i);
            Assert.assertEquals((String)"Expected to have the same dependency on the same position for list, but urls do not match", (Object)expectedDependency.getUrl(), (Object)actualDependency.getUrl());
            Assert.assertEquals((String)"Expected to have the same dependency on the same position for list, but load modes do not match", (Object)expectedDependency.getLoadMode(), (Object)actualDependency.getLoadMode());
        }
    }
}

