/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.i18n.I18NUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class I18NUtilTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File resources;
    @Mock
    private ClassLoader mockLoader;

    @Before
    public void init() throws IOException {
        this.resources = this.temporaryFolder.newFolder();
    }

    @Test
    public void foundResourceFolder_returnsExpectedLocales() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        File file = new File(this.resources, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_en_GB.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=English", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_fi_FI.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Suomi", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_de.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=deutsch", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assert.assertEquals((long)3L, (long)defaultTranslationLocales.size());
        Assert.assertTrue((String)"Missing German bundle", (boolean)defaultTranslationLocales.contains(new Locale("de")));
        Assert.assertTrue((String)"Missing English bundle", (boolean)defaultTranslationLocales.contains(new Locale("en", "GB")));
        Assert.assertTrue((String)"Missing Finnish bundle", (boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")));
    }

    @Test
    public void noTranslationFiles_returnsEmptyList() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assert.assertTrue((String)"Nothing should be returned for empty folder", (boolean)defaultTranslationLocales.isEmpty());
    }

    @Test
    public void onlyDefaultTranslationFile_returnsEmptyList() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        File file = new File(this.resources, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assert.assertTrue((String)"Nothing should be returned for empty folder", (boolean)defaultTranslationLocales.isEmpty());
    }

    @Test
    public void onlyDefaultTranslationFile_returnsTrueForDefault() throws IOException {
        File translations = new File(this.resources, "vaadin-i18n");
        translations.mkdirs();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.resources.toURI().toURL()});
        File file = new File(translations, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        Assert.assertTrue((String)"Default file should return true", (boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader));
    }

    @Test
    public void noTranslationFilesInExistingFolder_returnsFalseForDefault() throws IOException {
        File translations = new File(this.resources, "vaadin-i18n");
        translations.mkdirs();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.resources.toURI().toURL()});
        Assert.assertFalse((String)"Nothing should be returned for empty folder", (boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader));
    }

    @Test
    public void translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{path.toUri().toURL()});
        Assert.assertTrue((String)"Default file should return true", (boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader));
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assert.assertEquals((String)"Translation files with locale inside JAR should be resolved", (long)2L, (long)defaultTranslationLocales.size());
        Assert.assertTrue((String)"Finnish locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")));
        Assert.assertTrue((String)"Japan locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")));
    }

    @Test
    public void openliberty_translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        final URLStreamHandler wsjarMockHandler = new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                url = new URL("jar", url.getPath(), url.getFile());
                return url.openConnection();
            }
        };
        URLStreamHandlerFactory wsjarMockHandlerFactory = protocol -> {
            if ("wsjar".equals(protocol)) {
                return wsjarMockHandler;
            }
            return null;
        };
        URLClassLoader urlClassLoader = new URLClassLoader(this, new URL[]{path.toUri().toURL()}, ClassLoader.getSystemClassLoader(), wsjarMockHandlerFactory){

            @Override
            public URL getResource(String name) {
                URL url = super.getResource(name);
                if (url != null && url.getProtocol().equals("jar")) {
                    try {
                        return new URL("wsjar", url.getHost(), url.getPort(), url.getFile(), wsjarMockHandler);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return url;
            }
        };
        Assert.assertTrue((String)"Default file should return true", (boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader));
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assert.assertEquals((String)"Translation files with locale inside JAR should be resolved", (long)2L, (long)defaultTranslationLocales.size());
        Assert.assertTrue((String)"Finnish locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")));
        Assert.assertTrue((String)"Japan locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")));
    }

    @Test
    public void jbossVfs_translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        JarFile jarFile = new JarFile(path.toFile());
        final URLConnection urlConnection = (URLConnection)Mockito.mock(URLConnection.class);
        Mockito.when((Object)urlConnection.getContent()).thenReturn((Object)new MockVirtualFile(jarFile, jarFile.getJarEntry("vaadin-i18n/")));
        final URLStreamHandler vfsMockHandler = new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                if (url.getFile().endsWith("/vaadin-i18n")) {
                    return urlConnection;
                }
                return null;
            }
        };
        URLStreamHandlerFactory vfsMockHandlerFactory = protocol -> {
            if ("vfs".equals(protocol)) {
                return vfsMockHandler;
            }
            return null;
        };
        URLClassLoader urlClassLoader = new URLClassLoader(this, new URL[]{path.toUri().toURL()}, ClassLoader.getSystemClassLoader(), vfsMockHandlerFactory){

            @Override
            public URL getResource(String name) {
                URL url = super.getResource(name);
                if (url != null && url.getProtocol().equals("jar") && url.getFile().contains("fake.jar!")) {
                    try {
                        return new URL("vfs", null, 0, "/content/my.war/WEB-INF/lib/fake.jar" + url.getFile().replaceFirst(".*fake.jar!", ""), vfsMockHandler);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return url;
            }
        };
        Assert.assertTrue((String)"Default file should return true", (boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader));
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assert.assertEquals((String)"Translation files with locale inside JAR should be resolved", (long)2L, (long)defaultTranslationLocales.size());
        Assert.assertTrue((String)"Finnish locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")));
        Assert.assertTrue((String)"Japan locale translation should have been found", (boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")));
    }

    private Path generateZipArchive(TemporaryFolder folder) throws IOException {
        File archiveFile = new File(folder.getRoot(), "fake.jar");
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempArchive, new OpenOption[0]));){
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations.properties"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations_fi_FI.properties"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations_ja_JP.properties"));
            zipOutputStream.closeEntry();
        }
        return tempArchive;
    }

    public static class MockVirtualFile {
        private final JarEntry entry;
        private final JarFile jarFile;

        private MockVirtualFile(JarFile jarFile, JarEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public List<MockVirtualFile> getChildren() {
            return this.jarFile.stream().filter(e -> !e.getName().equals(this.entry.getName()) && e.getName().startsWith(this.entry.getName()) && (e.getName().endsWith("/") || !e.getName().substring(this.entry.getName().length()).contains("/"))).map(e -> new MockVirtualFile(this.jarFile, (JarEntry)e)).toList();
        }

        public File getPhysicalFile() {
            return new File(this.entry.getName());
        }
    }
}

