/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import org.junit.Assert;
import org.junit.Test;

public class HasComponentsTest {
    @Test
    public void addStringToComponent() {
        String text = "Add text";
        TestComponent component = new TestComponent();
        component.add(text);
        Assert.assertEquals((Object)text, (Object)component.getElement().getText());
    }

    @Test
    public void insertComponentAtFirst() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-first");
        component.addComponentAsFirst(innerComponent);
        this.checkChildren(4, component);
        Assert.assertEquals((Object)innerComponent.getId(), (Object)((Component)component.getChildren().findFirst().get()).getId());
    }

    @Test
    public void insertComponentAtIndex() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index");
        component.addComponentAtIndex(2, innerComponent);
        this.checkChildren(4, component);
        Assert.assertEquals((Object)innerComponent.getId(), (Object)((Component)component.getElement().getChild(2).getComponent().get()).getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void insertComponentIndexLessThanZero() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index-less");
        component.addComponentAtIndex(-5, innerComponent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void insertComponentIndexGreaterThanChildrenNumber() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        innerComponent.setId("insert-component-index-greater");
        component.addComponentAtIndex(100, innerComponent);
    }

    @Test
    public void remove_removeComponentWithNoParent() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        component.remove(new Component[]{innerComponent});
    }

    @Test
    public void remove_removeSeveralComponents_oneHasParent_nothingRemovedAndThrows() {
        TestComponent component = this.createTestStructure();
        TestComponent child = new TestComponent();
        component.add(new Component[]{child});
        TestComponent another = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        another.add(new Component[]{innerComponent});
        try {
            component.remove(new Component[]{child, innerComponent});
            Assert.fail();
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)((Object)component), child.getParent().get());
        }
    }

    @Test
    public void remove_removeSeveralComponents_oneHasNoParent_childIsRemoved() {
        TestComponent component = this.createTestStructure();
        TestComponent child = new TestComponent();
        component.add(new Component[]{child});
        TestComponent notAChild = new TestComponent();
        component.remove(new Component[]{notAChild, child});
        Assert.assertFalse((boolean)child.getParent().isPresent());
        Assert.assertFalse((boolean)component.getChildren().filter(comp -> comp.equals((Object)child)).findAny().isPresent());
    }

    @Test
    public void remove_removeComponentWithCorrectParent() {
        TestComponent component = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        long size = component.getChildren().count();
        component.add(new Component[]{innerComponent});
        component.remove(new Component[]{innerComponent});
        Assert.assertEquals((long)size, (long)component.getChildren().count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void remove_removeComponentWithDifferentParent() {
        TestComponent component = this.createTestStructure();
        TestComponent another = this.createTestStructure();
        TestComponent innerComponent = new TestComponent();
        another.add(new Component[]{innerComponent});
        component.remove(new Component[]{innerComponent});
    }

    private TestComponent createTestStructure() {
        TestComponent component = new TestComponent();
        this.checkChildren(0, component);
        component.add(new Component[]{new TestComponent(), new TestComponent(), new TestComponent()});
        this.checkChildren(3, component);
        return component;
    }

    private void checkChildren(int number, TestComponent component) {
        Assert.assertEquals((long)number, (long)component.getChildren().count());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        private TestComponent() {
        }
    }
}

