/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.auth.AccessCheckDecision;
import java.io.Serializable;
import java.util.Objects;

public class AccessCheckResult
implements Serializable {
    private static final AccessCheckResult ALLOW = new AccessCheckResult(AccessCheckDecision.ALLOW, null);
    private static final AccessCheckResult NEUTRAL = new AccessCheckResult(AccessCheckDecision.NEUTRAL, null);
    private final String reason;
    private final AccessCheckDecision decision;

    public AccessCheckResult(AccessCheckDecision decision, String reason) {
        if (decision == null) {
            throw new IllegalArgumentException("Decision must not be null");
        }
        if ((decision == AccessCheckDecision.DENY || decision == AccessCheckDecision.REJECT) && reason == null) {
            throw new IllegalArgumentException(decision.name() + " requires a not null reason");
        }
        this.decision = decision;
        this.reason = reason;
    }

    public AccessCheckDecision decision() {
        return this.decision;
    }

    public String reason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessCheckResult result = (AccessCheckResult)o;
        return Objects.equals(this.reason, result.reason) && this.decision == result.decision;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.decision});
    }

    public String toString() {
        return "Access decision: " + String.valueOf((Object)this.decision) + (String)(this.reason != null ? ". " + this.reason : "");
    }

    public static AccessCheckResult create(AccessCheckDecision decision, String reason) {
        return new AccessCheckResult(decision, reason);
    }

    public static AccessCheckResult allow() {
        return ALLOW;
    }

    public static AccessCheckResult neutral() {
        return NEUTRAL;
    }

    public static AccessCheckResult deny(String reason) {
        return new AccessCheckResult(AccessCheckDecision.DENY, reason);
    }

    public static AccessCheckResult reject(String reason) {
        return new AccessCheckResult(AccessCheckDecision.REJECT, reason);
    }
}

