/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.testutil.ClassesSerializableTest;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class FlowClassesSerializableTest
extends ClassesSerializableTest {
    @Test
    public void htmlComponentAndHtmlContainer() throws Throwable {
        Component[] components;
        for (Component component : components = new Component[]{new HtmlComponent("dummy-tag"), new HtmlContainer("dummy-tag")}) {
            Component componentCopy = (Component)this.serializeAndDeserialize(component);
            Assert.assertEquals((Object)component.getElement().getTag(), (Object)componentCopy.getElement().getTag());
            Assert.assertNotSame((Object)component.getElement(), (Object)componentCopy.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamResource() throws Throwable {
        UI ui = new UI();
        UI.setCurrent((UI)ui);
        try {
            Element element = new Element("dummy-element");
            StreamReceiver streamReceiver = new StreamReceiver(element.getNode(), "upload", (StreamVariable)new MyStreamVariable());
            Assert.assertEquals((Object)ui, (Object)UI.getCurrent());
            element.setAttribute("target", (AbstractStreamResource)streamReceiver);
            this.serializeAndDeserialize(element);
            Assert.assertTrue((String)"Basic smoke test with ", (element.getAttribute("target").length() > 10 ? 1 : 0) != 0);
        }
        finally {
            UI.setCurrent(null);
        }
    }

    private static class MyStreamVariable
    implements StreamVariable {
        private MyStreamVariable() {
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public boolean listenProgress() {
            return false;
        }

        public void onProgress(StreamVariable.StreamingProgressEvent event) {
        }

        public void streamingStarted(StreamVariable.StreamingStartEvent event) {
        }

        public void streamingFinished(StreamVariable.StreamingEndEvent event) {
        }

        public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
        }

        public boolean isInterrupted() {
            return false;
        }
    }
}

