/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AccessControlTestClasses;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class AccessAnnotationCheckerTest {
    public static final Class<?>[] ENDPOINT_CLASSES = new Class[]{AccessControlTestClasses.AnonymousAllowedClass.class, AccessControlTestClasses.DenyAllClass.class, AccessControlTestClasses.NoAnnotationClass.class, AccessControlTestClasses.PermitAllClass.class, AccessControlTestClasses.RolesAllowedAdminClass.class, AccessControlTestClasses.RolesAllowedUserClass.class};
    public static final String[] ENDPOINT_METHODS = new String[]{"noAnnotation", "anonymousAllowed", "permitAll", "denyAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin"};
    public static final String[] ENDPOINT_NAMES = (String[])Stream.of(ENDPOINT_CLASSES).map(cls -> cls.getSimpleName().toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
    static final Principal USER_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "John Doe";
        }
    };
    static final String REQUEST_URL = "http://localhost:8080/myapp/";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private AccessAnnotationChecker accessAnnotationChecker;

    @Before
    public void before() {
        this.accessAnnotationChecker = new AccessAnnotationChecker();
    }

    @Test
    public void should_Throw_When_PrivateMethodIsPassed() throws Exception {
        class Test {
            Test(AccessAnnotationCheckerTest this$0) {
            }

            private void test() {
            }
        }
        Method method = Test.class.getDeclaredMethod("test", new Class[0]);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage(method.toString());
        this.accessAnnotationChecker.getSecurityTarget(method);
    }

    @Test
    public void should_ReturnEnclosingClassAsSecurityTarget_When_NoSecurityAnnotationsPresent() throws Exception {
        class Test {
            Test(AccessAnnotationCheckerTest this$0) {
            }

            public void test() {
            }
        }
        Assert.assertEquals(Test.class, (Object)this.accessAnnotationChecker.getSecurityTarget(Test.class.getMethod("test", new Class[0])));
    }

    @Test
    public void should_ReturnEnclosingClassAsSecurityTarget_When_OnlyClassHasSecurityAnnotations() throws Exception {
        @AnonymousAllowed
        class Test {
            Test(AccessAnnotationCheckerTest this$0) {
            }

            public void test() {
            }
        }
        Assert.assertEquals(Test.class, (Object)this.accessAnnotationChecker.getSecurityTarget(Test.class.getMethod("test", new Class[0])));
    }

    @Test
    public void should_ReturnMethodAsSecurityTarget_When_OnlyMethodHasSecurityAnnotations() throws Exception {
        class Test {
            Test(AccessAnnotationCheckerTest this$0) {
            }

            @AnonymousAllowed
            public void test() {
            }
        }
        Method securityMethod = Test.class.getMethod("test", new Class[0]);
        Assert.assertEquals((Object)securityMethod, (Object)this.accessAnnotationChecker.getSecurityTarget(securityMethod));
    }

    @Test
    public void should_ReturnMethodAsSecurityTarget_When_BothClassAndMethodHaveSecurityAnnotations() throws Exception {
        @AnonymousAllowed
        class Test {
            Test(AccessAnnotationCheckerTest this$0) {
            }

            @AnonymousAllowed
            public void test() {
            }
        }
        Method securityMethod = Test.class.getMethod("test", new Class[0]);
        Assert.assertEquals((Object)securityMethod, (Object)this.accessAnnotationChecker.getSecurityTarget(securityMethod));
    }

    @Test
    public void specialViewsMustBeAccessible() {
        CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(AccessAnnotationCheckerTest.createRequest(null, new String[0]), null));
        Assert.assertTrue((boolean)this.accessAnnotationChecker.hasAccess(UI.ClientViewPlaceholder.class));
        Assert.assertTrue((boolean)this.accessAnnotationChecker.hasAccess(InternalServerError.class));
        Assert.assertTrue((boolean)this.accessAnnotationChecker.hasAccess(RouteNotFoundError.class));
    }

    @Test
    public void anonymousAccessAllowed() throws Exception {
        HttpServletRequest anonRequest = AccessAnnotationCheckerTest.createRequest(null, new String[0]);
        this.verifyMethodAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, anonRequest, "noAnnotation", "anonymousAllowed");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.DenyAllClass.class, anonRequest, "anonymousAllowed");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, anonRequest, "anonymousAllowed");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.PermitAllClass.class, anonRequest, "anonymousAllowed");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, anonRequest, "anonymousAllowed");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, anonRequest, "anonymousAllowed");
        this.verifyClassAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, anonRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.DenyAllClass.class, anonRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, anonRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.PermitAllClass.class, anonRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, anonRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, anonRequest, false);
    }

    @Test
    public void loggedInUserAccessAllowed() throws Exception {
        HttpServletRequest loggedInURequest = AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, new String[0]);
        this.verifyMethodAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, loggedInURequest, "noAnnotation", "anonymousAllowed", "permitAll");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.DenyAllClass.class, loggedInURequest, "anonymousAllowed", "permitAll");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, loggedInURequest, "anonymousAllowed", "permitAll");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.PermitAllClass.class, loggedInURequest, "noAnnotation", "anonymousAllowed", "permitAll");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, loggedInURequest, "anonymousAllowed", "permitAll");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, loggedInURequest, "anonymousAllowed", "permitAll");
        this.verifyClassAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, loggedInURequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.DenyAllClass.class, loggedInURequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, loggedInURequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.PermitAllClass.class, loggedInURequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, loggedInURequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, loggedInURequest, false);
    }

    @Test
    public void userRoleAccessAllowed() throws Exception {
        HttpServletRequest userRoleRequest = AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, "user");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, userRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.DenyAllClass.class, userRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, userRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.PermitAllClass.class, userRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, userRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, userRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedUserAdmin");
        this.verifyClassAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, userRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.DenyAllClass.class, userRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, userRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.PermitAllClass.class, userRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, userRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, userRoleRequest, true);
    }

    @Test
    public void userAndAdminRoleAccessAllowed() throws Exception {
        HttpServletRequest adminRoleRequest = AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, "user", "admin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.DenyAllClass.class, adminRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, adminRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.PermitAllClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedUser", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyClassAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.DenyAllClass.class, adminRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, adminRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.PermitAllClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, adminRoleRequest, true);
    }

    @Test
    public void adminRoleAccessAllowed() throws Exception {
        HttpServletRequest adminRoleRequest = AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, "admin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.DenyAllClass.class, adminRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, adminRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.PermitAllClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, adminRoleRequest, "noAnnotation", "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyMethodAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, adminRoleRequest, "anonymousAllowed", "permitAll", "rolesAllowedAdmin", "rolesAllowedUserAdmin");
        this.verifyClassAccessAllowed(AccessControlTestClasses.AnonymousAllowedClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.DenyAllClass.class, adminRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.NoAnnotationClass.class, adminRoleRequest, false);
        this.verifyClassAccessAllowed(AccessControlTestClasses.PermitAllClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedAdminClass.class, adminRoleRequest, true);
        this.verifyClassAccessAllowed(AccessControlTestClasses.RolesAllowedUserClass.class, adminRoleRequest, false);
    }

    @Test(expected=IllegalStateException.class)
    public void hasClassAccessNoCurrentRequest() {
        CurrentInstance.clearAll();
        this.accessAnnotationChecker.hasAccess(AccessControlTestClasses.AnonymousAllowedClass.class);
    }

    @Test(expected=IllegalStateException.class)
    public void hasMethodAccessNoCurrentRequest() throws Exception {
        CurrentInstance.clearAll();
        this.accessAnnotationChecker.hasAccess(AccessControlTestClasses.AnonymousAllowedClass.class.getMethod("permitAll", new Class[0]));
    }

    @Test
    public void hasClassAccessUsingCurrentRequest() {
        try {
            CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, new String[0]), null));
            Assert.assertTrue((boolean)this.accessAnnotationChecker.hasAccess(AccessControlTestClasses.PermitAllClass.class));
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void hasMethodAccessUsingCurrentRequest() throws Exception {
        try {
            CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(AccessAnnotationCheckerTest.createRequest(USER_PRINCIPAL, new String[0]), null));
            Assert.assertTrue((boolean)this.accessAnnotationChecker.hasAccess(AccessControlTestClasses.PermitAllClass.class.getMethod("permitAll", new Class[0])));
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    static HttpServletRequest createRequest(Principal userPrincipal, String ... roles) {
        HashSet roleSet = new HashSet();
        Collections.addAll(roleSet, roles);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)userPrincipal);
        Mockito.when((Object)request.isUserInRole(Mockito.anyString())).thenAnswer(query -> roleSet.contains(query.getArguments()[0]));
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(REQUEST_URL));
        return request;
    }

    private void verifyMethodAccessAllowed(Class<?> endpointClass, HttpServletRequest request, String ... expectedAccessibleMethods) throws Exception {
        List<String> expectedAnonList = Arrays.asList(expectedAccessibleMethods);
        for (String endpointMethod : ENDPOINT_METHODS) {
            boolean expectedResult = expectedAnonList.contains(endpointMethod);
            Method method = endpointClass.getMethod(endpointMethod, new Class[0]);
            Assert.assertEquals((String)("Expected " + endpointClass.getSimpleName() + "." + endpointMethod + " to " + (expectedResult ? "be" : "NOT to be") + " accessible"), (Object)expectedResult, (Object)this.accessAnnotationChecker.hasAccess(method, request));
        }
    }

    private void verifyClassAccessAllowed(Class<?> cls, HttpServletRequest request, boolean expectedResult) throws Exception {
        Assert.assertEquals((String)("Expected " + cls.getSimpleName() + " to " + (expectedResult ? "be" : "NOT to be") + " accessible"), (Object)expectedResult, (Object)this.accessAnnotationChecker.hasAccess(cls, request));
    }
}

