/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.Platform;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PlatformTest {
    private ClassLoader oldContextClassLoader;
    @Rule
    public TemporaryFolder temporary = new TemporaryFolder();

    @Before
    public void rememberContextClassLoader() {
        this.oldContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void restoreContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this.oldContextClassLoader);
    }

    @Before
    @After
    public void cleanMemoizedValues() {
        Platform.hillaVersion = null;
        Platform.vaadinVersion = null;
    }

    private void fakeVaadinHilla(String vaadinVersion, String hillaVersion) throws IOException {
        Path pomProperties;
        Platform.hillaVersion = null;
        Platform.vaadinVersion = null;
        LinkedList<URL> classPath = new LinkedList<URL>();
        if (hillaVersion != null) {
            Path hillaJar = this.temporary.newFolder().toPath();
            pomProperties = hillaJar.resolve("META-INF/maven/com.vaadin/hilla/pom.properties");
            Files.createDirectories(pomProperties.getParent(), new FileAttribute[0]);
            Files.writeString(pomProperties, (CharSequence)("version=" + hillaVersion), new OpenOption[0]);
            classPath.add(hillaJar.toUri().toURL());
        }
        if (vaadinVersion != null) {
            Path vaadinJar = this.temporary.newFolder().toPath();
            pomProperties = vaadinJar.resolve("META-INF/maven/com.vaadin/vaadin-core/pom.properties");
            Files.createDirectories(pomProperties.getParent(), new FileAttribute[0]);
            Files.writeString(pomProperties, (CharSequence)("version=" + vaadinVersion), new OpenOption[0]);
            classPath.add(vaadinJar.toUri().toURL());
        }
        if (classPath.isEmpty()) {
            Thread.currentThread().setContextClassLoader(this.oldContextClassLoader);
        } else {
            URLClassLoader classLoader = new URLClassLoader(classPath.toArray(new URL[0]), null);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Test
    public void testGetVaadinVersionReturnsEmptyOptionalWhenVaadinNotOnClasspath() {
        Assert.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
    }

    @Test
    public void testGetVaadinVersionReturnsProperVersionWhenVaadinOnClasspath() throws Exception {
        this.fakeVaadinHilla("24.1.0", null);
        Assert.assertEquals(Optional.of("24.1.0"), (Object)Platform.getVaadinVersion());
        Assert.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
        this.fakeVaadinHilla("24.1.1", null);
        Assert.assertEquals(Optional.of("24.1.1"), (Object)Platform.getVaadinVersion());
        Assert.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
    }

    @Test
    public void testGetHillaVersionReturnsEmptyOptionalWhenHillaNotOnClasspath() {
        Assert.assertEquals(Optional.empty(), (Object)Platform.getHillaVersion());
    }

    @Test
    public void testGetHillaVersionReturnsProperVersionWhenHillaOnClasspath() throws Exception {
        this.fakeVaadinHilla(null, "2.1.0");
        Assert.assertEquals(Optional.of("2.1.0"), (Object)Platform.getHillaVersion());
        Assert.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
        this.fakeVaadinHilla(null, "2.0.6");
        Assert.assertEquals(Optional.of("2.0.6"), (Object)Platform.getHillaVersion());
        Assert.assertEquals(Optional.empty(), (Object)Platform.getVaadinVersion());
    }

    @Test
    public void testGetVaadinHillaVersionReturnsProperVersionWhenBothVaadinAndHillaOnClasspath() throws Exception {
        this.fakeVaadinHilla("24.0.0", "2.1.0");
        Assert.assertEquals(Optional.of("2.1.0"), (Object)Platform.getHillaVersion());
        Assert.assertEquals(Optional.of("24.0.0"), (Object)Platform.getVaadinVersion());
        this.fakeVaadinHilla("24.1.1", "2.0.6");
        Assert.assertEquals(Optional.of("2.0.6"), (Object)Platform.getHillaVersion());
        Assert.assertEquals(Optional.of("24.1.1"), (Object)Platform.getVaadinVersion());
    }
}

