/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.I18NProviderTest;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.ResourceBundle;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;

@NotThreadSafe
public class DefaultInstantiatorI18NTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File translations;
    private ClassLoader urlClassLoader;

    @Before
    public void init() throws IOException, NoSuchFieldException, IllegalAccessException {
        File resources = this.temporaryFolder.newFolder();
        this.translations = new File(resources, "vaadin-i18n");
        this.translations.mkdirs();
        this.urlClassLoader = new URLClassLoader(new URL[]{resources.toURI().toURL()});
        I18NProviderTest.clearI18NProviderField();
    }

    @After
    public void cleanup() throws NoSuchFieldException, IllegalAccessException {
        ResourceBundle.clearCache(this.urlClassLoader);
        I18NProviderTest.clearI18NProviderField();
        VaadinService.setCurrent(null);
    }

    @Test
    public void translationFileOnClasspath_instantiateDefaultI18N() throws IOException {
        DefaultInstantiatorI18NTest.createTranslationFiles(this.translations);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        VaadinService.setCurrent((VaadinService)service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service){

            protected ClassLoader getClassLoader() {
                return DefaultInstantiatorI18NTest.this.urlClassLoader;
            }
        };
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)defaultInstantiator);
        I18NProvider i18NProvider = defaultInstantiator.getI18NProvider();
        Assert.assertNotNull((Object)i18NProvider);
        Assert.assertTrue((boolean)(i18NProvider instanceof DefaultI18NProvider));
        Assert.assertEquals((Object)"Suomi", (Object)i18NProvider.getTranslation("title", new Locale("fi", "FI"), new Object[0]));
        Assert.assertEquals((Object)"Suomi", (Object)I18NProvider.translate((Locale)new Locale("fi", "FI"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"deutsch", (Object)i18NProvider.getTranslation("title", new Locale("de"), new Object[0]));
        Assert.assertEquals((Object)"deutsch", (Object)I18NProvider.translate((Locale)new Locale("de"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((String)"non existing country should select language bundle", (Object)"deutsch", (Object)i18NProvider.getTranslation("title", new Locale("de", "AT"), new Object[0]));
        Assert.assertEquals((String)"non existing country should select language bundle", (Object)"deutsch", (Object)I18NProvider.translate((Locale)new Locale("de", "AT"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"Korean", (Object)i18NProvider.getTranslation("title", new Locale("ko", "KR"), new Object[0]));
        Assert.assertEquals((Object)"Korean", (Object)I18NProvider.translate((Locale)new Locale("ko", "KR"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)i18NProvider.getTranslation("title", new Locale("en", "GB"), new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)I18NProvider.translate((Locale)new Locale("en", "GB"), (String)"title", (Object[])new Object[0]));
    }

    @Test
    public void onlyDefaultTranslation_instantiateDefaultI18N() throws IOException {
        File file = new File(this.translations, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        VaadinService.setCurrent((VaadinService)service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service){

            protected ClassLoader getClassLoader() {
                return DefaultInstantiatorI18NTest.this.urlClassLoader;
            }
        };
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)defaultInstantiator);
        I18NProvider i18NProvider = defaultInstantiator.getI18NProvider();
        Assert.assertNotNull((Object)i18NProvider);
        Assert.assertTrue((boolean)(i18NProvider instanceof DefaultI18NProvider));
        Assert.assertEquals((Object)"Default lang", (Object)i18NProvider.getTranslation("title", new Locale("fi", "FI"), new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)I18NProvider.translate((Locale)new Locale("fi", "FI"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)i18NProvider.getTranslation("title", new Locale("de"), new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)I18NProvider.translate((Locale)new Locale("de"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)i18NProvider.getTranslation("title", new Locale("ko", "KR"), new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)I18NProvider.translate((Locale)new Locale("ko", "KR"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)i18NProvider.getTranslation("title", new Locale("en", "GB"), new Object[0]));
        Assert.assertEquals((Object)"Default lang", (Object)I18NProvider.translate((Locale)new Locale("en", "GB"), (String)"title", (Object[])new Object[0]));
    }

    @Test
    public void onlyLangTransalation_nonExistingLangReturnsKey() throws IOException {
        File file = new File(this.translations, "translations_ja.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=No Default", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        VaadinService.setCurrent((VaadinService)service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service){

            protected ClassLoader getClassLoader() {
                return DefaultInstantiatorI18NTest.this.urlClassLoader;
            }
        };
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)defaultInstantiator);
        I18NProvider i18NProvider = defaultInstantiator.getI18NProvider();
        Assert.assertNotNull((Object)i18NProvider);
        Assert.assertTrue((boolean)(i18NProvider instanceof DefaultI18NProvider));
        Assert.assertEquals((Object)"No Default", (Object)i18NProvider.getTranslation("title", new Locale("ja"), new Object[0]));
        Assert.assertEquals((Object)"No Default", (Object)I18NProvider.translate((Locale)new Locale("ja"), (String)"title", (Object[])new Object[0]));
        Assert.assertEquals((Object)"title", (Object)i18NProvider.getTranslation("title", new Locale("en", "GB"), new Object[0]));
        Assert.assertEquals((Object)"title", (Object)I18NProvider.translate((Locale)new Locale("en", "GB"), (String)"title", (Object[])new Object[0]));
    }

    @Test
    public void translate_withoutProvider_returnsKey() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinService.setCurrent((VaadinService)service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service);
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)defaultInstantiator);
        Assert.assertEquals((String)"Should return the key with !{}! to show no translation available", (Object)"!{foo.bar}!", (Object)I18NProvider.translate((String)"foo.bar", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void translationFilesOnClassPath_getI18NProvider_usesThreadContextClassLoader() throws IOException {
        DefaultInstantiatorI18NTest.createTranslationFiles(this.translations);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        VaadinService.setCurrent((VaadinService)service);
        DefaultInstantiator defaultInstantiator = new DefaultInstantiator(service);
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)defaultInstantiator);
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.urlClassLoader);
            try (MockedConstruction mockedConstruction = Mockito.mockConstruction(DefaultI18NProvider.class, (mock, context) -> {
                ClassLoader classLoaderArgument = (ClassLoader)context.arguments().get(1);
                Assert.assertEquals((Object)this.urlClassLoader, (Object)classLoaderArgument);
            });){
                I18NProvider i18NProvider = defaultInstantiator.getI18NProvider();
                Assert.assertNotNull((Object)i18NProvider);
                Assert.assertEquals((Object)i18NProvider, mockedConstruction.constructed().get(0));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContextClassLoader);
        }
    }

    private static void createTranslationFiles(File translationsFolder) throws IOException {
        File file = new File(translationsFolder, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(translationsFolder, "translations_ko_KR.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Korean", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(translationsFolder, "translations_fi_FI.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Suomi", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(translationsFolder, "translations_de.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=deutsch", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
    }

    private Lookup mockLookup(VaadinService service) {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        return lookup;
    }
}

