/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ColorScheme;
import org.junit.Assert;
import org.junit.Test;

public class ColorSchemeTest {
    @Test
    public void getValue_returnsCorrectValue() {
        Assert.assertEquals((Object)"light", (Object)ColorScheme.Value.LIGHT.getValue());
        Assert.assertEquals((Object)"dark", (Object)ColorScheme.Value.DARK.getValue());
        Assert.assertEquals((Object)"light dark", (Object)ColorScheme.Value.LIGHT_DARK.getValue());
        Assert.assertEquals((Object)"dark light", (Object)ColorScheme.Value.DARK_LIGHT.getValue());
        Assert.assertEquals((Object)"normal", (Object)ColorScheme.Value.NORMAL.getValue());
        Assert.assertEquals((Object)"light dark", (Object)ColorScheme.Value.SYSTEM.getValue());
    }

    @Test
    public void getThemeValue_singleValue_returnsUnchanged() {
        Assert.assertEquals((Object)"light", (Object)ColorScheme.Value.LIGHT.getThemeValue());
        Assert.assertEquals((Object)"dark", (Object)ColorScheme.Value.DARK.getThemeValue());
        Assert.assertEquals((Object)"normal", (Object)ColorScheme.Value.NORMAL.getThemeValue());
    }

    @Test
    public void getThemeValue_multiValue_replacesSpaceWithHyphen() {
        Assert.assertEquals((Object)"light-dark", (Object)ColorScheme.Value.LIGHT_DARK.getThemeValue());
        Assert.assertEquals((Object)"dark-light", (Object)ColorScheme.Value.DARK_LIGHT.getThemeValue());
        Assert.assertEquals((Object)"light-dark", (Object)ColorScheme.Value.SYSTEM.getThemeValue());
    }

    @Test
    public void fromString_validValues_returnsCorrectEnum() {
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)ColorScheme.Value.fromString((String)"light"));
        Assert.assertEquals((Object)ColorScheme.Value.DARK, (Object)ColorScheme.Value.fromString((String)"dark"));
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT_DARK, (Object)ColorScheme.Value.fromString((String)"light dark"));
        Assert.assertEquals((Object)ColorScheme.Value.DARK_LIGHT, (Object)ColorScheme.Value.fromString((String)"dark light"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"normal"));
    }

    @Test
    public void fromString_nullOrEmpty_returnsNormal() {
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString(null));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)""));
    }

    @Test
    public void fromString_unrecognizedValue_returnsNormal() {
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"invalid"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"light-dark"));
    }

    @Test
    public void fromString_lightDark_returnsLightDarkNotSystem() {
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT_DARK, (Object)ColorScheme.Value.fromString((String)"light dark"));
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT_DARK.getValue(), (Object)ColorScheme.Value.SYSTEM.getValue());
    }
}

