/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import org.junit.Assert;
import org.junit.Test;

public class HasEnabledTest {
    @Test
    public void enabledComponent_isEnabledReturnsTrue() {
        TestComponent component = new TestComponent();
        Assert.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void explicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        component.setEnabled(false);
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void implicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        TestComponent parent = new TestComponent();
        parent.setEnabled(false);
        parent.add(new Component[]{component});
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void implicitlyDisabledComponent_detach_componentBecomesEnabled() {
        TestComponent component = new TestComponent();
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        parent.setEnabled(false);
        parent.remove(new Component[]{component});
        Assert.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void explicitlyDisabledComponent_enableParent_componentRemainsDisabled() {
        TestComponent component = new TestComponent();
        component.setEnabled(false);
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        parent.setEnabled(false);
        Assert.assertFalse((boolean)component.isEnabled());
        parent.setEnabled(true);
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        private TestComponent() {
        }
    }
}

