/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractSinglePropertyFieldTest;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class AbstractCompositeFieldTest {
    @Test
    public void reverseCaseField() {
        ReverseCaseField outerField = new ReverseCaseField();
        AbstractSinglePropertyFieldTest.StringField innerField = (AbstractSinglePropertyFieldTest.StringField)outerField.getContent();
        outerField.setValue("Hello");
        Assert.assertEquals((Object)"hELLO", (Object)innerField.getValue());
        innerField.setValue("wORLD");
        Assert.assertEquals((Object)"World", (Object)outerField.getValue());
    }

    @Test
    public void emptyValueEquals() {
        ReverseCaseField field = new ReverseCaseField();
        Assert.assertTrue((boolean)field.isEmpty());
        field.setValue("a");
        Assert.assertFalse((boolean)field.isEmpty());
        field.setValue(" ");
        Assert.assertTrue((boolean)field.isEmpty());
    }

    @Test
    public void multipleFieldsField() {
        MultipleFieldsField field = new MultipleFieldsField();
        field.setValue("Hello Cool World");
        Assert.assertEquals((Object)"Hello", (Object)field.start.getValue());
        Assert.assertEquals((Object)"Cool World", (Object)field.rest.getValue());
        field.rest.setValue("");
        Assert.assertEquals((Object)"Hello", (Object)field.getValue());
        field.rest.setValue("Vaadin");
        Assert.assertEquals((Object)"Hello Vaadin", (Object)field.getValue());
    }

    @Test
    public void serializable() {
        ReverseCaseField field = new ReverseCaseField();
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ignore -> {});
        field.setValue("foo");
        ReverseCaseField anotherField = (ReverseCaseField)((Object)SerializationUtils.roundtrip((Serializable)((Object)field)));
        Assert.assertEquals((Object)"foo", (Object)anotherField.getValue());
    }

    private static class ReverseCaseField
    extends AbstractCompositeField<AbstractSinglePropertyFieldTest.StringField, ReverseCaseField, String> {
        public ReverseCaseField() {
            super((Object)"");
            ((AbstractSinglePropertyFieldTest.StringField)this.getContent()).addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.setModelValue(ReverseCaseField.reverseCase((String)event.getValue()), event.isFromClient()));
        }

        protected void setPresentationValue(String newPresentationValue) {
            ((AbstractSinglePropertyFieldTest.StringField)this.getContent()).setValue(ReverseCaseField.reverseCase(newPresentationValue));
        }

        protected boolean valueEquals(String value1, String value2) {
            if (value1 != null && value2 != null) {
                return value1.trim().equals(value2.trim());
            }
            return value1 == value2;
        }

        private static String reverseCase(String input) {
            int[] reversedCodePoints = input.codePoints().map(c -> {
                if (Character.isUpperCase(c)) {
                    return Character.toLowerCase(c);
                }
                if (Character.isLowerCase(c)) {
                    return Character.toUpperCase(c);
                }
                return c;
            }).toArray();
            return new String(reversedCodePoints, 0, reversedCodePoints.length);
        }
    }

    private static class MultipleFieldsField
    extends AbstractCompositeField<ComponentTest.TestDiv, MultipleFieldsField, String> {
        private AbstractSinglePropertyFieldTest.StringField start = new AbstractSinglePropertyFieldTest.StringField();
        private AbstractSinglePropertyFieldTest.StringField rest = new AbstractSinglePropertyFieldTest.StringField();

        public MultipleFieldsField() {
            super(null);
            ((ComponentTest.TestDiv)this.getContent()).getElement().appendChild(new Element[]{this.start.getElement(), this.rest.getElement()});
            this.start.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue(event.isFromClient()));
            this.rest.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue(event.isFromClient()));
        }

        private void updateValue(boolean fromClient) {
            Object value = (String)this.start.getValue();
            String restValue = (String)this.rest.getValue();
            if (!restValue.isEmpty()) {
                value = (String)value + " " + restValue;
            }
            this.setModelValue(value, fromClient);
        }

        protected void setPresentationValue(String newPresentationValue) {
            String[] parts = newPresentationValue.split(" ", 2);
            this.start.setValue(parts[0]);
            if (parts.length > 1) {
                this.rest.setValue(parts[1]);
            } else {
                this.rest.setValue("");
            }
        }
    }
}

