/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class SplitPackagesTest {
    private static final Set<String> ignoredModules = new HashSet<String>(Arrays.asList("demo-flow-components", "flow-tests", "flow-test-generic", "flow-code-generator", "flow-generated-components", "flow-dev-bundle-plugin"));

    @Test
    public void findSplitPackages() throws IOException {
        Collection<File> modules = this.findModules();
        Map<String, Set<File>> packageToModules = this.mapPackagesToModules(modules);
        String errors = this.collectErrors(packageToModules);
        if (!errors.isEmpty()) {
            Assert.fail((String)errors);
        }
    }

    private String collectErrors(Map<String, Set<File>> packages) {
        return packages.entrySet().stream().flatMap(entry -> this.getErrors((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.joining("\n"));
    }

    private Stream<? extends String> getErrors(String pck, Set<File> modules) {
        if (modules.size() != 1) {
            return Stream.of(pck + " contains classes from multiple modules: " + String.valueOf(modules));
        }
        return Stream.empty();
    }

    private Map<String, Set<File>> mapPackagesToModules(Collection<File> modules) {
        HashMap<String, Set<File>> packageToModules = new HashMap<String, Set<File>>();
        for (File module : modules) {
            File srcDir = new File(module, "src/main/java");
            if (!srcDir.exists()) continue;
            HashSet<String> packages = new HashSet<String>();
            this.collectPackages("", srcDir, packages);
            for (String pck : packages) {
                packageToModules.computeIfAbsent(pck, key -> new HashSet()).add(module);
            }
        }
        return packageToModules;
    }

    private void collectPackages(String packageName, File dir, Set<String> packages) {
        boolean containsJavaFile = false;
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                String childPackageName = packageName + "." + child.getName();
                this.collectPackages(childPackageName, child, packages);
                continue;
            }
            containsJavaFile |= child.getName().endsWith(".java");
        }
        if (containsJavaFile) {
            if (!packageName.isEmpty()) {
                packageName = packageName.substring(1);
            }
            packages.add(packageName);
        }
    }

    private Collection<File> findModules() throws IOException {
        ArrayList<File> modules = new ArrayList<File>();
        this.collectModules(new File(".."), modules);
        return modules;
    }

    private void collectModules(File dir, Collection<File> modules) {
        if (ignoredModules.contains(dir.getName())) {
            return;
        }
        if (new File(dir, "pom.xml").exists()) {
            modules.add(dir);
            for (File child : dir.listFiles()) {
                if (!child.isDirectory()) continue;
                this.collectModules(child, modules);
            }
        }
    }
}

