/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.change.NodeDetachChange;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StateNodeTest {
    @Test
    public void newNodeState() {
        StateNode node = StateNodeTest.createEmptyNode();
        NodeOwner owner = node.getOwner();
        Assert.assertNotNull((String)"New node should have an owner", (Object)owner);
        Assert.assertEquals((String)"New node shold have unassigned id", (long)-1L, (long)node.getId());
        Assert.assertFalse((String)"Node should not be attached", (boolean)node.isAttached());
    }

    @Test
    public void nodeContainsDefinedFeatures() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        Assert.assertTrue((String)"Should have feature defined in constructor", (boolean)node.hasFeature(ElementData.class));
        ElementData feature = (ElementData)node.getFeature(ElementData.class);
        Assert.assertNotNull((String)"Existing feature should also be available", (Object)feature);
        Assert.assertFalse((String)"Should not have a feature that wasn't defined in constructor", (boolean)node.hasFeature(ElementPropertyMap.class));
    }

    @Test(expected=IllegalStateException.class)
    public void getMissingFeatureThrows() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        node.getFeature(ElementPropertyMap.class);
    }

    @Test
    public void attachDetachChangeCollection() {
        StateNode node = StateNodeTest.createEmptyNode();
        ArrayList changes = new ArrayList();
        Consumer<NodeChange> collector = changes::add;
        node.collectChanges(collector);
        Assert.assertTrue((String)"Node should have no changes", (boolean)changes.isEmpty());
        StateNodeTest.setParent(node, this.createStateTree().getRootNode());
        node.collectChanges(collector);
        Assert.assertEquals((String)"Should have 1 change", (long)1L, (long)changes.size());
        Assert.assertTrue((String)"Should have attach change", (boolean)(changes.get(0) instanceof NodeAttachChange));
        changes.clear();
        node.collectChanges(collector);
        Assert.assertTrue((String)"Node should have no changes", (boolean)changes.isEmpty());
        StateNodeTest.setParent(node, null);
        node.collectChanges(collector);
        Assert.assertEquals((String)"Should have 1 change", (long)1L, (long)changes.size());
        Assert.assertTrue((String)"Should have detach change", (boolean)(changes.get(0) instanceof NodeDetachChange));
        changes.clear();
    }

    @Test
    public void appendChildBeforeParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNode grandchild = StateNodeTest.createEmptyNode("grandchild");
        StateNode root = this.createStateTree().getRootNode();
        StateNodeTest.setParent(grandchild, child);
        StateNodeTest.setParent(child, parent);
        StateNodeTest.setParent(parent, root);
        Assert.assertNotEquals((long)-1L, (long)parent.getId());
        Assert.assertNotEquals((long)-1L, (long)child.getId());
        Assert.assertNotEquals((long)-1L, (long)grandchild.getId());
    }

    @Test
    public void appendParentBeforeChild() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNode grandchild = StateNodeTest.createEmptyNode("grandchild");
        StateNode root = this.createStateTree().getRootNode();
        StateNodeTest.setParent(parent, root);
        StateNodeTest.setParent(child, parent);
        StateNodeTest.setParent(grandchild, child);
        Assert.assertNotEquals((long)-1L, (long)parent.getId());
        Assert.assertNotEquals((long)-1L, (long)child.getId());
        Assert.assertNotEquals((long)-1L, (long)grandchild.getId());
    }

    @Test(expected=IllegalStateException.class)
    public void setChildAsParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNodeTest.setParent(child, parent);
        StateNodeTest.setParent(parent, child);
    }

    @Test(expected=IllegalStateException.class)
    public void setAsOwnParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNodeTest.setParent(parent, parent);
    }

    @Test
    public void recursiveTreeNavigation_resilienceInDepth() {
        TestStateNode childOfRoot = new TestStateNode();
        TestStateNode node = this.createTree(childOfRoot, 3000);
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(childOfRoot, tree.getRootNode());
        Set set = IntStream.range(-1, node.getData() + 1).boxed().collect(Collectors.toSet());
        childOfRoot.visitNodeTree(n -> this.visit((TestStateNode)((Object)n), tree, set));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void recursiveTreeNavigation_resilienceInSize() {
        TestStateNode childOfRoot = new TestStateNode();
        int count = 300;
        TestStateNode node = this.createTree(childOfRoot, count);
        while (node.getParent() != null) {
            node = node.getParent();
            for (int i = 1; i < 50; ++i) {
                TestStateNode child = new TestStateNode();
                StateNodeTest.setParent(child, node);
                child.setData(count);
                ++count;
            }
        }
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(childOfRoot, tree.getRootNode());
        Set set = IntStream.range(-1, count).boxed().collect(Collectors.toSet());
        childOfRoot.visitNodeTree(n -> this.visit((TestStateNode)((Object)n), (StateTree)childOfRoot.getOwner(), set));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void nodeTreeOnAttach_bottomUpTraversing_correctOrder() {
        TestStateNode root = new TestStateNode();
        LinkedList<Integer> data = new LinkedList<Integer>();
        data.add(0);
        root.setData(0);
        int count = 1;
        for (int i = 0; i < 5; ++i) {
            TestStateNode childOfRoot = new TestStateNode();
            childOfRoot.setData(count);
            data.add(count);
            if (i % 2 == 0) {
                for (int j = 0; j < 5; ++j) {
                    TestStateNode child = new TestStateNode();
                    StateNodeTest.setParent(child, childOfRoot);
                    child.setData(count);
                    data.add(count);
                    ++count;
                }
            }
            StateNodeTest.setParent(childOfRoot, root);
        }
        root.visitNodeTreeBottomUp(node -> Assert.assertEquals((Object)((TestStateNode)((Object)node)).getData(), data.removeLast()));
    }

    @Test
    public void nodeTreeOnAttach_bottomUpTraversing_brokenParentInChildDoesNotEndInLoop() throws NoSuchFieldException, IllegalAccessException {
        TestStateNode root = new TestStateNode();
        root.setData(0);
        ArrayList count = new ArrayList();
        Field parent = StateNode.class.getDeclaredField("parent");
        parent.setAccessible(true);
        TestStateNode childOfRoot = new TestStateNode();
        childOfRoot.setData(1);
        TestStateNode child = new TestStateNode();
        child.setData(2);
        StateNodeTest.setParent(child, childOfRoot);
        parent.set((Object)child, null);
        StateNodeTest.setParent(childOfRoot, root);
        root.visitNodeTreeBottomUp(node -> count.add(1));
        Assert.assertEquals((String)"Each node should be visited once", (long)3L, (long)count.size());
    }

    @Test
    public void attachListener_onSetParent_listenerTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        Assert.assertFalse((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addAttachListener((Command & Serializable)() -> triggered.set(true));
        StateNodeTest.setParent(child, root);
        Assert.assertTrue((boolean)triggered.get());
    }

    @Test
    public void attachListener_listenerRemoved_listenerNotTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        Assert.assertFalse((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        Registration registrationHandle = child.addAttachListener((Command & Serializable)() -> triggered.set(true));
        registrationHandle.remove();
        StateNodeTest.setParent(child, root);
        Assert.assertFalse((boolean)triggered.get());
    }

    @Test
    public void detachListener_onSetParent_listenerTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assert.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addDetachListener((Command & Serializable)() -> triggered.set(true));
        StateNodeTest.setParent(child, null);
        Assert.assertTrue((String)"Detach listener was not triggered.", (boolean)triggered.get());
    }

    @Test
    public void detachListener_listenerRemoved_listenerNotTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assert.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        Registration registrationHandle = child.addDetachListener((Command & Serializable)() -> triggered.set(true));
        registrationHandle.remove();
        StateNodeTest.setParent(child, null);
        Assert.assertFalse((String)"Detach listener was triggered even though handler was removed.", (boolean)triggered.get());
    }

    @Test
    public void detachListener_removesNode_notUnregisteredTwice() {
        StateTree tree = this.createStateTree();
        StateNode root = StateNodeTest.createParentNode("");
        StateNodeTest.setParent(root, tree.getRootNode());
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assert.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addDetachListener((Command & Serializable)() -> {
            Assert.assertTrue((String)"Child node should still have a parent and be been seen as attached", (boolean)child.isAttached());
            Assert.assertFalse((String)"Child node should have been unregistered", (boolean)tree.hasNode((StateNode)child));
            child.setParent(null);
            Assert.assertTrue((String)"Child's parent should be null", (child.getParent() == null ? 1 : 0) != 0);
            triggered.set(true);
        });
        StateNodeTest.setParent(child, null);
        Assert.assertTrue((String)"Detach listener was not triggered.", (boolean)triggered.get());
    }

    public static StateNode createEmptyNode() {
        return StateNodeTest.createEmptyNode("Empty node");
    }

    public static StateNode createEmptyNode(String toString) {
        return StateNodeTest.createTestNode(toString, new Class[0]);
    }

    public static StateNode createParentNode(String toString) {
        return StateNodeTest.createTestNode(toString, ElementChildrenList.class);
    }

    @SafeVarargs
    public static StateNode createTestNode(final String toString, Class<? extends NodeFeature> ... features) {
        return new StateNode(features){

            public String toString() {
                if (toString != null) {
                    return toString;
                }
                return super.toString();
            }

            public boolean hasFeature(Class<? extends NodeFeature> featureType) {
                if (featureType.isAssignableFrom(ElementData.class)) {
                    return false;
                }
                return super.hasFeature(featureType);
            }
        };
    }

    public static void setParent(StateNode child, StateNode parent) {
        if (parent == null) {
            parent = child.getParent();
            ElementChildrenList children = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            children.remove(children.indexOf(child));
        } else {
            assert (child.getParent() == null);
            ElementChildrenList children = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            children.add(children.size(), child);
        }
    }

    private TestStateNode createTree(TestStateNode root, int depth) {
        TestStateNode node = root;
        for (int i = 0; i < depth; ++i) {
            TestStateNode child = new TestStateNode();
            child.setData(i);
            ((ElementChildrenList)node.getFeature(ElementChildrenList.class)).add(0, (StateNode)child);
            node = child;
        }
        return node;
    }

    private void visit(TestStateNode node, StateTree tree, Set<Integer> set) {
        Assert.assertEquals((Object)tree, (Object)node.getOwner());
        set.remove(node.getData());
    }

    private StateTree createStateTree() {
        StateTree stateTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        return stateTree;
    }

    @Test
    public void runWhenAttachedNodeNotAttached() {
        StateTree tree = this.createStateTree();
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assert.assertEquals((long)0L, (long)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assert.assertEquals((long)1L, (long)commandRun.get());
        StateNodeTest.setParent(node, null);
        StateNodeTest.setParent(node, tree.getRootNode());
        Assert.assertEquals((long)1L, (long)commandRun.get());
    }

    @Test
    public void runMultipleWhenAttachedNodeNotAttached() {
        StateTree tree = this.createStateTree();
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assert.assertEquals((long)0L, (long)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assert.assertEquals((long)2L, (long)commandRun.get());
    }

    @Test
    public void runWhenAttachedNodeAttached() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(node, tree.getRootNode());
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assert.assertEquals((long)1L, (long)commandRun.get());
    }

    @Test
    public void runWhenAttached_detachingNode_schedulesCommandOnAttach() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(node, tree.getRootNode());
        node.addDetachListener((Command & Serializable)() -> node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        }));
        StateNodeTest.setParent(node, null);
        Assert.assertEquals((long)0L, (long)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assert.assertEquals((long)1L, (long)commandRun.get());
    }

    @Test
    public void runWhenAttached_detachingNode_childNodeSchedulesCommandOnAttach() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode parent = StateNodeTest.createParentNode("PARENT");
        StateNode child = StateNodeTest.createEmptyNode("CHILD");
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(parent, tree.getRootNode());
        StateNodeTest.setParent(child, parent);
        child.addDetachListener((Command & Serializable)() -> child.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assert.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        }));
        StateNodeTest.setParent(parent, null);
        Assert.assertEquals((long)0L, (long)commandRun.get());
        StateNodeTest.setParent(parent, tree.getRootNode());
        Assert.assertEquals((long)1L, (long)commandRun.get());
    }

    @Test
    public void requiredFeatures() {
        StateNode stateNode = new StateNode(Arrays.asList(ElementClassList.class, ElementPropertyMap.class), new Class[]{ElementAttributeMap.class});
        Assert.assertTrue((boolean)stateNode.hasFeature(ElementClassList.class));
        Assert.assertTrue((boolean)stateNode.hasFeature(ElementPropertyMap.class));
        Assert.assertTrue((boolean)stateNode.hasFeature(ElementAttributeMap.class));
        Assert.assertTrue((boolean)stateNode.isReportedFeature(ElementClassList.class));
        Assert.assertTrue((boolean)stateNode.isReportedFeature(ElementPropertyMap.class));
        Assert.assertFalse((boolean)stateNode.isReportedFeature(ElementAttributeMap.class));
    }

    @Test
    public void collectChanges_initiallyActiveElement_sendOnlyDisalowFeatureChangesWhenInactive() {
        StateNode stateNode = StateNodeTest.createTestNode("Active node", ElementPropertyMap.class, ElementData.class);
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, stateNode);
        this.assertCollectChanges_initiallyVisible(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            stateNode.updateActiveState();
        });
    }

    @Test
    public void collectChanges_inertElement_inertChangesCollected() {
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementChildrenList.class, InertData.class);
        StateNode child = StateNodeTest.createTestNode("Child node", ElementChildrenList.class, InertData.class);
        StateNode grandchild = StateNodeTest.createTestNode("Grandchild node", InertData.class);
        ((ElementChildrenList)new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class}).getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, child);
        ((ElementChildrenList)child.getFeature(ElementChildrenList.class)).add(0, grandchild);
        Assert.assertFalse((boolean)parent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)grandchild.isInert());
        ((InertData)parent.getFeature(InertData.class)).setInertSelf(true);
        Assert.assertFalse((boolean)parent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assert.assertTrue((boolean)parent.isInert());
        Assert.assertTrue((boolean)child.isInert());
        Assert.assertTrue((boolean)grandchild.isInert());
        ((InertData)child.getFeature(InertData.class)).setIgnoreParentInert(true);
        Assert.assertTrue((boolean)parent.isInert());
        Assert.assertTrue((boolean)child.isInert());
        Assert.assertTrue((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assert.assertTrue((boolean)parent.isInert());
        Assert.assertTrue((boolean)child.isInert());
        Assert.assertTrue((boolean)grandchild.isInert());
        child.collectChanges(nodeChange -> {});
        Assert.assertTrue((boolean)parent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)grandchild.isInert());
        ((InertData)parent.getFeature(InertData.class)).setInertSelf(false);
        ((InertData)child.getFeature(InertData.class)).setIgnoreParentInert(false);
        Assert.assertTrue((boolean)parent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assert.assertFalse((boolean)parent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)grandchild.isInert());
    }

    @Test
    public void collectChanges_inertChildMoved_inertStateInherited() {
        StateNode inertParent = StateNodeTest.createTestNode("Inert parent", ElementChildrenList.class, InertData.class);
        StateNode child = StateNodeTest.createTestNode("Child", InertData.class);
        StateNode parent = StateNodeTest.createTestNode("Non-inert parent", ElementChildrenList.class, InertData.class);
        ElementChildrenList feature = (ElementChildrenList)new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class}).getRootNode().getFeature(ElementChildrenList.class);
        feature.add(0, parent);
        feature.add(1, inertParent);
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).add(0, child);
        ((InertData)inertParent.getFeature(InertData.class)).setInertSelf(true);
        inertParent.collectChanges(node -> {});
        Assert.assertTrue((boolean)inertParent.isInert());
        Assert.assertTrue((boolean)child.isInert());
        Assert.assertFalse((boolean)parent.isInert());
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).remove(0);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, child);
        Assert.assertTrue((boolean)inertParent.isInert());
        Assert.assertFalse((boolean)child.isInert());
        Assert.assertFalse((boolean)parent.isInert());
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).remove(0);
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).add(0, child);
        Assert.assertTrue((boolean)inertParent.isInert());
        Assert.assertTrue((boolean)child.isInert());
        Assert.assertFalse((boolean)parent.isInert());
    }

    @Test
    public void collectChanges_inactivateViaParent_initiallyActiveElement_sendOnlyDisalowFeatureChangesWhenInactive() {
        StateNode stateNode = StateNodeTest.createTestNode("Active node", ElementPropertyMap.class, ElementData.class);
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementPropertyMap.class, ElementData.class, ElementChildrenList.class);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        ElementData visibility = (ElementData)parent.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        this.assertCollectChanges_initiallyVisible(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            parent.updateActiveState();
        });
    }

    @Test
    public void collectChanges_initiallyInactiveElement_sendOnlyDisalowAndReportedFeatures_sendAllChangesWhenActive() {
        Element element = ElementFactory.createAnchor();
        StateNode stateNode = element.getNode();
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, stateNode);
        this.assertCollectChanges_initiallyInactive(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            stateNode.updateActiveState();
        });
    }

    @Test
    public void collectChanges_initiallyInactiveViaParentElement_sendOnlyDisalowAndReportedFeatures_sendAllChangesWhenActive() {
        Element element = ElementFactory.createAnchor();
        StateNode stateNode = element.getNode();
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementPropertyMap.class, ElementData.class, ElementChildrenList.class);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        ElementData visibility = (ElementData)parent.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        this.assertCollectChanges_initiallyInactive(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            parent.updateActiveState();
        });
    }

    @Test
    public void recursiveAndStandAloneVisibility() {
        StateNode parentNode = new StateNode(new Class[]{ElementPropertyMap.class, ElementData.class, ElementChildrenList.class});
        StateNode childNode = new StateNode(new Class[]{ElementPropertyMap.class, ElementData.class});
        ((ElementChildrenList)parentNode.getFeature(ElementChildrenList.class)).add(0, childNode);
        Assert.assertTrue((boolean)childNode.isVisible());
        ((ElementData)childNode.getFeature(ElementData.class)).setVisible(false);
        Assert.assertFalse((boolean)childNode.isVisible());
        ((ElementData)childNode.getFeature(ElementData.class)).setVisible(true);
        Assert.assertTrue((boolean)parentNode.isVisible());
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(false);
        Assert.assertFalse((boolean)parentNode.isVisible());
        Assert.assertFalse((boolean)childNode.isVisible());
    }

    @Test
    public void invisibleNodeNoExtraChanges() {
        Element element = ElementFactory.createAnchor();
        StateNode node = element.getNode();
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        ArrayList changes = new ArrayList();
        ((ElementPropertyMap)node.getFeature(ElementPropertyMap.class)).setProperty("foo", (Serializable)((Object)"bar"));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof NodeAttachChange).count());
        Assert.assertEquals((long)2L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        List changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assert.assertTrue((boolean)changedMapKeys.contains("visible"));
        Assert.assertTrue((boolean)changedMapKeys.contains("tag"));
        changes.clear();
        ((ElementData)node.getFeature(ElementData.class)).setVisible(true);
        node.collectChanges(changes::add);
        Assert.assertEquals((long)2L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assert.assertTrue((boolean)changedMapKeys.contains("visible"));
        Assert.assertTrue((boolean)changedMapKeys.contains("foo"));
    }

    @Test
    public void invisibleParentNodeNoExtraChanges() {
        Element parentElement = ElementFactory.createDiv();
        StateNode parentNode = parentElement.getNode();
        Element childElement = ElementFactory.createAnchor();
        StateNode childNode = childElement.getNode();
        ((ElementChildrenList)parentNode.getFeature(ElementChildrenList.class)).add(0, childNode);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parentNode);
        ArrayList changes = new ArrayList();
        ((ElementPropertyMap)childNode.getFeature(ElementPropertyMap.class)).setProperty("foo", (Serializable)((Object)"bar"));
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(false);
        childNode.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof NodeAttachChange).count());
        Assert.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        List changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assert.assertTrue((boolean)changedMapKeys.contains("tag"));
        changes.clear();
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(true);
        childNode.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assert.assertTrue((boolean)changedMapKeys.contains("foo"));
    }

    @Test
    public void modifyNodeTreeInAttachListener_firstAsParent_lastAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "a", "c", false);
    }

    @Test
    public void modifyNodeTreeInAttachListener_lastAsParent_firstAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "c", "a", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_middleAsParent_firstAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "b", "a", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_firstAsParent_middleAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "a", "b", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_middleAsParent_lastAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "b", "c", false);
    }

    @Test
    public void modifyNodeTreeInAttachListener_lastAsParent_middleAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "c", "b", false);
    }

    @Test
    public void detachParent_detachFirstChildOnDetachLast_oneDetachEvent() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger detachEvents = new AtomicInteger();
        childB.addDetachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childA.addDetachListener((Command & Serializable)() -> detachEvents.incrementAndGet());
        this.removeFromParent(parent);
        Assert.assertEquals((long)1L, (long)detachEvents.get());
    }

    @Test
    public void detachParent_detachLastChildOnDetachFirst_oneDetachEvent() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger detachEvents = new AtomicInteger();
        childA.addDetachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childB.addDetachListener((Command & Serializable)() -> detachEvents.incrementAndGet());
        this.removeFromParent(parent);
        Assert.assertEquals((long)1L, (long)detachEvents.get());
    }

    @Test
    public void detachParent_appendChildOnDetach_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger events = new AtomicInteger();
        childA.addDetachListener((Command & Serializable)() -> {
            StateNode b = StateNodeTest.createEmptyNode("b");
            b.addAttachListener(events::incrementAndGet);
            b.addDetachListener(events::incrementAndGet);
            this.addChild(parent, b);
        });
        this.removeFromParent(parent);
        Assert.assertEquals((long)0L, (long)events.get());
    }

    @Test
    public void detachParent_insertChildAsFirstOnDetach_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode child = StateNodeTest.createEmptyNode("a");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, child);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger events = new AtomicInteger();
        child.addDetachListener((Command & Serializable)() -> {
            StateNode b = StateNodeTest.createEmptyNode("b");
            b.addAttachListener(events::incrementAndGet);
            b.addDetachListener(events::incrementAndGet);
            ElementChildrenList list = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            list.add(0, b);
        });
        this.removeFromParent(parent);
        Assert.assertEquals((long)0L, (long)events.get());
    }

    @Test
    public void attachParent_detachFirstOnAttachLast_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        AtomicInteger events = new AtomicInteger();
        childB.addAttachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childA.addAttachListener(events::incrementAndGet);
        childA.addDetachListener(events::incrementAndGet);
        this.addChild(tree.getRootNode(), parent);
        Assert.assertEquals((long)0L, (long)events.get());
    }

    @Test
    public void attachParent_detachLastOnAttachFirst_attachDetachEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        childA.addAttachListener((Command & Serializable)() -> this.removeFromParent(childB));
        ArrayList attachDetachEvents = new ArrayList();
        childB.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(true));
        childB.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        this.addChild(tree.getRootNode(), parent);
        Assert.assertEquals((long)2L, (long)attachDetachEvents.size());
        Assert.assertTrue((boolean)((Boolean)attachDetachEvents.get(0)));
        Assert.assertFalse((boolean)((Boolean)attachDetachEvents.get(1)));
    }

    @Test
    public void modifyNodeTreeInDetachListener_firstAsParent_lastAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "a", "c");
    }

    @Test
    public void modifyNodeTreeInDetachListener_lastAsParent_firstAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "c", "a");
    }

    @Test
    public void modifyNodeTreeInDetachListener_middleAsParent_firstAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "b", "a");
    }

    @Test
    public void modifyNodeTreeInDetachListener_firstAsParent_middleAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "a", "b");
    }

    @Test
    public void modifyNodeTreeInDetachListener_middleAsParent_lastAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "b", "c");
    }

    @Test
    public void modifyNodeTreeInDetachListener_lastAsParent_middleAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "c", "b");
    }

    @Test
    public void removeFromTree_nodeAttached_detachedAndDescendantsReset() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        StateNode child = StateNodeTest.createEmptyNode("child");
        this.addChild(parent, child);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.removeFromTree();
        Assert.assertNull((Object)parent.getParent());
        this.assertNodesReset(parent, child);
    }

    @Test
    public void removeFromTree_nodeAttachedThenDetached_detachEventCollected() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.collectChanges(change -> Assert.assertTrue((String)"Expected attach event for node", (boolean)(change instanceof NodeAttachChange)));
        parent.removeFromTree(true);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNotEquals((long)parent.getId(), (long)-1L);
        parent.collectChanges(change -> Assert.assertTrue((String)"Expected detach event for reset node", (boolean)(change instanceof NodeDetachChange)));
    }

    @Test
    public void removeFromTree_nodeAttached_detachedFullReset_noDetachEventCollected() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.collectChanges(change -> Assert.assertTrue((String)"Expected attach event for node", (boolean)(change instanceof NodeAttachChange)));
        parent.removeFromTree();
        Assert.assertNull((Object)parent.getParent());
        Assert.assertEquals((long)parent.getId(), (long)-1L);
        parent.collectChanges(change -> Assert.fail((String)"No changes should be collected for detached reset node."));
    }

    @Test
    public void removeFromTree_nodeAttachedAndInDetachListener_detachedAndDescendantsReset() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        StateNode child = StateNodeTest.createEmptyNode("child");
        this.addChild(parent, child);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.addDetachListener((Command & Serializable)() -> parent.removeFromTree());
        parent.setParent(null);
        this.assertNodesReset(parent, child);
    }

    @Test
    public void removeFromTree_closeUI_allowsToSetANewTree() {
        UI ui = new UI();
        final AtomicBoolean isRootAttached = new AtomicBoolean();
        isRootAttached.set(true);
        final StateNode root = new StateNode(new Class[]{ElementChildrenList.class}){

            public boolean isAttached() {
                return isRootAttached.get();
            }
        };
        StateTree stateTree = new StateTree(ui.getInternals(), new Class[]{ElementChildrenList.class}){

            public StateNode getRootNode() {
                return root;
            }

            public boolean hasNode(StateNode node) {
                if (this.getRootNode().equals(node)) {
                    return true;
                }
                return super.hasNode(node);
            }
        };
        root.setTree(stateTree);
        StateNode child = StateNodeTest.createEmptyNode("child");
        StateNode anotherChild = StateNodeTest.createEmptyNode("anotherChild");
        this.addChild(root, child);
        this.addChild(root, anotherChild);
        this.removeFromParent(anotherChild);
        Assert.assertNotEquals((long)-1L, (long)anotherChild.getId());
        child.removeFromTree();
        isRootAttached.set(false);
        anotherChild.setTree((StateTree)new TestStateTree());
        Assert.assertEquals((long)-1L, (long)anotherChild.getId());
    }

    private void assertNodesReset(StateNode ... nodes) {
        for (StateNode node : nodes) {
            Assert.assertEquals((long)-1L, (long)node.getId());
            Assert.assertFalse((boolean)node.isAttached());
            Assert.assertEquals((Object)NullOwner.get(), (Object)node.getOwner());
            node.collectChanges(c -> Assert.fail((String)"No changes expected"));
        }
    }

    private void assertAttachDetachEvents(Map<String, StateNode> nodes, String newParent, String child, boolean expectSingleEvent) {
        TestStateTree tree = new TestStateTree();
        StateNode childA = nodes.get("a");
        StateNode childB = nodes.get("b");
        StateNode childC = nodes.get("c");
        StateNode newParentNode = nodes.remove(newParent);
        StateNode childNode = nodes.remove(child);
        StateNode nodeWithListener = nodes.values().iterator().next();
        nodeWithListener.addAttachListener((Command & Serializable)() -> this.addChild(newParentNode, childNode));
        ArrayList attachDetachEvents = new ArrayList();
        childNode.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(childNode.getParent()));
        childNode.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(parent, childC);
        this.addChild(tree.getRootNode(), parent);
        if (expectSingleEvent) {
            Assert.assertEquals((long)1L, (long)attachDetachEvents.size());
            Assert.assertEquals((Object)newParentNode, attachDetachEvents.get(0));
        } else {
            Assert.assertEquals((long)3L, (long)attachDetachEvents.size());
            Assert.assertEquals((Object)parent, attachDetachEvents.get(0));
            Assert.assertEquals((Object)Boolean.FALSE, attachDetachEvents.get(1));
            Assert.assertEquals((Object)newParentNode, attachDetachEvents.get(2));
        }
        Assert.assertEquals((Object)newParentNode, (Object)childNode.getParent());
    }

    private void assertDetachAttachEvents(Map<String, StateNode> nodes, String newParent, String child) {
        TestStateTree tree = new TestStateTree();
        StateNode childA = nodes.get("a");
        StateNode childB = nodes.get("b");
        StateNode childC = nodes.get("c");
        StateNode newParentNode = nodes.remove(newParent);
        StateNode childNode = nodes.remove(child);
        StateNode nodeWithListener = nodes.values().iterator().next();
        nodeWithListener.addDetachListener((Command & Serializable)() -> this.addChild(newParentNode, childNode));
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(parent, childC);
        this.addChild(tree.getRootNode(), parent);
        ArrayList attachDetachEvents = new ArrayList();
        childNode.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(childNode.getParent()));
        childNode.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        this.removeFromParent(parent);
        Assert.assertEquals((long)1L, (long)attachDetachEvents.size());
        Assert.assertFalse((boolean)((Boolean)attachDetachEvents.get(0)));
    }

    private Map<String, StateNode> createNodes() {
        return Stream.of(StateNodeTest.createParentNode("a"), StateNodeTest.createParentNode("b"), StateNodeTest.createParentNode("c")).collect(Collectors.toMap(node -> node.toString(), Function.identity()));
    }

    private void addChild(StateNode parent, StateNode node) {
        this.removeFromParent(node);
        ElementChildrenList list = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
        list.add(list.size(), node);
    }

    private void removeFromParent(StateNode node) {
        if (node.getParent() == null) {
            return;
        }
        ElementChildrenList list = (ElementChildrenList)node.getParent().getFeature(ElementChildrenList.class);
        for (int i = 0; i < list.size(); ++i) {
            StateNode child = list.get(i);
            if (!node.equals(child)) continue;
            list.remove(i);
            break;
        }
    }

    private void assertCollectChanges_initiallyInactive(StateNode stateNode, ElementPropertyMap properties, Consumer<Boolean> activityUpdater) {
        TestStateTree tree = (TestStateTree)stateNode.getOwner();
        tree.dirtyNodes.clear();
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        activityUpdater.accept(false);
        properties.setProperty("foo", (Serializable)((Object)"bar"));
        boolean visibilityChanged = !visibility.isVisible();
        ArrayList changes = new ArrayList();
        stateNode.collectChanges(changes::add);
        if (visibilityChanged) {
            Assert.assertEquals((long)1L, (long)tree.dirtyNodes.size());
            MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)stateNode));
        } else {
            Assert.assertEquals((long)2L, (long)tree.dirtyNodes.size());
            stateNode.visitNodeTree(node -> MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)node)));
        }
        Assert.assertEquals((long)(visibilityChanged ? 3L : 2L), (long)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        Optional<MapPutChange> tagFound = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals("tag")).findFirst();
        Assert.assertTrue((String)"No tag change found", (boolean)tagFound.isPresent());
        MapPutChange tagChange = tagFound.get();
        MapPutChange change = (MapPutChange)changes.get(1);
        if (visibilityChanged) {
            MatcherAssert.assertThat((Object)((NodeChange)changes.get(2)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
            change = tagChange.equals(change) ? (MapPutChange)changes.get(2) : change;
        }
        Assert.assertEquals((Object)Element.get((StateNode)stateNode).getTag(), (Object)tagChange.getValue());
        if (visibilityChanged) {
            Assert.assertEquals((Object)Boolean.FALSE, (Object)change.getValue());
        }
        changes.clear();
        activityUpdater.accept(true);
        properties.setProperty("baz", (Serializable)((Object)"foo"));
        stateNode.collectChanges(changes::add);
        Assert.assertEquals((long)(visibilityChanged ? 3L : 2L), (long)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        Optional<MapPutChange> visibilityChange = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getFeature().equals(ElementData.class)).findFirst();
        if (visibilityChanged) {
            Assert.assertTrue((boolean)visibilityChange.isPresent());
            Assert.assertTrue((boolean)((Boolean)visibilityChange.get().getValue()));
            changes.remove(visibilityChange.get());
        }
        Optional<MapPutChange> fooUpdate = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals("foo")).findFirst();
        Assert.assertTrue((boolean)fooUpdate.isPresent());
        Assert.assertEquals((Object)"bar", (Object)fooUpdate.get().getValue());
        changes.remove(fooUpdate.get());
        change = (MapPutChange)changes.get(0);
        Assert.assertEquals((Object)"foo", (Object)change.getValue());
        Assert.assertEquals((Object)"baz", (Object)change.getKey());
        changes.clear();
        stateNode.collectChanges(changes::add);
        Assert.assertEquals((long)0L, (long)changes.size());
    }

    private void assertCollectChanges_initiallyVisible(StateNode stateNode, ElementPropertyMap properties, Consumer<Boolean> activityUpdater) {
        MapPutChange propertyChange;
        MapPutChange change;
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        properties.setProperty("foo", (Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        stateNode.collectChanges(changes::add);
        Assert.assertEquals((long)2L, (long)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        changes.clear();
        TestStateTree tree = (TestStateTree)stateNode.getOwner();
        tree.dirtyNodes.clear();
        activityUpdater.accept(false);
        properties.setProperty("foo", (Serializable)((Object)"baz"));
        stateNode.collectChanges(changes::add);
        boolean visibilityChanged = !visibility.isVisible();
        Assert.assertEquals((long)(visibilityChanged ? 1L : 0L), (long)changes.size());
        if (visibilityChanged) {
            Assert.assertEquals((long)1L, (long)tree.dirtyNodes.size());
            MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)stateNode));
            MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
            change = (MapPutChange)changes.get(0);
            Assert.assertEquals(ElementData.class, (Object)change.getFeature());
        } else {
            Assert.assertEquals((long)2L, (long)tree.dirtyNodes.size());
            stateNode.visitNodeTree(node -> MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)node)));
        }
        changes.clear();
        activityUpdater.accept(true);
        stateNode.collectChanges(changes::add);
        Assert.assertEquals((long)(visibilityChanged ? 2L : 1L), (long)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        change = (MapPutChange)changes.get(0);
        if (visibilityChanged) {
            MapPutChange visibilityChange = ElementData.class.equals((Object)change.getFeature()) ? change : (MapPutChange)changes.get(1);
            propertyChange = change.equals(visibilityChange) ? (MapPutChange)changes.get(1) : change;
        } else {
            propertyChange = change;
        }
        Assert.assertEquals(ElementPropertyMap.class, (Object)propertyChange.getFeature());
        Assert.assertEquals((Object)"baz", (Object)propertyChange.getValue());
        changes.clear();
        stateNode.collectChanges(changes::add);
        Assert.assertEquals((long)0L, (long)changes.size());
    }

    private static class TestStateNode
    extends StateNode {
        private int i = -1;

        public TestStateNode() {
            super(new Class[]{ElementChildrenList.class});
        }

        public void setData(int data) {
            this.i = data;
        }

        public int getData() {
            return this.i;
        }

        public String toString() {
            return Integer.toString(this.getData());
        }
    }

    private static class TestStateTree
    extends StateTree {
        private Set<StateNode> dirtyNodes;

        public TestStateTree() {
            super(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        }

        public void markAsDirty(StateNode node) {
            super.markAsDirty(node);
            if (this.dirtyNodes == null) {
                this.dirtyNodes = new HashSet<StateNode>();
            }
            this.dirtyNodes.add(node);
        }
    }
}

