/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DebounceSettings;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class DomEventTest {
    @Test
    public void bareAnnotation() {
        this.assertSettings(BareAnnotation.class, null, 0, new DebouncePhase[0]);
    }

    @Test
    public void filter() {
        this.assertSettings(FilterEvent.class, "a == b", 0, new DebouncePhase[0]);
    }

    @Test
    public void debouncePhases() {
        this.assertSettings(DebounceTimeoutPhasesEvent.class, "1", 200, DebouncePhase.INTERMEDIATE, DebouncePhase.TRAILING);
    }

    @Test(expected=IllegalStateException.class)
    public void emptyPhases() {
        this.getEventSettings(DebounceEmptyPhasesEvent.class);
    }

    @Test
    public void debounceFilter() {
        this.assertSettings(DebounceFilterEvent.class, "filter(event)", 300, DebouncePhase.TRAILING);
    }

    private <T extends ComponentEvent<Component>> void assertSettings(Class<T> eventType, final String expectedFilter, int expectedTimeout, DebouncePhase ... expectedPhases) {
        JsonNode settings = this.getEventSettings(eventType);
        if (expectedFilter == null) {
            Assert.assertEquals(new ArrayList(0), (Object)JacksonUtils.getKeys((JsonNode)settings));
            return;
        }
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(expectedFilter);
            }
        }, (Object)JacksonUtils.getKeys((JsonNode)settings));
        if (expectedTimeout == 0 && expectedPhases.length == 0) {
            Assert.assertEquals((String)"There should be a boolean instead of empty phase list", (Object)JsonNodeType.BOOLEAN, (Object)settings.get(expectedFilter).getNodeType());
            boolean isFilter = settings.get(expectedFilter).booleanValue();
            Assert.assertTrue((String)"Expression should be used as a filter", (boolean)isFilter);
            return;
        }
        ArrayNode filterSettings = (ArrayNode)settings.get(expectedFilter);
        Assert.assertEquals((long)1L, (long)filterSettings.size());
        ArrayNode filterSetting = (ArrayNode)filterSettings.get(0);
        Assert.assertEquals((String)"Debunce timeout should be as expected", (long)expectedTimeout, (long)filterSetting.get(0).intValue());
        Assert.assertEquals((String)"Number of phases should be as expected", (long)expectedPhases.length, (long)(filterSetting.size() - 1));
        for (int i = 0; i < expectedPhases.length; ++i) {
            String expectedIdentifier = expectedPhases[i].getIdentifier();
            Assert.assertEquals((Object)expectedIdentifier, (Object)filterSetting.get(i + 1).textValue());
        }
    }

    private <T extends ComponentEvent<Component>> JsonNode getEventSettings(Class<T> eventType) {
        Component component = new Component(new Element("element")){};
        component.addListener(eventType, (ComponentEventListener & Serializable)e -> {});
        ElementListenerMap elementListenerMap = (ElementListenerMap)component.getElement().getNode().getFeature(ElementListenerMap.class);
        ArrayList changes = new ArrayList();
        elementListenerMap.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        MapPutChange change = (MapPutChange)changes.get(0);
        Assert.assertEquals((Object)"event", (Object)change.getKey());
        ConstantPoolKey value = (ConstantPoolKey)change.getValue();
        ObjectNode constantPoolUpdate = JacksonUtils.createObjectNode();
        value.export(constantPoolUpdate);
        List keys = JacksonUtils.getKeys((JsonNode)constantPoolUpdate);
        Assert.assertEquals((long)1L, (long)keys.size());
        return constantPoolUpdate.get((String)keys.get(0));
    }

    @DomEvent(value="event")
    public static class BareAnnotation
    extends ComponentEvent<Component> {
        public BareAnnotation(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="event", filter="a == b")
    public static class FilterEvent
    extends ComponentEvent<Component> {
        public FilterEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="event", debounce=@DebounceSettings(timeout=200, phases={DebouncePhase.INTERMEDIATE, DebouncePhase.TRAILING}))
    public static class DebounceTimeoutPhasesEvent
    extends ComponentEvent<Component> {
        public DebounceTimeoutPhasesEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="event", debounce=@DebounceSettings(timeout=200, phases={}))
    public static class DebounceEmptyPhasesEvent
    extends ComponentEvent<Component> {
        public DebounceEmptyPhasesEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="event", filter="filter(event)", debounce=@DebounceSettings(timeout=300, phases={DebouncePhase.TRAILING}))
    public static class DebounceFilterEvent
    extends ComponentEvent<Component> {
        public DebounceFilterEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }
}

