/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public final class BundleUtils {
    private static volatile ObjectNode cachedStatsJson = null;

    private BundleUtils() {
    }

    public static Set<String> loadBundleImports() {
        ObjectNode statsJson = BundleUtils.loadStatsJson();
        if (!statsJson.has("bundleImports")) {
            return null;
        }
        HashSet<String> bundledImports = new HashSet<String>();
        JsonNode bundleImports = statsJson.get("bundleImports");
        for (int i = 0; i < bundleImports.size(); ++i) {
            String jsImport = bundleImports.get(i).textValue();
            bundledImports.add(jsImport);
            bundledImports.add(jsImport.replace("/theme/lumo/", "/src/"));
            bundledImports.add(jsImport.replace("/theme/material/", "/src/"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/theme/(lumo|material)/", "./src/"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", ""));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", ""));
        }
        return Collections.unmodifiableSet(bundledImports);
    }

    static ObjectNode loadStatsJson() {
        ObjectNode cached = cachedStatsJson;
        if (cached != null) {
            return cached;
        }
        InputStream stats = BundleUtils.class.getClassLoader().getResourceAsStream("META-INF/VAADIN/config/stats.json");
        if (stats == null) {
            cached = JacksonUtils.createObjectNode();
        } else {
            try {
                cached = JacksonUtils.readTree(StringUtil.toUTF8String(stats));
            }
            catch (IOException e) {
                BundleUtils.getLogger().warn("Unable to parse META-INF/VAADIN/config/stats.json", (Throwable)e);
                cached = JacksonUtils.createObjectNode();
            }
        }
        cachedStatsJson = cached;
        return cached;
    }

    public static String getChunkId(Class<? extends Component> componentClass) {
        return BundleUtils.getChunkId(componentClass.getName());
    }

    public static String getChunkId(String className) {
        return StringUtil.getHash(className, StandardCharsets.UTF_8);
    }

    public static String getChunkHash(List<String> chunkLines) {
        ArrayList<String> sortedChunkLines = new ArrayList<String>(chunkLines);
        Collections.sort(sortedChunkLines);
        return StringUtil.getHash(String.join((CharSequence)";", sortedChunkLines), StandardCharsets.UTF_8);
    }

    public static boolean isPreCompiledProductionBundle() {
        ObjectNode stats = BundleUtils.loadStatsJson();
        return stats.has("pre-compiled");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleUtils.class);
    }
}

