/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared.ui;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import tools.jackson.databind.JsonNode;

public class DependencyTest {
    @Test
    public void checkJsonSerialization_3ArgsCTor() {
        Dependency dependency = new Dependency(Dependency.Type.JAVASCRIPT, "url", LoadMode.INLINE);
        this.assertDependency(dependency);
    }

    @Test
    public void dynamicDependency_hasLazyMode() {
        Dependency dependency = new Dependency(Dependency.Type.DYNAMIC_IMPORT, "foo");
        MatcherAssert.assertThat((Object)dependency.getLoadMode(), (Matcher)CoreMatchers.equalTo((Object)LoadMode.LAZY));
    }

    @Test
    public void checkJsonSerialization_2ArgsCTor() {
        Dependency dependency = new Dependency(Dependency.Type.DYNAMIC_IMPORT, "foo");
        this.assertDependency(dependency);
    }

    private void assertDependency(Dependency dependency) {
        JsonNode dependencyJson = JacksonUtils.createNode((Object)dependency);
        MatcherAssert.assertThat((String)"No contents should be present in json now", (Object)dependencyJson.has("contents"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"Dependency type should match corresponding enum name in pojo", (Object)dependencyJson.get("type").asText(), (Matcher)Is.is((Object)dependency.getType().name()));
        MatcherAssert.assertThat((String)"Dependency url should match corresponding url in pojo", (Object)dependencyJson.get("url").asText(), (Matcher)Is.is((Object)dependency.getUrl()));
        MatcherAssert.assertThat((String)"Dependency load mode should match corresponding enum name in pojo", (Object)dependencyJson.get("loadMode").asText(), (Matcher)Is.is((Object)dependency.getLoadMode().name()));
    }
}

