/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutingTestBase;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class DefaultRouteResolverTest
extends RoutingTestBase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private RouteResolver resolver;

    @Override
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        super.init();
        this.resolver = new DefaultRouteResolver();
        CurrentInstance.clearAll();
    }

    @Test
    public void basic_route_navigation_target_resolved_correctly() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Stream.of(RoutingTestBase.RootNavigationTarget.class, RoutingTestBase.FooNavigationTarget.class, RoutingTestBase.FooBarNavigationTarget.class, RoutingTestBase.GreetingNavigationTarget.class).collect(Collectors.toSet()));
        Assert.assertEquals(RoutingTestBase.RootNavigationTarget.class, this.resolveNavigationTarget(""));
        Assert.assertEquals(RoutingTestBase.FooNavigationTarget.class, this.resolveNavigationTarget("foo"));
        Assert.assertEquals(RoutingTestBase.FooBarNavigationTarget.class, this.resolveNavigationTarget("foo/bar"));
    }

    private void setRoutes(RouteRegistry registry, Set<Class<? extends Component>> routes) {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            routes.forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
    }

    @Test
    public void no_route_found_resolves_to_null() {
        Assert.assertNull((String)"Attempting to resolve an invalid location should return null", (Object)this.resolver.resolve(new ResolveRequest(this.router, new Location("Not a configured location"))));
    }

    @Test
    public void string_url_parameter_correctly_set_to_state() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Collections.singleton(RoutingTestBase.GreetingNavigationTarget.class));
        Assert.assertEquals(Collections.singletonList("World"), this.resolveNavigationState("greeting/World").getUrlParameters().get());
    }

    @Test
    public void route_precedence_with_parameters() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Stream.of(RoutingTestBase.GreetingNavigationTarget.class, RoutingTestBase.OtherGreetingNavigationTarget.class).collect(Collectors.toSet()));
        Assert.assertEquals(RoutingTestBase.GreetingNavigationTarget.class, this.resolveNavigationTarget("greeting/World"));
        Assert.assertEquals(RoutingTestBase.OtherGreetingNavigationTarget.class, this.resolveNavigationTarget("greeting/other/World"));
    }

    @Test
    public void wrong_number_of_parameters_does_not_match() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Collections.singleton(RoutingTestBase.GreetingNavigationTarget.class));
        Assert.assertEquals(null, (Object)this.resolveNavigationState("greeting/World/something"));
        Assert.assertEquals(null, (Object)this.resolveNavigationState("greeting"));
    }

    @Test
    public void clientRouteRequest_getDefinedLayout() {
        String path = "route";
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NavigationState greeting = this.resolveNavigationState(path);
            Assert.assertEquals((String)"Layout should be returned for a non server route when matching @Layout exists", DefaultLayout.class, (Object)greeting.getRouteTarget().getTarget());
        }
    }

    @Test
    public void clientRouteRequest_getDefinedLayoutAndParentLayouts() {
        String path = "route";
        this.router.getRegistry().setLayout(DefaultWithParentLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NavigationState greeting = this.resolveNavigationState(path);
            Assert.assertEquals((String)"Layout should be returned for a non server route when matching @Layout exists", DefaultWithParentLayout.class, (Object)greeting.getRouteTarget().getTarget());
            Assert.assertEquals((String)"@ParentLayout annotation should be followed. @Layout class should not be in parent layout list.", (long)1L, (long)greeting.getRouteTarget().getParentLayouts().size());
            Assert.assertEquals((String)"@ParentLayout annotation should be followed. @Layout class should not be in parent layout list.", DefaultParentLayout.class, greeting.getRouteTarget().getParentLayouts().get(0));
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_getDefinedLayout() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route/:param", "/opt_route/:param?", "/wildcard_route/:param*", "/one/:param/two/:param2", "/foo/:param?/bar/:param2?"));
            Stream.of("route/1", "/route/abc", "/opt_route", "/opt_route/", "/opt_route/1", "/wildcard_route", "wildcard_route", "wildcard_route/", "wildcard_route/1", "/wildcard_route/1/2", "one/1/two/2", "foo/bar", "foo/a/bar", "foo/bar/b", "foo/a/bar/b").forEach(path -> {
                String msg = String.format("Layout should be returned for path '%s' a non server route when matching @Layout exists", path);
                NavigationState state = this.resolveNavigationState((String)path);
                Assert.assertNotNull((String)msg, (Object)state);
                Assert.assertEquals((String)msg, DefaultLayout.class, (Object)this.resolveNavigationState((String)path).getRouteTarget().getTarget());
            });
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_noLayout() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route/:param", "/opt_route/:param?", "/wildcard_route/:param*", "/one/:param/two/:param2", "/foo/:param?/bar/:param2?"));
            Stream.of("route", "/route/abc/def", "/unknown_route", "/opt_route/1/2", "/", "", "one/1/two/2/3", "one/two/2", "one/two/", "foo", "foo/foo/foo/bar/bar/").forEach(path -> Assert.assertNull((String)String.format("Layout should not be returned for a non server route '%s' when matching @Layout doesn't exist", path), (Object)this.resolveNavigationState((String)path)));
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_ambiguousRoutesFirstAddedWins() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route", "/route/:param?", "/foo", "/foo/:param*"));
            Stream.of("route", "foo", "foo/1").forEach(path -> {
                String msg = String.format("Layout should be returned for path '%s' a non server route when matching @Layout exists", path);
                NavigationState state = this.resolveNavigationState((String)path);
                Assert.assertNotNull((String)msg, (Object)state);
                Assert.assertEquals((String)msg, DefaultLayout.class, (Object)this.resolveNavigationState((String)path).getRouteTarget().getTarget());
            });
            Stream.of("route/1").forEach(path -> Assert.assertNull((String)String.format("Layout should not be returned for a non server route '%s' when matching @Layout doesn't exist", path), (Object)this.resolveNavigationState((String)path)));
        }
    }

    private Map<String, AvailableViewInfo> buildClientRoutes(String ... routes) {
        LinkedHashMap<String, AvailableViewInfo> clientRoutes = new LinkedHashMap<String, AvailableViewInfo>();
        for (String route : routes) {
            clientRoutes.put(route, this.createAvailableViewInfo(route));
        }
        return clientRoutes;
    }

    private AvailableViewInfo createAvailableViewInfo(String route) {
        return new AvailableViewInfo("", null, false, route, false, false, null, null, null, true, null);
    }

    @Test
    public void clientRouteRequest_noLayoutForPath_Throws() {
        this.expectedEx.expect(NotFoundException.class);
        this.expectedEx.expectMessage("No layout for client path 'route'");
        String path = "route";
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NavigationState navigationState = this.resolveNavigationState(path);
        }
    }

    private Class<? extends Component> resolveNavigationTarget(String path) {
        return this.resolveNavigationState(path).getNavigationTarget();
    }

    private NavigationState resolveNavigationState(String path) {
        return this.resolver.resolve(new ResolveRequest(this.router, new Location(path)));
    }

    @Tag(value="div")
    @Layout
    private static class DefaultLayout
    extends Component
    implements RouterLayout {
        private DefaultLayout() {
        }
    }

    @Tag(value="div")
    @Layout
    @ParentLayout(value=DefaultParentLayout.class)
    private static class DefaultWithParentLayout
    extends Component
    implements RouterLayout {
        private DefaultWithParentLayout() {
        }
    }

    @Tag(value="div")
    private static class DefaultParentLayout
    extends Component
    implements RouterLayout {
        private DefaultParentLayout() {
        }
    }
}

