/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ClientCallableHandlersTest {
    @Test
    public void attach_noFeature() {
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        StateNode stateNode = new StateNode(new Class[]{ClientCallableHandlers.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)stateNode);
        Assert.assertEquals((long)0L, (long)((ClientCallableHandlers)stateNode.getFeature(ClientCallableHandlers.class)).size());
    }

    @Test
    public void attach_noComponent() {
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        StateNode stateNode = new StateNode(new Class[]{ComponentMapping.class, ClientCallableHandlers.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)stateNode);
        Assert.assertEquals((long)0L, (long)((ClientCallableHandlers)stateNode.getFeature(ClientCallableHandlers.class)).size());
    }

    @Test
    public void nonTemplateComponentWithEventHandler() {
        UI ui = new UI();
        NonTemplateComponentWithEventHandler component = new NonTemplateComponentWithEventHandler();
        ui.add(new Component[]{component});
        ClientCallableHandlers feature = (ClientCallableHandlers)component.getElement().getNode().getFeature(ClientCallableHandlers.class);
        this.assertListFeature((SerializableNodeList<String>)feature, "publishedMethod1");
    }

    @Test
    public void nonTemplateComponentWithoutEventHandler() {
        UI ui = new UI();
        NonTemplateComponentWithoutEventHandler component = new NonTemplateComponentWithoutEventHandler();
        ui.add(new Component[]{component});
        ClientCallableHandlers feature = (ClientCallableHandlers)component.getElement().getNode().getFeature(ClientCallableHandlers.class);
        this.assertListFeature((SerializableNodeList<String>)feature, new String[0]);
    }

    private void assertListFeature(SerializableNodeList<String> feature, String ... expected) {
        Assert.assertEquals((long)expected.length, (long)feature.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)feature.get(i));
        }
    }

    private Stream<String> getDeclaredMethods(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers()) && !Modifier.isPrivate(method.getModifiers())).map(Method::getName);
    }

    @Tag(value="div")
    static class NonTemplateComponentWithEventHandler
    extends Component {
        NonTemplateComponentWithEventHandler() {
        }

        @ClientCallable
        public void publishedMethod1() {
        }
    }

    @Tag(value="div")
    static class NonTemplateComponentWithoutEventHandler
    extends Component {
        NonTemplateComponentWithoutEventHandler() {
        }
    }
}

