/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.SerializableTriConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.TransferUtil;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.shared.Registration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractDownloadHandlerTest {
    private static final long TOTAL_BYTES = 100L;
    private static final long TRANSFERRED_BYTES = 42L;
    private static final IOException EXCEPTION = new IOException("Test error");
    private AbstractDownloadHandler<?> handler;
    private TransferContext mockContext;
    private TransferProgressListener listener;
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private DownloadEvent downloadEvent;
    private ByteArrayOutputStream outputStream;
    private Element owner;
    private UI ui;

    @Before
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.ui = (UI)Mockito.mock(UI.class);
        ((UI)Mockito.doAnswer(invocation -> {
            Command command = (Command)invocation.getArgument(0);
            command.execute();
            return null;
        }).when((Object)this.ui)).access((Command)Mockito.any(Command.class));
        this.owner = (Element)Mockito.mock(Element.class);
        Component componentOwner = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.owner.getComponent()).thenReturn(Optional.of(componentOwner));
        Mockito.when((Object)componentOwner.getUI()).thenReturn(Optional.of(this.ui));
        this.downloadEvent = new DownloadEvent(this.request, this.response, this.session, this.owner);
        this.handler = new AbstractDownloadHandler<AbstractDownloadHandler>(){

            public void handleDownloadRequest(DownloadEvent event) {
            }
        };
        this.mockContext = (TransferContext)Mockito.mock(TransferContext.class);
        Mockito.when((Object)this.mockContext.contentLength()).thenReturn((Object)100L);
        this.listener = (TransferProgressListener)Mockito.mock(TransferProgressListener.class);
        Mockito.when((Object)this.mockContext.owningElement()).thenReturn((Object)this.owner);
        Mockito.when((Object)this.mockContext.getUI()).thenReturn((Object)this.ui);
        this.outputStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.outputStream);
    }

    @Test
    public void addTransferProgressListener_listenerAdded_listenerInvoked_listenerRemoved_listenerNotInvoked() {
        Registration registration = this.handler.addTransferProgressListener(this.listener);
        this.handler.getListeners().forEach(l -> l.onStart(this.mockContext));
        ((TransferProgressListener)Mockito.verify((Object)this.listener)).onStart(this.mockContext);
        Mockito.reset((Object[])new TransferProgressListener[]{this.listener});
        registration.remove();
        this.handler.getListeners().forEach(l -> l.onStart(this.mockContext));
        ((TransferProgressListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)0))).onStart(this.mockContext);
    }

    @Test
    public void whenStart_onStartCalled() {
        SerializableRunnable startHandler = (SerializableRunnable)Mockito.mock(SerializableRunnable.class);
        this.handler.whenStart(startHandler);
        this.handler.getListeners().forEach(listener -> listener.onStart(this.mockContext));
        ((SerializableRunnable)Mockito.verify((Object)startHandler)).run();
    }

    @Test
    public void whenProgress_onProgressCalled() {
        SerializableBiConsumer onProgressHandler = (SerializableBiConsumer)Mockito.mock(SerializableBiConsumer.class);
        this.handler.onProgress(onProgressHandler);
        this.handler.getListeners().forEach(listener -> listener.onProgress(this.mockContext, 42L, 100L));
        ((SerializableBiConsumer)Mockito.verify((Object)onProgressHandler)).accept((Object)42L, (Object)100L);
    }

    @Test
    public void multipleHooks_multipleListenersAdded_InvokedInOrder() {
        ArrayList executionOrder = new ArrayList();
        this.handler.whenStart((SerializableRunnable & Serializable)() -> executionOrder.add("first"));
        this.handler.whenStart((SerializableRunnable & Serializable)() -> executionOrder.add("second"));
        this.handler.getListeners().forEach(listener -> listener.onStart(this.mockContext));
        List<String> expectedOrder = List.of("first", "second");
        Assert.assertEquals(expectedOrder, executionOrder);
    }

    @Test
    public void whenComplete() {
        SerializableConsumer completeHandler = (SerializableConsumer)Mockito.mock(SerializableConsumer.class);
        this.handler.whenComplete(completeHandler);
        this.handler.getListeners().forEach(listener -> {
            listener.onComplete(this.mockContext, 42L);
            listener.onError(this.mockContext, EXCEPTION);
        });
        ((SerializableConsumer)Mockito.verify((Object)completeHandler)).accept((Object)true);
        ((SerializableConsumer)Mockito.verify((Object)completeHandler)).accept((Object)false);
    }

    @Test
    public void transferProgressListener_transfer_sessionNotLocked() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Hello".getBytes(StandardCharsets.UTF_8));
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        TransferContext context = (TransferContext)Mockito.mock(TransferContext.class);
        Mockito.when((Object)context.session()).thenReturn((Object)session);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ArrayList listeners = new ArrayList();
        TransferUtil.transfer((InputStream)inputStream, (OutputStream)outputStream, (TransferContext)context, listeners);
        ((VaadinSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)0))).lock();
    }

    @Test
    public void customHandlerWithShorthandCompleteListener_noErrorInTransfer_success_errorInTransfer_failure() throws IOException {
        AtomicBoolean successAtomic = new AtomicBoolean(false);
        AbstractDownloadHandler customHandler = (AbstractDownloadHandler)new AbstractDownloadHandler<AbstractDownloadHandler>(){

            public void handleDownloadRequest(DownloadEvent event) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream("Hello".getBytes(StandardCharsets.UTF_8));
                TransferContext context = this.getTransferContext(event);
                try {
                    TransferUtil.transfer((InputStream)inputStream, (OutputStream)event.getOutputStream(), (TransferContext)context, (Collection)this.getListeners());
                }
                catch (IOException e) {
                    this.getListeners().forEach(listener -> listener.onError(context, e));
                }
            }
        }.whenComplete((SerializableConsumer & Serializable)success -> successAtomic.set((boolean)success));
        customHandler.handleDownloadRequest(this.downloadEvent);
        Assert.assertTrue((boolean)successAtomic.get());
        Assert.assertEquals((Object)"Hello", (Object)this.outputStream.toString(StandardCharsets.UTF_8));
        Assert.assertNull((Object)this.downloadEvent.getException());
        OutputStream outputStreamError = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test error")}).when((Object)outputStreamError)).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Mockito.when((Object)this.downloadEvent.getOutputStream()).thenReturn((Object)outputStreamError);
        customHandler.handleDownloadRequest(this.downloadEvent);
        Assert.assertFalse((boolean)successAtomic.get());
        Assert.assertNull((Object)this.downloadEvent.getException());
    }

    @Test
    public void doesNotRequireToCatchIOException() {
        DownloadHandler & Serializable handler = (DownloadHandler & Serializable)event -> new FileInputStream(new File("foo"));
    }

    @Test
    public void inline_attachmentUsedByDefault() {
        Assert.assertFalse((boolean)this.handler.isInline());
    }

    @Test
    public void inline_inlinedWhenExplicitlyCalled() {
        this.handler.inline();
        Assert.assertTrue((boolean)this.handler.isInline());
    }

    @Test
    public void getTransferContext_returnsExpectedContextFromEvent() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Element owner = (Element)Mockito.mock(Element.class);
        DownloadEvent event = new DownloadEvent(request, response, session, owner);
        event.setContentLength(1024L);
        event.setFileName("test.txt");
        AbstractDownloadHandler<AbstractDownloadHandler> handler = new AbstractDownloadHandler<AbstractDownloadHandler>(){

            public void handleDownloadRequest(DownloadEvent event) throws IOException {
            }
        };
        TransferContext context = handler.getTransferContext(event);
        Assert.assertEquals((Object)owner, (Object)context.owningElement());
        Assert.assertEquals((Object)session, (Object)context.session());
        Assert.assertEquals((Object)request, (Object)context.request());
        Assert.assertEquals((Object)response, (Object)context.response());
        Assert.assertEquals((long)1024L, (long)context.contentLength());
        Assert.assertEquals((Object)"test.txt", (Object)context.fileName());
        Assert.assertNull((Object)event.getException());
    }

    @Test
    public void whenStartWithContext_onStartCalled() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.handler.whenStart((SerializableConsumer & Serializable)context -> invoked.set(true));
        this.handler.getListeners().forEach(listener -> listener.onStart(this.mockContext));
        Assert.assertTrue((String)"Start with context should be invoked", (boolean)invoked.get());
    }

    @Test
    public void whenProgressWithContext_onProgressCalled() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.handler.onProgress((SerializableTriConsumer & Serializable)(context, current, total) -> invoked.set(true), 1024L);
        this.handler.getListeners().forEach(listener -> listener.onProgress(this.mockContext, 42L, 100L));
        Assert.assertTrue((String)"Progress with context should be invoked", (boolean)invoked.get());
    }

    @Test
    public void whenProgressWithContextNoInterval_onProgressCalled() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.handler.onProgress((SerializableTriConsumer & Serializable)(context, current, total) -> invoked.set(true));
        this.handler.getListeners().forEach(listener -> listener.onProgress(this.mockContext, 42L, 100L));
        Assert.assertTrue((String)"Progress with context and interval should be invoked", (boolean)invoked.get());
    }

    @Test
    public void whenCompleteWithContext() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.handler.whenComplete((SerializableBiConsumer & Serializable)(context, success) -> invoked.set(true));
        this.handler.getListeners().forEach(listener -> {
            listener.onComplete(this.mockContext, 42L);
            listener.onError(this.mockContext, EXCEPTION);
        });
        Assert.assertTrue((String)"Progress with context should be invoked", (boolean)invoked.get());
    }
}

